/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.Format;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.RTPControl;
import javax.media.rtp.ReceptionStats;
import net.sf.fmj.media.rtp.RecvSSRCInfo;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.util.RTPInfo;

public abstract class RTPControlImpl
implements RTPControl,
RTPInfo {
    String cname = null;
    Hashtable codeclist = new Hashtable(5);
    int rtptime = 0;
    int seqno = 0;
    int payload = -1;
    String codec = "";
    Format currentformat = null;
    SSRCInfo stream = null;

    public void addFormat(Format info, int payload) {
        this.codeclist.put(new Integer(payload), info);
    }

    public abstract String getCNAME();

    public Component getControlComponent() {
        return null;
    }

    public Format getFormat() {
        return this.currentformat;
    }

    public Format getFormat(int payload) {
        return (Format)this.codeclist.get(new Integer(payload));
    }

    public Format[] getFormatList() {
        Format[] infolist = new Format[this.codeclist.size()];
        int i = 0;
        Enumeration e = this.codeclist.elements();
        while (e.hasMoreElements()) {
            Format f = (Format)e.nextElement();
            infolist[i++] = (Format)f.clone();
        }
        return infolist;
    }

    public GlobalReceptionStats getGlobalStats() {
        return null;
    }

    public ReceptionStats getReceptionStats() {
        if (this.stream == null) {
            return null;
        }
        RecvSSRCInfo recvstream = (RecvSSRCInfo)this.stream;
        return recvstream.getSourceReceptionStats();
    }

    public abstract int getSSRC();

    public void setRTPInfo(int rtptime, int seqno) {
        this.rtptime = rtptime;
        this.seqno = seqno;
    }

    public String toString() {
        String s = "\n\tRTPTime is " + this.rtptime + "\n\tSeqno is " + this.seqno;
        s = this.codeclist != null ? s + "\n\tCodecInfo is " + this.codeclist.toString() : s + "\n\tcodeclist is null";
        return s;
    }
}

