/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;

public abstract class SnacCmdFactoryList {
    private Map<CmdType, SnacCmdFactory> factories = new HashMap<CmdType, SnacCmdFactory>();

    public final synchronized void register(CmdType type, SnacCmdFactory factory) {
        DefensiveTools.checkNull((Object)type, (String)"type");
        if (!factory.getSupportedTypes().contains(type)) {
            return;
        }
        this.factories.put(type, factory);
    }

    public final synchronized void registerAll(SnacCmdFactory factory) {
        DefensiveTools.checkNull((Object)factory, (String)"factory");
        for (CmdType type : factory.getSupportedTypes()) {
            this.factories.put(type, factory);
        }
    }

    public final synchronized void unregister(CmdType type, SnacCmdFactory factory) {
        DefensiveTools.checkNull((Object)type, (String)"type");
        SnacCmdFactory other = this.factories.get(type);
        if (other == factory) {
            this.factories.remove(type);
        }
    }

    public final synchronized void unregisterAll(SnacCmdFactory factory) {
        DefensiveTools.checkNull((Object)factory, (String)"factory");
        Collection<SnacCmdFactory> c = this.factories.values();
        while (c.remove(factory)) {
        }
    }

    public final synchronized void unregisterAll() {
        this.factories.clear();
    }

    public final synchronized SnacCmdFactory getFactory(CmdType type) {
        DefensiveTools.checkNull((Object)type, (String)"type");
        return this.factories.get(type);
    }
}

