/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.jrrd;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.jrobin.core.jrrd.Archive;
import org.jrobin.core.jrrd.ConsolidationFunctionType;
import org.jrobin.core.jrrd.DataChunk;
import org.jrobin.core.jrrd.DataSource;
import org.jrobin.core.jrrd.Header;
import org.jrobin.core.jrrd.RRDException;
import org.jrobin.core.jrrd.RRDFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RRDatabase {
    RRDFile rrdFile;
    private String name;
    Header header;
    ArrayList<DataSource> dataSources;
    ArrayList<Archive> archives;
    Date lastUpdate;

    public RRDatabase(String string) throws IOException {
        this(new File(string));
    }

    public RRDatabase(File file) throws IOException {
        Object object;
        int n;
        this.name = file.getName();
        this.rrdFile = new RRDFile(file);
        this.header = new Header(this.rrdFile);
        this.dataSources = new ArrayList();
        for (n = 0; n < this.header.dsCount; ++n) {
            object = new DataSource(this.rrdFile);
            this.dataSources.add((DataSource)object);
        }
        this.archives = new ArrayList();
        for (n = 0; n < this.header.rraCount; ++n) {
            object = new Archive(this);
            this.archives.add((Archive)object);
        }
        this.rrdFile.align();
        this.lastUpdate = new Date((long)this.rrdFile.readInt() * 1000L);
        for (n = 0; n < this.header.dsCount; ++n) {
            object = this.dataSources.get(n);
            ((DataSource)object).loadPDPStatusBlock(this.rrdFile);
        }
        for (n = 0; n < this.header.rraCount; ++n) {
            object = this.archives.get(n);
            ((Archive)object).loadCDPStatusBlocks(this.rrdFile, this.header.dsCount);
        }
        for (n = 0; n < this.header.rraCount; ++n) {
            object = this.archives.get(n);
            ((Archive)object).loadCurrentRow(this.rrdFile);
        }
        for (n = 0; n < this.header.rraCount; ++n) {
            object = this.archives.get(n);
            ((Archive)object).loadData(this.rrdFile, this.header.dsCount);
        }
    }

    public Header getHeader() {
        return this.header;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public DataSource getDataSource(int n) {
        return this.dataSources.get(n);
    }

    public Iterator<DataSource> getDataSources() {
        return this.dataSources.iterator();
    }

    public Archive getArchive(int n) {
        return this.archives.get(n);
    }

    public Iterator<Archive> getArchives() {
        return this.archives.iterator();
    }

    public int getNumArchives() {
        return this.header.rraCount;
    }

    public Iterator<Archive> getArchives(ConsolidationFunctionType consolidationFunctionType) {
        return this.getArchiveList(consolidationFunctionType).iterator();
    }

    ArrayList<Archive> getArchiveList(ConsolidationFunctionType consolidationFunctionType) {
        ArrayList<Archive> arrayList = new ArrayList<Archive>();
        for (int i = 0; i < this.archives.size(); ++i) {
            Archive archive = this.archives.get(i);
            if (!archive.getType().equals(consolidationFunctionType)) continue;
            arrayList.add(archive);
        }
        return arrayList;
    }

    public void close() throws IOException {
        this.rrdFile.close();
    }

    public void printInfo(PrintStream printStream) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0000000000E0");
        this.printInfo(printStream, decimalFormat);
    }

    public DataChunk getData(ConsolidationFunctionType consolidationFunctionType) throws RRDException, IOException {
        return this.getData(consolidationFunctionType, 1L);
    }

    public DataChunk getData(ConsolidationFunctionType consolidationFunctionType, long l) throws RRDException, IOException {
        ArrayList<Archive> arrayList = this.getArchiveList(consolidationFunctionType);
        if (arrayList.size() == 0) {
            throw new RRDException("Database does not contain an Archive of consolidation function type " + consolidationFunctionType);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(5, -1);
        long l2 = calendar.getTime().getTime() / 1000L;
        long l3 = calendar2.getTime().getTime() / 1000L;
        Archive archive = this.findBestArchive(l3, l2, l, arrayList);
        l = this.header.pdpStep * archive.pdpCount;
        l3 -= l3 % l;
        if (l2 % l != 0L) {
            l2 += l - l2 % l;
        }
        int n = (int)((l2 - l3) / l + 1L);
        long l4 = this.lastUpdate.getTime() / 1000L;
        long l5 = l4 - l4 % l;
        long l6 = l5 - l * (long)(archive.rowCount - 1);
        int n2 = (int)((l3 - l6) / l);
        int n3 = (int)((l5 - l2) / l);
        DataChunk dataChunk = new DataChunk(l3, n2, n3, l, this.header.dsCount, n);
        archive.loadData(dataChunk);
        return dataChunk;
    }

    private Archive findBestArchive(long l, long l2, long l3, ArrayList<Archive> arrayList) {
        Archive archive = null;
        Archive archive2 = null;
        Archive archive3 = null;
        long l4 = this.lastUpdate.getTime() / 1000L;
        boolean bl = true;
        boolean bl2 = true;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        for (int i = 0; i < arrayList.size(); ++i) {
            archive = arrayList.get(i);
            long l8 = l4 - l4 % (long)(archive.pdpCount * this.header.pdpStep);
            long l9 = l8 - (long)(archive.pdpCount * archive.rowCount * this.header.pdpStep);
            long l10 = l2 - l;
            if (l8 >= l2 && l9 < l) {
                l7 = Math.abs(l3 - (long)(this.header.pdpStep * archive.pdpCount));
                if (!bl2 && l7 >= l6) continue;
                bl2 = false;
                l6 = l7;
                archive2 = archive;
                continue;
            }
            long l11 = l10;
            if (l9 > l) {
                l11 -= l9 - l;
            }
            if (l8 < l2) {
                l11 -= l2 - l8;
            }
            if (!bl && l5 >= l11) continue;
            bl = false;
            l5 = l11;
            archive3 = archive;
        }
        if (!bl2) {
            archive = archive2;
        } else if (!bl) {
            archive = archive3;
        }
        return archive;
    }

    public void printInfo(PrintStream printStream, NumberFormat numberFormat) {
        printStream.print("filename = \"");
        printStream.print(this.name);
        printStream.println("\"");
        printStream.print("rrd_version = \"");
        printStream.print(this.header.version);
        printStream.println("\"");
        printStream.print("step = ");
        printStream.println(this.header.pdpStep);
        printStream.print("last_update = ");
        printStream.println(this.lastUpdate.getTime() / 1000L);
        for (DataSource object : this.dataSources) {
            object.printInfo(printStream, numberFormat);
        }
        int n = 0;
        for (Archive archive : this.archives) {
            archive.printInfo(printStream, numberFormat, n++);
        }
    }

    public void toXml(PrintStream printStream) {
        Object object;
        int n;
        printStream.println("<!--");
        printStream.println("  -- Round Robin RRDatabase Dump ");
        printStream.println("  -- Generated by jRRD <ciaran@codeloop.com>");
        printStream.println("  -->");
        printStream.println("<rrd>");
        printStream.print("\t<version> ");
        printStream.print(this.header.version);
        printStream.println(" </version>");
        printStream.print("\t<step> ");
        printStream.print(this.header.pdpStep);
        printStream.println(" </step> <!-- Seconds -->");
        printStream.print("\t<lastupdate> ");
        printStream.print(this.lastUpdate.getTime() / 1000L);
        printStream.print(" </lastupdate> <!-- ");
        printStream.print(this.lastUpdate.toString());
        printStream.println(" -->");
        printStream.println();
        for (n = 0; n < this.header.dsCount; ++n) {
            object = this.dataSources.get(n);
            ((DataSource)object).toXml(printStream);
        }
        printStream.println("<!-- Round Robin Archives -->");
        for (n = 0; n < this.header.rraCount; ++n) {
            object = this.archives.get(n);
            ((Archive)object).toXml(printStream);
        }
        printStream.println("</rrd>");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append(this.header.toString());
        for (DataSource object : this.dataSources) {
            stringBuffer.append("\n\t");
            stringBuffer.append(object.toString());
        }
        for (Archive archive : this.archives) {
            stringBuffer.append("\n\t");
            stringBuffer.append(archive.toString());
        }
        return stringBuffer.toString();
    }
}

