/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi;

import com.hazelcast.nio.Address;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.PartitionInvocationImpl;
import com.hazelcast.spi.impl.TargetInvocationImpl;

public class InvocationBuilder {
    private final NodeEngineImpl nodeEngine;
    private final String serviceName;
    private final Operation op;
    private final int partitionId;
    private final Address target;
    private Callback<Object> callback;
    private long callTimeout = -1L;
    private int replicaIndex = 0;
    private int tryCount = 250;
    private long tryPauseMillis = 500L;

    public InvocationBuilder(NodeEngineImpl nodeEngine, String serviceName, Operation op, int partitionId) {
        this(nodeEngine, serviceName, op, partitionId, null);
    }

    public InvocationBuilder(NodeEngineImpl nodeEngine, String serviceName, Operation op, Address target) {
        this(nodeEngine, serviceName, op, -1, target);
    }

    private InvocationBuilder(NodeEngineImpl nodeEngine, String serviceName, Operation op, int partitionId, Address target) {
        this.nodeEngine = nodeEngine;
        this.serviceName = serviceName;
        this.op = op;
        this.partitionId = partitionId;
        this.target = target;
    }

    public InvocationBuilder setReplicaIndex(int replicaIndex) {
        if (replicaIndex < 0 || replicaIndex >= 7) {
            throw new IllegalArgumentException("Replica index is out of range [0-6]");
        }
        this.replicaIndex = replicaIndex;
        return this;
    }

    public InvocationBuilder setTryCount(int tryCount) {
        this.tryCount = tryCount;
        return this;
    }

    public InvocationBuilder setTryPauseMillis(long tryPauseMillis) {
        this.tryPauseMillis = tryPauseMillis;
        return this;
    }

    public InvocationBuilder setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Operation getOp() {
        return this.op;
    }

    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public long getTryPauseMillis() {
        return this.tryPauseMillis;
    }

    public Address getTarget() {
        return this.target;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public long getCallTimeout() {
        return this.callTimeout;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public InvocationBuilder setCallback(Callback<Object> callback) {
        this.callback = callback;
        return this;
    }

    public Invocation build() {
        if (this.target == null) {
            return new PartitionInvocationImpl(this.nodeEngine, this.serviceName, this.op, this.partitionId, this.replicaIndex, this.tryCount, this.tryPauseMillis, this.callTimeout, this.callback);
        }
        return new TargetInvocationImpl(this.nodeEngine, this.serviceName, this.op, this.target, this.tryCount, this.tryPauseMillis, this.callTimeout, this.callback);
    }
}

