/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationServiceImpl;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerAdapter;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;

final class StreamSerializerAdapter
implements SerializerAdapter {
    private final SerializationServiceImpl service;
    private final StreamSerializer serializer;

    public StreamSerializerAdapter(SerializationServiceImpl service, StreamSerializer serializer) {
        this.service = service;
        this.serializer = serializer;
    }

    @Override
    public void write(ObjectDataOutput out, Object object) throws IOException {
        this.serializer.write(out, object);
    }

    @Override
    public Object read(ObjectDataInput in) throws IOException {
        return this.serializer.read(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] write(Object object) throws IOException {
        byte[] bytes;
        BufferObjectDataOutput out = this.service.pop();
        try {
            this.serializer.write(out, object);
            bytes = out.toByteArray();
        }
        finally {
            this.service.push(out);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read(Data data) throws IOException {
        BufferObjectDataInput in = this.service.createObjectDataInput(data);
        try {
            Object t = this.serializer.read(in);
            return t;
        }
        finally {
            IOUtil.closeResource(in);
        }
    }

    @Override
    public int getTypeId() {
        return this.serializer.getTypeId();
    }

    @Override
    public void destroy() {
        this.serializer.destroy();
    }

    @Override
    public Serializer getImpl() {
        return this.serializer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SerializerAdapter{");
        sb.append("serializer=").append(this.serializer);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamSerializerAdapter that = (StreamSerializerAdapter)o;
        return !(this.serializer != null ? !this.serializer.equals(that.serializer) : that.serializer != null);
    }

    public int hashCode() {
        return this.serializer != null ? this.serializer.hashCode() : 0;
    }
}

