/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test.demo;

import de.javawi.jstun.test.FastDiscoveryTest;
import java.net.BindException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class FastDiscoveryTestDemo
implements Runnable {
    InetAddress iaddress;
    int port;

    public FastDiscoveryTestDemo(InetAddress iaddress, int port) {
        this.iaddress = iaddress;
        this.port = port;
    }

    public FastDiscoveryTestDemo(InetAddress iaddress) {
        this.iaddress = iaddress;
        this.port = 0;
    }

    @Override
    public void run() {
        try {
            FastDiscoveryTest test = new FastDiscoveryTest(this.iaddress, this.port, "jstun.javawi.de", 3478);
            System.out.println(test.test());
        }
        catch (BindException be) {
            System.out.println(this.iaddress.toString() + ": " + be.getMessage());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            FileHandler fh = new FileHandler("logging.txt");
            fh.setFormatter(new SimpleFormatter());
            Logger.getLogger("de.javawi.jstun").addHandler(fh);
            Logger.getLogger("de.javawi.jstun").setLevel(Level.ALL);
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> iaddresses = iface.getInetAddresses();
                while (iaddresses.hasMoreElements()) {
                    InetAddress iaddress = iaddresses.nextElement();
                    if (!Class.forName("java.net.Inet4Address").isInstance(iaddress) || iaddress.isLoopbackAddress() || iaddress.isLinkLocalAddress()) continue;
                    Thread thread = new Thread(new FastDiscoveryTestDemo(iaddress));
                    thread.start();
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

