/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Queue;
import org.openymsg.network.ConnectionHandler;
import org.openymsg.network.NetworkConstants;
import org.openymsg.network.PacketBodyBuffer;
import org.openymsg.network.ServiceType;
import org.openymsg.network.Session;
import org.openymsg.network.SessionState;
import org.openymsg.network.Util;
import org.openymsg.network.YMSG9InputStream;
import org.openymsg.network.YMSG9Packet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPConnectionHandler
extends ConnectionHandler {
    private static final long IDLE_TIMEOUT = 30000L;
    private static final String HTTP_HEADER_POST = "POST http://" + Util.httpHost() + "/notify HTTP/1.0" + "\n";
    private static final String HTTP_HEADER_AGENT = "User-Agent: Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)\n";
    private static final String HTTP_HEADER_HOST = "Host: " + Util.httpHost() + "\n";
    private static final String HTTP_HEADER_PROXY_AUTH = "Proxy-Authorization: " + Util.httpProxyAuth() + "\n";
    private Session session;
    private String proxyHost;
    private int proxyPort;
    private long lastFetch;
    private final Queue<YMSG9Packet> packets;
    private boolean connected = false;
    private String cookie = null;
    private long identifier = 0L;
    private Notifier notifierThread;

    public HTTPConnectionHandler() {
        this(Util.httpProxyHost(), Util.httpProxyPort());
    }

    public HTTPConnectionHandler(String string, int n, Collection<String> collection) {
        if (string == null || string.length() == 0 || n <= 0 || n > 65535) {
            throw new IllegalArgumentException("Bad HTTP proxy properties");
        }
        this.proxyHost = string;
        this.proxyPort = n;
        this.packets = new LinkedList<YMSG9Packet>();
        this.connected = false;
        Properties properties = System.getProperties();
        properties.put("proxyHost", this.proxyHost);
        properties.put("http.proxyHost", this.proxyHost);
        properties.put("proxyPort", this.proxyPort + "");
        properties.put("http.proxyPort", this.proxyPort + "");
        properties.put("proxySet", "true");
        if (collection != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string2 : collection) {
                stringBuffer.append(string2).append('|');
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            System.getProperties().put("http.nonProxyHosts", stringBuffer.toString());
        }
    }

    public HTTPConnectionHandler(String string, int n) {
        this(string, n, null);
    }

    public static void setProxyAuthorizationProperty(String string, String string2, String string3) throws UnsupportedOperationException {
        if (!string.equalsIgnoreCase("basic")) {
            throw new UnsupportedOperationException("Method " + string + " unsupported.");
        }
        String string4 = string2 + ":" + string3;
        String string5 = "Basic " + Util.base64(string4.getBytes());
        System.setProperty("openymsg.network.httpProxyAuth", string5);
    }

    @Override
    void install(Session session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void open() {
        this.connected = true;
        HTTPConnectionHandler hTTPConnectionHandler = this;
        synchronized (hTTPConnectionHandler) {
            if (this.notifierThread == null) {
                this.notifierThread = new Notifier("HTTP Notifier");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        this.connected = false;
        HTTPConnectionHandler hTTPConnectionHandler = this;
        synchronized (hTTPConnectionHandler) {
            if (this.notifierThread != null) {
                this.notifierThread.quitFlag = true;
                this.notifierThread = null;
            }
        }
    }

    @Override
    synchronized void sendPacket(PacketBodyBuffer packetBodyBuffer, ServiceType serviceType, long l, long l2) throws IOException, IllegalStateException {
        if (!this.connected) {
            throw new IllegalStateException("Not logged in");
        }
        if (this.filterOutput(packetBodyBuffer, serviceType)) {
            return;
        }
        byte[] byArray = packetBodyBuffer.getBuffer();
        Socket socket = new Socket(this.proxyHost, this.proxyPort);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(socket.getInputStream());
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        dataOutputStream.writeBytes(HTTP_HEADER_POST);
        dataOutputStream.writeBytes("Content-length: " + (byArray.length + 20) + "\n");
        dataOutputStream.writeBytes(HTTP_HEADER_AGENT);
        dataOutputStream.writeBytes(HTTP_HEADER_HOST);
        if (HTTP_HEADER_PROXY_AUTH != null) {
            dataOutputStream.writeBytes(HTTP_HEADER_PROXY_AUTH);
        }
        if (this.cookie != null) {
            dataOutputStream.writeBytes("Cookie: " + this.cookie + "\n");
        }
        dataOutputStream.writeBytes("\n");
        dataOutputStream.write(NetworkConstants.MAGIC, 0, 4);
        dataOutputStream.write(NetworkConstants.VERSION_HTTP, 0, 4);
        dataOutputStream.writeShort(byArray.length & 0xFFFF);
        dataOutputStream.writeShort(serviceType.getValue() & 0xFFFF);
        dataOutputStream.writeInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
        dataOutputStream.writeInt((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
        dataOutputStream.write(byArray, 0, byArray.length);
        dataOutputStream.flush();
        String string = this.readLine(pushbackInputStream);
        if (string == null || string.indexOf(" 200 ") < 0) {
            throw new IOException("HTTP request returned didn't return OK (200): " + string);
        }
        while (string != null && string.trim().length() > 0) {
            string = this.readLine(pushbackInputStream);
        }
        byte[] byArray2 = new byte[4];
        int n = pushbackInputStream.read(byArray2, 0, 4);
        if (n < 4) {
            throw new IOException("Premature end of HTTP data");
        }
        int n2 = byArray2[0];
        YMSG9InputStream yMSG9InputStream = new YMSG9InputStream(pushbackInputStream);
        for (int i = 0; i < n2; ++i) {
            YMSG9Packet yMSG9Packet = yMSG9InputStream.readPacket();
            if (this.filterInput(yMSG9Packet) || this.packets.add(yMSG9Packet)) continue;
            throw new IllegalArgumentException("Unable to add data to the packetQueue!");
        }
        socket.close();
        this.lastFetch = System.currentTimeMillis();
    }

    private String readLine(PushbackInputStream pushbackInputStream) throws IOException {
        int n = pushbackInputStream.read();
        StringBuffer stringBuffer = new StringBuffer();
        while (n != 10 && n != 13) {
            stringBuffer.append((char)n);
            n = pushbackInputStream.read();
        }
        int n2 = pushbackInputStream.read();
        if (n == 10 && n2 != 13 || n == 13 && n2 != 10) {
            pushbackInputStream.unread(n2);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    YMSG9Packet receivePacket() throws IOException {
        if (!this.connected) {
            throw new IllegalStateException("Not logged in");
        }
        while (true) {
            HTTPConnectionHandler hTTPConnectionHandler = this;
            synchronized (hTTPConnectionHandler) {
                if (this.packets.size() > 0) {
                    YMSG9Packet yMSG9Packet = this.packets.poll();
                    if (yMSG9Packet instanceof IOException) {
                        throw (IOException)((Object)yMSG9Packet);
                    }
                    return yMSG9Packet;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private boolean filterOutput(PacketBodyBuffer packetBodyBuffer, ServiceType serviceType) throws UnsupportedEncodingException, IOException {
        switch (serviceType) {
            case ISBACK: 
            case LOGOFF: {
                return true;
            }
        }
        if (this.identifier > 0L) {
            packetBodyBuffer.addElement("24", this.identifier + "");
        }
        return false;
    }

    private boolean filterInput(YMSG9Packet yMSG9Packet) {
        switch (yMSG9Packet.service) {
            case LIST: {
                String[] stringArray = HTTPConnectionHandler.extractCookies(yMSG9Packet);
                this.cookie = stringArray[0] + "; " + stringArray[1];
                break;
            }
            case LOGON: {
                this.identifier = Long.parseLong(yMSG9Packet.getValue("24"));
                break;
            }
            case MESSAGE: {
                if (yMSG9Packet.getValue("14") != null) break;
                if (yMSG9Packet.getValue("10") != null) {
                    yMSG9Packet.service = ServiceType.ISBACK;
                    break;
                }
                if (yMSG9Packet.body.length != 0) break;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("HTTP connection: ").append(this.proxyHost).append(":").append(this.proxyPort);
        return stringBuffer.toString();
    }

    class Notifier
    extends Thread {
        volatile boolean quitFlag;

        Notifier(String string) {
            super(string);
            this.quitFlag = false;
            HTTPConnectionHandler.this.lastFetch = System.currentTimeMillis();
            this.start();
        }

        public void run() {
            while (!this.quitFlag) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long l = System.currentTimeMillis();
                if (this.quitFlag || !HTTPConnectionHandler.this.connected || l - HTTPConnectionHandler.this.lastFetch <= 30000L || HTTPConnectionHandler.this.session.getSessionStatus() != SessionState.LOGGED_ON) continue;
                try {
                    HTTPConnectionHandler.this.session.transmitIdle();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

