/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.utils.Hashes;
import com.voxeo.utils.Objects;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Strings {
    private static final Logger log = Logger.getLogger(Strings.class);
    private static final String FILE_SEPARATOR = File.separator;
    private static final String PATH_SEPARATOR = File.pathSeparator;
    private static final String FILE_SEPARATOR_ALIAS = "/";
    private static final String PATH_SEPARATOR_ALIAS = ":";
    private static final int NORMAL = 0;
    private static final int SEEN_DOLLAR = 1;
    private static final int IN_BRACKET = 2;
    public static final String DEFAULT_CHARSET = "UTF-8";

    public static String trim(String s) {
        return s != null ? s.trim() : null;
    }

    public static String join(Iterable<?> list, String delimiter) {
        String comma = "";
        String r = "";
        for (Object o : list) {
            r = r + comma + o;
            if (!comma.equals("")) continue;
            comma = delimiter;
        }
        return r;
    }

    public static <T> String join(T[] list, String delimiter) {
        String comma = "";
        String r = "";
        for (T o : list) {
            r = r + comma + o;
            if (!comma.equals("")) continue;
            comma = delimiter;
        }
        return r;
    }

    public static String join(Collection<?> list, String delimiter, String propertyName) {
        String comma = "";
        StringBuilder builder = new StringBuilder();
        for (Object o : list) {
            builder.append(comma);
            builder.append(Objects.getPropertyValue(o, propertyName));
            if (!comma.equals("")) continue;
            comma = delimiter;
        }
        return builder.toString();
    }

    public static String join(Iterable<?> list) {
        return Strings.join(list, ",");
    }

    public static String join(Map<? extends Object, ? extends Object> map) {
        return Strings.join(map, "=", ",");
    }

    public static String join(Map<? extends Object, ? extends Object> map, String separator, String delimiter) {
        String d = "";
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
            builder.append(d);
            builder.append(entry.getKey());
            builder.append(separator);
            builder.append(entry.getValue());
            d = delimiter;
        }
        return builder.toString();
    }

    public static String join(Properties properties, String separator, String delimiter) {
        String d = "";
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            builder.append(d);
            builder.append(entry.getKey());
            builder.append(separator);
            builder.append(entry.getValue());
            d = delimiter;
        }
        return builder.toString();
    }

    public static Map<String, String> splitKeyValue(String input, String separator, String delimiter) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        StringTokenizer entryTokenizer = new StringTokenizer(input, delimiter);
        while (entryTokenizer.hasMoreElements()) {
            String entry = entryTokenizer.nextToken();
            int sepIndex = entry.indexOf(separator);
            if (sepIndex > 0) {
                result.put(entry.substring(0, sepIndex), entry.substring(sepIndex + 1));
                continue;
            }
            result.put(entry, null);
        }
        return result;
    }

    public static Map<String, String> splitKeyValue(String input) {
        return Strings.splitKeyValue(input, "=", ";");
    }

    public static final boolean isEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static final String isEmpty(String s, String def) {
        return !Strings.isEmpty(s) ? s : def;
    }

    public static final Integer isEmpty(CharSequence s, Integer def) {
        return !Strings.isEmpty(s) ? new Integer(((Object)s).toString()) : def;
    }

    public static final Boolean isEmpty(String s, Boolean def) {
        return !Strings.isEmpty(s) ? Boolean.valueOf(s) : def;
    }

    public static boolean isBlank(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (char i : str.toCharArray()) {
            if (Character.isWhitespace((int)i)) continue;
            return false;
        }
        return true;
    }

    public static boolean anyBlank(String ... strs) {
        if (strs == null) {
            return true;
        }
        for (String str : strs) {
            if (!Strings.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static final String isNull(String s, String ... def) {
        String d = def.length > 0 ? def[0] : "";
        return Objects.isNull(s, d);
    }

    public static final String stripCommas(String s, char ... replaceWith) {
        return Strings.isNull(s, "").replace(',', replaceWith.length > 0 ? replaceWith[0] : (char)' ');
    }

    public static final String strip(CharSequence string, CharSequence regex) {
        String result = null;
        if (string != null) {
            result = ((Object)string).toString().replaceAll(((Object)regex).toString(), "");
        }
        return result;
    }

    public static final String fill(String s, int size) {
        int write;
        size = Math.max(size, 0);
        StringBuilder buf = new StringBuilder(size);
        for (int written = 0; written < size; written += write) {
            write = Math.min(s.length(), size - written);
            buf.append(s.subSequence(0, write));
        }
        return buf.toString();
    }

    public static String encode(byte[] bytes, String encoding) {
        try {
            if (bytes == null) {
                return null;
            }
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decode(String string, String encoding) {
        try {
            if (string == null) {
                return null;
            }
            return string.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeBase64(String string) {
        return Hashes.base64Decode(string.getBytes());
    }

    public static final String[] split(String input, String delimiter, int chunkSize) {
        String delimiterExpression = delimiter != null ? "(\\" + delimiter + ")|" : "";
        return input.split(delimiterExpression + "(?<=\\G.{" + chunkSize + "})");
    }

    public static final String[] split(String input, int chunkSize) {
        return Strings.split(input, null, chunkSize);
    }

    public static String maskLettersAndDigits(String input) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < input.codePointCount(0, input.length()); ++i) {
            int codePoint = input.codePointAt(i);
            if (Character.isLetterOrDigit(codePoint)) {
                builder.append('X');
                continue;
            }
            builder.append(Character.toChars(codePoint));
        }
        return builder.toString();
    }

    public static String format(String message, Object ... args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                Object o = args[i];
                if (o == null || !o.getClass().isArray()) continue;
                args[i] = Arrays.asList((Object[])o);
            }
            return String.format(message, args);
        }
        catch (Exception e) {
            String error = Strings.buildExceptionMessage(message, e, args);
            return error;
        }
    }

    private static String buildExceptionMessage(String message, Exception e, Object ... args) {
        String error = "Could not format message with format string: {" + message + "}, args: {";
        boolean useComma = false;
        for (Object arg : args) {
            if (useComma) {
                error = error + ", ";
            }
            error = error + "{" + (arg != null ? arg : "null") + "}";
        }
        log.error((Object)error, (Throwable)e);
        return error;
    }

    public static String replaceProperties(String string) {
        return Strings.replaceProperties(string, System.getProperties());
    }

    public static String replaceProperties(String string, Properties props) {
        if (string == null) {
            return null;
        }
        char[] chars = string.toCharArray();
        StringBuffer buffer = new StringBuffer();
        boolean properties = false;
        int state = 0;
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '$' && state != 2) {
                state = 1;
                continue;
            }
            if (c == '{' && state == 1) {
                buffer.append(string.substring(start, i - 1));
                state = 2;
                start = i - 1;
                continue;
            }
            if (state == 1) {
                state = 0;
                continue;
            }
            if (c != '}' || state != 2) continue;
            if (start + 2 == i) {
                buffer.append("${}");
            } else {
                String value = null;
                String key = string.substring(start + 2, i);
                if (FILE_SEPARATOR_ALIAS.equals(key)) {
                    value = FILE_SEPARATOR;
                } else if (PATH_SEPARATOR_ALIAS.equals(key)) {
                    value = PATH_SEPARATOR;
                } else {
                    String realKey;
                    int colon;
                    value = props.getProperty(key);
                    if (value == null && (colon = key.indexOf(58)) > 0 && (value = System.getProperty(realKey = key.substring(0, colon))) == null) {
                        value = key.substring(colon + 1);
                    }
                }
                if (value != null) {
                    properties = true;
                    buffer.append(value);
                }
            }
            start = i + 1;
            state = 0;
        }
        if (!properties) {
            return string;
        }
        if (start != chars.length) {
            buffer.append(string.substring(start, chars.length));
        }
        return buffer.toString();
    }

    public static int indexOfIgnoreCase(String value, String searchString) {
        return Strings.indexOfIgnoreCase(value, searchString, 0);
    }

    public static int indexOfIgnoreCase(String value, String searchString, int start) {
        for (int i = start; i <= value.length() - searchString.length(); ++i) {
            boolean match = true;
            for (int j = 0; j < searchString.length(); ++j) {
                char c1 = value.charAt(i + j);
                char c2 = searchString.charAt(j);
                if (Character.toUpperCase(c1) == Character.toUpperCase(c2)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return i;
        }
        return -1;
    }

    public static boolean endsWithIgnoreCase(String lhs, String rhs) {
        if (lhs.length() >= rhs.length()) {
            boolean match = true;
            for (int j = 0; j < rhs.length(); ++j) {
                char c1 = lhs.charAt(lhs.length() - rhs.length() + j);
                char c2 = rhs.charAt(j);
                if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) continue;
                match = false;
                break;
            }
            return match;
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(String lhs, String rhs) {
        if (lhs.length() >= rhs.length()) {
            boolean match = true;
            for (int j = 0; j < rhs.length(); ++j) {
                char c1 = lhs.charAt(j);
                char c2 = rhs.charAt(j);
                if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) continue;
                match = false;
                break;
            }
            return match;
        }
        return false;
    }

    public static boolean isInt(String string) {
        boolean result;
        boolean bl = result = !Strings.isEmpty(string);
        if (result) {
            for (char c : string.toCharArray()) {
                if (Character.isDigit(c)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static String camelToPretty(String value) {
        String result = null;
        if (value != null) {
            StringBuilder builder = new StringBuilder(value.length() + 10);
            char last = '\u0000';
            for (char ch : value.toCharArray()) {
                if (Character.isUpperCase(ch)) {
                    if (builder.length() > 0 && last != '\u0000' && !Character.isUpperCase(last)) {
                        builder.append(' ');
                    }
                    builder.append(ch);
                } else if (Character.isLowerCase(ch)) {
                    if (last == '\u0000' || Character.isWhitespace(last)) {
                        builder.append(Character.toUpperCase(ch));
                    } else {
                        builder.append(ch);
                    }
                } else {
                    builder.append(ch);
                }
                last = ch;
            }
            result = builder.toString();
        }
        return result;
    }

    public static String make(byte[] bytes, String charset) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Bad charset: " + charset, e);
        }
    }

    public static byte[] getBytes(String string, String charset) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Bad charset: " + charset, e);
        }
    }

    public static String randomAlphanumericString(int length) {
        StringBuilder result = new StringBuilder();
        Random rand = new Random();
        for (int idx = 0; idx < length; ++idx) {
            result.append(Strings.randomAlphanumericChar(rand));
        }
        return result.toString();
    }

    private static char randomAlphanumericChar(Random rand) {
        int idx = rand.nextInt(36);
        char result = idx < 10 ? (char)(48 + idx) : (char)(65 + (idx - 10));
        return result;
    }
}

