/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.FeatureProcessor;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.OpEnum;
import com.sun.speech.freetts.PathExtractor;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.util.Utilities;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PathExtractorImpl
implements PathExtractor {
    private static final Logger LOGGER = Logger.getLogger(PathExtractorImpl.class.getName());
    public static final String INTERPRET_PATHS_PROPERTY = "com.sun.speech.freetts.interpretCartPaths";
    public static final String LAZY_COMPILE_PROPERTY = "com.sun.speech.freetts.lazyCartCompile";
    private static final boolean INTERPRET_PATHS = Utilities.getProperty("com.sun.speech.freetts.interpretCartPaths", "false").equals("true");
    private static final boolean LAZY_COMPILE = Utilities.getProperty("com.sun.speech.freetts.lazyCartCompile", "true").equals("true");
    private String pathAndFeature;
    private String path;
    private String feature;
    private Object[] compiledPath;
    private boolean wantFeature = false;

    public PathExtractorImpl(String pathAndFeature, boolean wantFeature) {
        this.pathAndFeature = pathAndFeature;
        if (INTERPRET_PATHS) {
            this.path = pathAndFeature;
            return;
        }
        if (wantFeature) {
            int lastDot = pathAndFeature.lastIndexOf(".");
            if (lastDot == -1) {
                this.feature = pathAndFeature;
                this.path = null;
            } else {
                this.feature = pathAndFeature.substring(lastDot + 1);
                this.path = pathAndFeature.substring(0, lastDot);
            }
            this.wantFeature = wantFeature;
        } else {
            this.path = pathAndFeature;
        }
        if (!LAZY_COMPILE) {
            this.compiledPath = this.compile(this.path);
        }
    }

    @Override
    public Item findItem(Item item) {
        if (INTERPRET_PATHS) {
            return item.findItem(this.path);
        }
        if (this.compiledPath == null) {
            this.compiledPath = this.compile(this.path);
        }
        Item pitem = item;
        int i = 0;
        while (pitem != null && i < this.compiledPath.length) {
            OpEnum op;
            if ((op = (OpEnum)this.compiledPath[i++]) == OpEnum.NEXT) {
                pitem = pitem.getNext();
                continue;
            }
            if (op == OpEnum.PREV) {
                pitem = pitem.getPrevious();
                continue;
            }
            if (op == OpEnum.NEXT_NEXT) {
                if ((pitem = pitem.getNext()) == null) continue;
                pitem = pitem.getNext();
                continue;
            }
            if (op == OpEnum.PREV_PREV) {
                if ((pitem = pitem.getPrevious()) == null) continue;
                pitem = pitem.getPrevious();
                continue;
            }
            if (op == OpEnum.PARENT) {
                pitem = pitem.getParent();
                continue;
            }
            if (op == OpEnum.DAUGHTER) {
                pitem = pitem.getDaughter();
                continue;
            }
            if (op == OpEnum.LAST_DAUGHTER) {
                pitem = pitem.getLastDaughter();
                continue;
            }
            if (op == OpEnum.RELATION) {
                String relationName = (String)this.compiledPath[i++];
                pitem = pitem.getSharedContents().getItemRelation(relationName);
                continue;
            }
            System.out.println("findItem: bad feature " + op + " in " + this.path);
        }
        return pitem;
    }

    @Override
    public Object findFeature(Item item) {
        if (INTERPRET_PATHS) {
            return item.findFeature(this.path);
        }
        Item pitem = this.findItem(item);
        Object results = null;
        if (pitem != null) {
            FeatureProcessor fp;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("findFeature: Item [" + pitem + "], feature '" + this.feature + "'");
            }
            if ((fp = pitem.getOwnerRelation().getUtterance().getVoice().getFeatureProcessor(this.feature)) != null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("findFeature: There is a feature processor for '" + this.feature + "'");
                }
                try {
                    results = fp.process(pitem);
                }
                catch (ProcessException pe) {
                    LOGGER.severe("trouble while processing " + fp);
                    throw new Error(pe);
                }
            } else {
                results = pitem.getFeatures().getObject(this.feature);
            }
        }
        Object object = results = results == null ? "0" : results;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("findFeature: ...results = '" + results + "'");
        }
        return results;
    }

    private Object[] compile(String path) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (path == null) {
            return list.toArray();
        }
        StringTokenizer tok = new StringTokenizer(path, ":.");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            OpEnum op = OpEnum.getInstance(token);
            if (op == null) {
                throw new Error("Bad path compiled " + path);
            }
            list.add(op);
            if (op != OpEnum.RELATION) continue;
            list.add(tok.nextToken());
        }
        return list.toArray();
    }

    public String toString() {
        return this.pathAndFeature;
    }
}

