/*
 * Decompiled with CFR 0.152.
 */
package com.sun.stun;

import com.sun.stun.StunHeader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StunClient
extends Thread {
    private static final Logger logger = Logger.getLogger(StunClient.class.getName());
    private static final int TIMEOUT = 3000;
    private static final int RETRIES = 5;
    private static int timeout = 3000;
    private static int retries = 5;
    private InetSocketAddress stunServer;
    private DatagramSocket datagramSocket;
    private Socket socket;
    private DataInputStream input;
    private InetSocketAddress mappedAddress;
    private boolean done;

    public StunClient(InetSocketAddress stunServer, DatagramSocket datagramSocket) throws IOException {
        String s = System.getProperty("com.sun.stun.CLIENT_TIMEOUT");
        if (s != null && s.length() > 0) {
            try {
                timeout = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid com.sun.stun.CLIENT_TIMEOUT: " + s + ".  Defaulting to " + 3000);
            }
        }
        if ((s = System.getProperty("com.sun.stun.CLIENT_RETRIES")) != null && s.length() > 0) {
            try {
                retries = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid com.sun.stun.CLIENT_RETRIES: " + s + ".  Defaulting to " + 5);
            }
        }
        this.stunServer = stunServer;
        this.datagramSocket = datagramSocket;
        logger.fine("starting stun client to " + stunServer);
        this.start();
    }

    public StunClient(Socket socket) throws IOException {
        this.socket = socket;
        this.stunServer = new InetSocketAddress(socket.getInetAddress(), socket.getPort());
        this.input = new DataInputStream(socket.getInputStream());
        this.start();
    }

    public static void setLogLevel(Level newLevel) {
        logger.setLevel(newLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress getMappedAddress() throws IOException {
        StunClient stunClient = this;
        synchronized (stunClient) {
            while (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException("Failed to retrieve mapped address:  Interruped");
                }
            }
        }
        if (this.mappedAddress == null) {
            String s = "Failed to retrieve mapped address";
            if (this.socket != null) {
                s = s + " for " + this.socket.getLocalAddress() + ":" + this.socket.getLocalPort();
            } else if (this.datagramSocket != null) {
                s = s + " for " + this.datagramSocket.getLocalAddress() + ":" + this.datagramSocket.getLocalPort();
            }
            logger.warning(s);
            logger.warning("IF YOU ARE BEHIND A FIREWALL OR NAT, ADDRESSES ARE NOT LIKELY TO BE CORRECT!");
            throw new IOException(s);
        }
        logger.fine("mapped address is " + this.mappedAddress);
        return this.mappedAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done() {
        StunClient stunClient = this;
        synchronized (stunClient) {
            this.done = true;
            this.notifyAll();
        }
    }

    @Override
    public void run() {
        int socketTimeout;
        logger.info("using STUN server " + this.stunServer);
        try {
            if (this.datagramSocket != null) {
                socketTimeout = this.datagramSocket.getSoTimeout();
                this.datagramSocket.setSoTimeout(timeout);
            } else {
                socketTimeout = this.socket.getSoTimeout();
                this.socket.setSoTimeout(timeout);
            }
        }
        catch (SocketException e) {
            logger.warning("Unable to set socket timeout:  " + e.getMessage());
            this.done();
            return;
        }
        for (int i = 0; i < retries; ++i) {
            try {
                logger.fine("Sending stun request " + i);
                this.sendStunRequest();
                this.waitForReply();
                break;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        try {
            if (this.datagramSocket != null) {
                this.datagramSocket.setSoTimeout(socketTimeout);
            } else {
                this.socket.setSoTimeout(socketTimeout);
            }
        }
        catch (SocketException e) {
            logger.warning("Unable to reset socket timeout:  " + e.getMessage());
        }
        this.done();
    }

    private void sendStunRequest() throws IOException {
        int port;
        InetAddress addressToMap;
        this.mappedAddress = null;
        if (this.datagramSocket != null) {
            addressToMap = this.datagramSocket.getLocalAddress();
            port = this.datagramSocket.getLocalPort();
        } else {
            addressToMap = this.socket.getLocalAddress();
            port = this.socket.getLocalPort();
        }
        logger.fine("StunClient:  asking STUN server " + this.stunServer.getAddress().getHostAddress() + ":" + this.stunServer.getPort() + " to get mapping for " + addressToMap.getHostAddress() + ":" + port);
        byte[] buf = new byte[32];
        buf[1] = 1;
        buf[3] = 12;
        long time = System.currentTimeMillis();
        for (int i = 0; i < 16; ++i) {
            buf[i + 4] = (byte)(time >> i % 4 * 8);
        }
        buf[21] = 1;
        buf[23] = 8;
        buf[25] = 1;
        buf[26] = (byte)(port >> 8);
        buf[27] = (byte)(port & 0xFF);
        byte[] address = addressToMap.getAddress();
        buf[28] = address[0];
        buf[29] = address[1];
        buf[30] = address[2];
        buf[31] = address[3];
        if (this.datagramSocket != null) {
            DatagramPacket packet = new DatagramPacket(buf, buf.length, this.stunServer.getAddress(), this.stunServer.getPort());
            logger.fine("local addr " + this.datagramSocket.getLocalAddress() + " local port " + this.datagramSocket.getLocalPort());
            this.datagramSocket.send(packet);
        } else {
            DataOutputStream output = new DataOutputStream(this.socket.getOutputStream());
            output.write(buf, 0, buf.length);
            output.flush();
        }
    }

    private void waitForReply() throws IOException, SocketTimeoutException {
        byte[] response = new byte[1000];
        for (int i = 0; i < retries; ++i) {
            int length;
            if (this.datagramSocket != null) {
                DatagramPacket packet = new DatagramPacket(response, response.length);
                this.datagramSocket.receive(packet);
                length = packet.getLength();
            } else {
                length = this.input.read(response);
            }
            logger.fine("Got response!  " + length + " local addr " + this.datagramSocket.getLocalAddress() + " local port " + this.datagramSocket.getLocalPort());
            int type = response[0] << 8 & 0xFF00 | response[1] & 0xFF;
            if (type == 257) {
                this.mappedAddress = StunHeader.getAddress(response, 1);
                return;
            }
            logger.fine("BAD STUN response, length " + length + " TCP " + (this.input != null));
        }
        throw new IOException("Didn't receive BINDING_RESPONE");
    }
}

