/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.ulaw;

import java.util.logging.Logger;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.AbstractPacketizer;
import net.sf.fmj.utility.LoggerSingleton;

public class Packetizer
extends AbstractPacketizer {
    private static final Logger logger = LoggerSingleton.logger;
    protected Format[] outputFormats = new Format[]{new AudioFormat("ULAW/rtp", -1.0, 8, 1, -1, -1, 8, -1.0, Format.byteArray)};

    public Packetizer() {
        this.inputFormats = new Format[]{new AudioFormat("ULAW", -1.0, 8, 1, -1, -1, 8, -1.0, Format.byteArray)};
    }

    public void close() {
    }

    public String getName() {
        return "ULAW Packetizer";
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (!(format instanceof AudioFormat)) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + format);
            return new Format[]{null};
        }
        AudioFormat audioFormat = (AudioFormat)format;
        if (!audioFormat.getEncoding().equals("ULAW") || audioFormat.getSampleSizeInBits() != 8 && audioFormat.getSampleSizeInBits() != -1 || audioFormat.getChannels() != 1 && audioFormat.getChannels() != -1 || audioFormat.getFrameSizeInBits() != 8 && audioFormat.getFrameSizeInBits() != -1) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + format);
            return new Format[]{null};
        }
        AudioFormat audioFormat2 = new AudioFormat("ULAW/rtp", audioFormat.getSampleRate(), 8, 1, audioFormat.getEndian(), audioFormat.getSigned(), 8, audioFormat.getFrameRate(), audioFormat.getDataType());
        return new Format[]{audioFormat2};
    }

    public void open() {
        int n = (int)((AudioFormat)this.getInputFormat()).getSampleRate();
        this.setPacketSize(n / 50);
    }

    public Format setInputFormat(Format format) {
        return super.setInputFormat(format);
    }

    public Format setOutputFormat(Format format) {
        return super.setOutputFormat(format);
    }
}

