/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.util.Arrays;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.jitsi.bccontrib.macs.SkeinMac;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.srtp.AES;
import org.jitsi.impl.neomedia.transform.srtp.HMACSHA1;
import org.jitsi.impl.neomedia.transform.srtp.SRTPCipherCTR;
import org.jitsi.impl.neomedia.transform.srtp.SRTPPolicy;

class BaseSRTPCryptoContext {
    protected static final long REPLAY_WINDOW_SIZE = 64L;
    protected final byte[] authKey;
    protected final BlockCipher cipher;
    protected final SRTPCipherCTR cipherCtr = new SRTPCipherCTR();
    protected final BlockCipher cipherF8;
    protected final byte[] encKey;
    protected final byte[] ivStore = new byte[16];
    protected final Mac mac;
    protected final byte[] masterKey;
    protected final byte[] masterSalt;
    private final byte[] mki = null;
    protected final SRTPPolicy policy;
    protected final byte[] rbStore = new byte[4];
    protected long replayWindow;
    protected final byte[] saltKey;
    protected final int ssrc;
    protected final byte[] tagStore;
    protected final byte[] tempStore = new byte[100];

    protected BaseSRTPCryptoContext(int ssrc) {
        this.ssrc = ssrc;
        this.authKey = null;
        this.cipher = null;
        this.cipherF8 = null;
        this.encKey = null;
        this.mac = null;
        this.masterKey = null;
        this.masterSalt = null;
        this.policy = null;
        this.saltKey = null;
        this.tagStore = null;
    }

    protected BaseSRTPCryptoContext(int ssrc, byte[] masterK, byte[] masterS, SRTPPolicy policy) {
        byte[] tagStore;
        Mac mac;
        byte[] authKey;
        this.ssrc = ssrc;
        this.policy = policy;
        int encKeyLength = policy.getEncKeyLength();
        this.masterKey = new byte[encKeyLength];
        System.arraycopy(masterK, 0, this.masterKey, 0, encKeyLength);
        int saltKeyLength = policy.getSaltKeyLength();
        this.masterSalt = new byte[saltKeyLength];
        System.arraycopy(masterS, 0, this.masterSalt, 0, saltKeyLength);
        BlockCipher cipher = null;
        BlockCipher cipherF8 = null;
        byte[] encKey = null;
        byte[] saltKey = null;
        switch (policy.getEncType()) {
            case 0: {
                break;
            }
            case 2: {
                cipherF8 = AES.createBlockCipher();
            }
            case 1: {
                cipher = AES.createBlockCipher();
                encKey = new byte[encKeyLength];
                saltKey = new byte[saltKeyLength];
                break;
            }
            case 4: {
                cipherF8 = new TwofishEngine();
            }
            case 3: {
                cipher = new TwofishEngine();
                encKey = new byte[encKeyLength];
                saltKey = new byte[saltKeyLength];
            }
        }
        this.cipher = cipher;
        this.cipherF8 = cipherF8;
        this.encKey = encKey;
        this.saltKey = saltKey;
        switch (policy.getAuthType()) {
            case 1: {
                authKey = new byte[policy.getAuthKeyLength()];
                mac = HMACSHA1.createMac();
                tagStore = new byte[mac.getMacSize()];
                break;
            }
            case 2: {
                authKey = new byte[policy.getAuthKeyLength()];
                mac = new SkeinMac();
                tagStore = new byte[policy.getAuthTagLength()];
                break;
            }
            default: {
                authKey = null;
                mac = null;
                tagStore = null;
            }
        }
        this.authKey = authKey;
        this.mac = mac;
        this.tagStore = tagStore;
    }

    protected synchronized void authenticatePacketHMAC(RawPacket pkt, int rocIn) {
        this.mac.update(pkt.getBuffer(), pkt.getOffset(), pkt.getLength());
        this.rbStore[0] = (byte)(rocIn >> 24);
        this.rbStore[1] = (byte)(rocIn >> 16);
        this.rbStore[2] = (byte)(rocIn >> 8);
        this.rbStore[3] = (byte)rocIn;
        this.mac.update(this.rbStore, 0, this.rbStore.length);
        this.mac.doFinal(this.tagStore, 0);
    }

    public synchronized void close() {
        Arrays.fill(this.masterKey, (byte)0);
        Arrays.fill(this.masterSalt, (byte)0);
    }

    public int getAuthTagLength() {
        return this.policy.getAuthTagLength();
    }

    public int getMKILength() {
        return this.mki == null ? 0 : this.mki.length;
    }

    public int getSSRC() {
        return this.ssrc;
    }
}

