/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.renderer;

import javax.media.Format;
import javax.media.Renderer;
import org.jitsi.impl.neomedia.control.ControlsAdapter;
import org.jitsi.util.Logger;

public abstract class AbstractRenderer<T extends Format>
extends ControlsAdapter
implements Renderer {
    private static final Logger logger = Logger.getLogger(AbstractRenderer.class);
    protected T inputFormat;

    @Override
    public void reset() {
    }

    @Override
    public Format setInputFormat(Format format) {
        Format matchingFormat = null;
        for (Format supportedInputFormat : this.getSupportedInputFormats()) {
            if (!supportedInputFormat.matches(format)) continue;
            matchingFormat = supportedInputFormat.intersects(format);
            break;
        }
        if (matchingFormat == null) {
            return null;
        }
        Format t = matchingFormat;
        this.inputFormat = t;
        return this.inputFormat;
    }

    public static void useThreadPriority(int threadPriority) {
        RuntimeException throwable = null;
        try {
            Thread.currentThread().setPriority(threadPriority);
        }
        catch (IllegalArgumentException iae) {
            throwable = iae;
        }
        catch (SecurityException se) {
            throwable = se;
        }
        if (throwable != null) {
            logger.warn("Failed to use thread priority: " + threadPriority, throwable);
        }
    }
}

