/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.conference;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.LinkedList;
import javax.media.CaptureDeviceInfo;
import javax.media.Time;
import javax.media.control.BufferControl;
import javax.media.control.FormatControl;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.conference.AudioMixer;
import org.jitsi.impl.neomedia.conference.AudioMixerPushBufferStream;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferStream;
import org.jitsi.impl.neomedia.control.AbstractControls;
import org.jitsi.impl.neomedia.protocol.InbandDTMFDataSource;
import org.jitsi.impl.neomedia.protocol.MuteDataSource;
import org.jitsi.service.neomedia.DTMFInbandTone;
import org.jitsi.util.Logger;

public class AudioMixingPushBufferDataSource
extends PushBufferDataSource
implements CaptureDevice,
MuteDataSource,
InbandDTMFDataSource {
    private static final Logger logger = Logger.getLogger(AudioMixingPushBufferDataSource.class);
    final AudioMixer audioMixer;
    private boolean connected;
    private boolean mute = false;
    private AudioMixingPushBufferStream outStream;
    private boolean started;
    private final LinkedList<DTMFInbandTone> tones = new LinkedList();

    public AudioMixingPushBufferDataSource(AudioMixer audioMixer) {
        this.audioMixer = audioMixer;
    }

    @Override
    public void addDTMF(DTMFInbandTone tone) {
        this.tones.add(tone);
    }

    public void addInDataSource(DataSource inDataSource) {
        this.audioMixer.addInDataSource(inDataSource, this);
    }

    @Override
    public synchronized void connect() throws IOException {
        if (!this.connected) {
            this.audioMixer.connect();
            this.connected = true;
        }
    }

    @Override
    public synchronized void disconnect() {
        try {
            this.stop();
        }
        catch (IOException ioex) {
            throw new UndeclaredThrowableException(ioex);
        }
        if (this.connected) {
            this.outStream = null;
            this.connected = false;
            this.audioMixer.disconnect();
        }
    }

    private BufferControl getBufferControl() {
        return this.audioMixer.getBufferControl();
    }

    @Override
    public CaptureDeviceInfo getCaptureDeviceInfo() {
        return this.audioMixer.getCaptureDeviceInfo();
    }

    @Override
    public String getContentType() {
        return this.audioMixer.getContentType();
    }

    @Override
    public Object getControl(String controlType) {
        return AbstractControls.getControl(this, controlType);
    }

    @Override
    public Object[] getControls() {
        BufferControl bufferControl = this.getBufferControl();
        Object[] formatControls = this.getFormatControls();
        if (bufferControl == null) {
            return formatControls;
        }
        if (formatControls == null || formatControls.length < 1) {
            return new Object[]{bufferControl};
        }
        Object[] controls = new Object[1 + formatControls.length];
        controls[0] = bufferControl;
        System.arraycopy(formatControls, 0, controls, 1, formatControls.length);
        return controls;
    }

    @Override
    public Time getDuration() {
        return this.audioMixer.getDuration();
    }

    @Override
    public FormatControl[] getFormatControls() {
        return this.audioMixer.getFormatControls();
    }

    public short[] getNextToneSignal(double sampleRate, int sampleSizeInBits) {
        return this.tones.poll().getAudioSamples(sampleRate, sampleSizeInBits);
    }

    @Override
    public synchronized PushBufferStream[] getStreams() {
        PushBufferStream[] pushBufferStreamArray;
        AudioMixerPushBufferStream audioMixerOutStream;
        if (this.connected && this.outStream == null && (audioMixerOutStream = this.audioMixer.getOutStream()) != null) {
            this.outStream = new AudioMixingPushBufferStream(audioMixerOutStream, this);
            if (this.started) {
                try {
                    this.outStream.start();
                }
                catch (IOException ioex) {
                    logger.error("Failed to start " + this.outStream.getClass().getSimpleName() + " with hashCode " + this.outStream.hashCode(), ioex);
                }
            }
        }
        if (this.outStream == null) {
            pushBufferStreamArray = new PushBufferStream[]{};
        } else {
            PushBufferStream[] pushBufferStreamArray2 = new PushBufferStream[1];
            pushBufferStreamArray = pushBufferStreamArray2;
            pushBufferStreamArray2[0] = this.outStream;
        }
        return pushBufferStreamArray;
    }

    @Override
    public boolean isMute() {
        return this.mute;
    }

    public boolean isSendingDTMF() {
        return !this.tones.isEmpty();
    }

    @Override
    public void setMute(boolean mute) {
        this.mute = mute;
    }

    @Override
    public synchronized void start() throws IOException {
        if (!this.started) {
            this.started = true;
            if (this.outStream != null) {
                this.outStream.start();
            }
        }
    }

    @Override
    public synchronized void stop() throws IOException {
        if (this.started) {
            this.started = false;
            if (this.outStream != null) {
                this.outStream.stop();
            }
        }
    }

    public void updateInDataSource(DataSource inDataSource) {
        this.audioMixer.getOutStream();
    }
}

