/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.inifile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.antcontrib.inifile.IniProperty;
import net.sf.antcontrib.inifile.IniSection;

public class IniFile {
    private List sections = new ArrayList();
    private Map sectionMap = new HashMap();

    public List getSections() {
        return this.sections;
    }

    public IniSection getSection(String string) {
        return (IniSection)this.sectionMap.get(string);
    }

    public void setSection(IniSection iniSection) {
        IniSection iniSection2 = (IniSection)this.sectionMap.get(iniSection.getName());
        if (iniSection2 != null) {
            int n = this.sections.indexOf(iniSection2);
            this.sections.set(n, iniSection);
        } else {
            this.sections.add(iniSection);
        }
        this.sectionMap.put(iniSection.getName(), iniSection);
    }

    public void removeSection(String string) {
        IniSection iniSection = (IniSection)this.sectionMap.get(string);
        if (iniSection != null) {
            int n = this.sections.indexOf(iniSection);
            this.sections.remove(n);
            this.sectionMap.remove(string);
        }
    }

    public void write(Writer writer) throws IOException {
        Iterator iterator = this.sections.iterator();
        IniSection iniSection = null;
        while (iterator.hasNext()) {
            iniSection = (IniSection)iterator.next();
            iniSection.write(writer);
            writer.write(System.getProperty("line.separator"));
        }
    }

    public void read(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = null;
        IniSection iniSection = new IniSection("NONE");
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            int n = string.indexOf(35);
            if (n != -1) {
                string = string.substring(0, n);
            }
            if ((string = string.trim()).length() <= 0) continue;
            if (string.startsWith("[") && string.endsWith("]")) {
                string2 = string.substring(1, string.length() - 1);
                iniSection = new IniSection(string2);
                this.setSection(iniSection);
                continue;
            }
            string2 = string;
            String string3 = "";
            n = string.indexOf("=");
            if (n != -1) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            iniSection.setProperty(new IniProperty(string2, string3));
        }
    }
}

