/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.LexerCore;
import gov.nist.core.ParserCore;
import java.text.ParseException;

public class HostNameParser
extends ParserCore {
    public HostNameParser(String string) {
        this.lexer = new LexerCore("charLexer", string);
    }

    public HostNameParser(LexerCore lexerCore) {
        this.lexer = lexerCore;
        lexerCore.selectLexer("charLexer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String domainLabel() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.lexer.hasMoreChars()) {
            char c = this.lexer.lookAhead(0);
            if (LexerCore.isAlpha(c)) {
                this.lexer.consume(1);
                stringBuffer.append(c);
                continue;
            }
            if (LexerCore.isDigit(c)) {
                this.lexer.consume(1);
                stringBuffer.append(c);
                continue;
            }
            if (c != '-') break;
            this.lexer.consume(1);
            stringBuffer.append(c);
        }
        String string = stringBuffer.toString();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String ipv6Reference() throws ParseException {
        char c;
        StringBuffer stringBuffer;
        block5: {
            stringBuffer = new StringBuffer();
            while (this.lexer.hasMoreChars()) {
                c = this.lexer.lookAhead(0);
                if (LexerCore.isHexDigit(c)) {
                    this.lexer.consume(1);
                    stringBuffer.append(c);
                    continue;
                }
                if (c == '.' || c == ':' || c == '[') {
                    this.lexer.consume(1);
                    stringBuffer.append(c);
                    continue;
                }
                break block5;
            }
            throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
        }
        if (c != ']') throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
        this.lexer.consume(1);
        stringBuffer.append(c);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host host() throws ParseException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lexer.lookAhead(0) == '[') {
            stringBuffer.append(this.ipv6Reference());
        } else {
            string = this.domainLabel();
            stringBuffer.append(string);
            while (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) == '.') {
                this.lexer.consume(1);
                string = this.domainLabel();
                stringBuffer.append(".");
                stringBuffer.append(string);
            }
        }
        string = stringBuffer.toString();
        if (string.equals("")) {
            throw new ParseException(this.lexer.getBuffer() + ": Missing host name", this.lexer.getPtr());
        }
        Host host = new Host(string);
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostPort hostPort(boolean bl) throws ParseException {
        Object object;
        Host host = this.host();
        HostPort hostPort = new HostPort();
        hostPort.setHost(host);
        if (bl) {
            this.lexer.SPorHT();
        }
        if (this.lexer.hasMoreChars()) {
            switch (this.lexer.lookAhead(0)) {
                case ':': {
                    this.lexer.consume(1);
                    if (bl) {
                        this.lexer.SPorHT();
                    }
                    try {
                        object = this.lexer.number();
                        hostPort.setPort(Integer.parseInt((String)object));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException(this.lexer.getBuffer() + " :Error parsing port ", this.lexer.getPtr());
                    }
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ';': 
                case '>': 
                case '?': {
                    break;
                }
                default: {
                    if (bl) break;
                    throw new ParseException(this.lexer.getBuffer() + " Illegal character in hostname:" + this.lexer.lookAhead(0), this.lexer.getPtr());
                }
            }
        }
        object = hostPort;
        return object;
    }

    public static void main(String[] stringArray) throws ParseException {
        String[] stringArray2 = new String[]{"foo.bar.com:1234", "proxima.chaplin.bt.co.uk", "129.6.55.181:2345", ":1234", "foo.bar.com:         1234", "foo.bar.com     :      1234   ", "MIK_S:1234"};
        for (int i = 0; i < stringArray2.length; ++i) {
            try {
                HostNameParser hostNameParser = new HostNameParser(stringArray2[i]);
                HostPort hostPort = hostNameParser.hostPort(true);
                System.out.println("[" + hostPort.encode() + "]");
                continue;
            }
            catch (ParseException parseException) {
                System.out.println("exception text = " + parseException.getMessage());
            }
        }
    }
}

