/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import gov.nist.core.GenericObject;
import gov.nist.core.NameValue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NameValueList {
    private Map hmap;
    private String separator = ";";

    public NameValueList() {
        this.hmap = new HashMap();
    }

    public NameValueList(boolean bl) {
        this.hmap = bl ? new ConcurrentHashMap() : new HashMap();
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public String encode() {
        if (this.hmap.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.hmap.values().iterator();
        if (iterator.hasNext()) {
            while (true) {
                Object v;
                if ((v = iterator.next()) instanceof GenericObject) {
                    GenericObject genericObject = (GenericObject)v;
                    stringBuffer.append(genericObject.encode());
                } else {
                    stringBuffer.append(v.toString());
                }
                if (!iterator.hasNext()) break;
                stringBuffer.append(this.separator);
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.encode();
    }

    public void set(NameValue nameValue) {
        this.hmap.put(nameValue.name.toLowerCase(), nameValue);
    }

    public void set(String string, Object object) {
        NameValue nameValue = new NameValue(string, object);
        this.hmap.put(string.toLowerCase(), nameValue);
    }

    public boolean equals(Object object) {
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        NameValueList nameValueList = (NameValueList)object;
        if (this.hmap.size() != nameValueList.hmap.size()) {
            return false;
        }
        Iterator iterator = this.hmap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            NameValue nameValue = this.getNameValue(string);
            NameValue nameValue2 = (NameValue)nameValueList.hmap.get(string);
            if (nameValue2 == null) {
                return false;
            }
            if (nameValue2.equals(nameValue)) continue;
            return false;
        }
        return true;
    }

    public Object getValue(String string) {
        NameValue nameValue = this.getNameValue(string.toLowerCase());
        if (nameValue != null) {
            return nameValue.value;
        }
        return null;
    }

    public NameValue getNameValue(String string) {
        return (NameValue)this.hmap.get(string.toLowerCase());
    }

    public boolean hasNameValue(String string) {
        return this.hmap.containsKey(string.toLowerCase());
    }

    public boolean delete(String string) {
        String string2 = string.toLowerCase();
        if (this.hmap.containsKey(string2)) {
            this.hmap.remove(string2);
            return true;
        }
        return false;
    }

    public Object clone() {
        NameValueList nameValueList = new NameValueList();
        Iterator iterator = this.hmap.values().iterator();
        while (iterator.hasNext()) {
            nameValueList.set((NameValue)((NameValue)iterator.next()).clone());
        }
        return nameValueList;
    }

    public int size() {
        return this.hmap.size();
    }

    public boolean isEmpty() {
        return this.hmap.isEmpty();
    }

    public Iterator iterator() {
        return this.hmap.values().iterator();
    }

    public Iterator getNames() {
        return this.hmap.keySet().iterator();
    }

    public String getParameter(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            return null;
        }
        if (object instanceof GenericObject) {
            return ((GenericObject)object).encode();
        }
        return object.toString();
    }
}

