/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERApplicationSpecific
extends DERObject {
    private int tag;
    private byte[] octets;

    public DERApplicationSpecific(int n, byte[] byArray) {
        this.tag = n;
        this.octets = byArray;
    }

    public DERApplicationSpecific(int n, DEREncodable dEREncodable) throws IOException {
        this.tag = n | 0x20;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(dEREncodable);
        this.octets = byteArrayOutputStream.toByteArray();
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) != 0;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public int getApplicationTag() {
        return this.tag & 0x1F;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(this.getContents()).readObject();
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(0x40 | this.tag, this.octets);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)object;
        if (this.tag != dERApplicationSpecific.tag) {
            return false;
        }
        if (this.octets.length != dERApplicationSpecific.octets.length) {
            return false;
        }
        for (int i = 0; i < this.octets.length; ++i) {
            if (this.octets[i] == dERApplicationSpecific.octets[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        byte[] byArray = this.getContents();
        int n = 0;
        for (int i = 0; i != byArray.length; ++i) {
            n ^= (byArray[i] & 0xFF) << i % 4;
        }
        return n ^ this.getApplicationTag();
    }
}

