/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import net.kano.joscar.DefensiveTools;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.ratelim.RateMonitor;
import net.kano.joscar.snaccmd.conn.RateClassInfo;

public class RateClassMonitor {
    private static final Logger logger = LoggingSystem.getLogger("net.kano.joscar.ratelim");
    private final RateMonitor rateMonitor;
    private RateClassInfo rateInfo;
    private long last = -1L;
    private long runningAvg;
    private boolean limited = false;
    private int errorMargin = -1;

    RateClassMonitor(RateMonitor rateMonitor, RateClassInfo rateInfo) {
        this.rateMonitor = rateMonitor;
        this.rateInfo = rateInfo;
        this.runningAvg = rateInfo.getMax();
    }

    synchronized void updateRateInfo(int changeCode, RateClassInfo rateInfo) {
        DefensiveTools.checkNull((Object)rateInfo, (String)"rateInfo");
        if (rateInfo.getRateClass() != this.rateInfo.getRateClass()) {
            throw new IllegalArgumentException("updated rate information is not the same class as the previous rate information for this rate class monitor");
        }
        if (logger.logFinerEnabled()) {
            logger.logFiner("Rate monitor for class " + rateInfo.getRateClass() + " thinks rate average is " + this.runningAvg + "ms; server " + "thinks it is " + rateInfo.getCurrentAvg() + "ms");
        }
        this.rateInfo = rateInfo;
        this.runningAvg = Math.min(rateInfo.getMax(), this.runningAvg);
        if (changeCode == 3) {
            if (logger.logWarningEnabled()) {
                logger.logWarning("Rate class " + this.rateInfo.getRateClass() + " is now rate-limited!");
            }
            this.setLimited(true);
        } else if (changeCode == 4) {
            if (logger.logWarningEnabled()) {
                logger.logWarning("Rate class " + this.rateInfo.getRateClass() + ") is no longer rate-limited, according to server");
            }
            this.setLimited(false);
        }
    }

    synchronized void updateRate(long sentTime) {
        if (this.last != -1L) {
            assert (sentTime >= this.last);
            this.runningAvg = this.computeCurrentAvg(sentTime);
        }
        this.last = sentTime;
    }

    public final synchronized RateClassInfo getRateInfo() {
        return this.rateInfo;
    }

    private synchronized void updateLimitedStatus() {
        long avg;
        if (this.limited && (avg = this.computeCurrentAvg()) > this.rateInfo.getClearAvg() + (long)this.getErrorMargin()) {
            if (logger.logFineEnabled()) {
                logger.logFine("We think that rate class " + this.rateInfo.getRateClass() + " is not limited " + "anymore (avg is " + avg + ")");
            }
            this.setLimited(false);
        }
    }

    public final synchronized int getErrorMargin() {
        if (this.errorMargin == -1) {
            return this.rateMonitor.getErrorMargin();
        }
        return this.errorMargin;
    }

    public final synchronized int getLocalErrorMargin() {
        return this.errorMargin;
    }

    public final synchronized void setErrorMargin(int errorMargin) {
        DefensiveTools.checkRange((int)errorMargin, (String)"errorMargin", (int)-1);
        this.errorMargin = errorMargin;
    }

    private synchronized long computeCurrentAvg(long sentTime) {
        long diff = sentTime - this.last;
        long winSize = this.rateInfo.getWindowSize();
        long max = this.rateInfo.getMax();
        return Math.min(max, (this.runningAvg * (winSize - 1L) + diff) / winSize);
    }

    private synchronized long computeCurrentAvg() {
        return this.computeCurrentAvg(System.currentTimeMillis());
    }

    private synchronized void setLimited(boolean limited) {
        if (limited != this.limited) {
            this.limited = limited;
            this.rateMonitor.fireLimitedEvent(this, this.limited);
        }
    }

    public final synchronized boolean isLimited() {
        this.updateLimitedStatus();
        return this.limited;
    }

    public final synchronized long getLastRateAvg() {
        return this.runningAvg;
    }

    public final long getPotentialAvg() {
        return this.getPotentialAvg(System.currentTimeMillis());
    }

    public final long getPotentialAvg(long time) {
        return this.computeCurrentAvg(time);
    }

    public final synchronized long getOptimalWaitTime() {
        return this.getTimeUntil(this.getMinSafeAvg() + (long)this.getErrorMargin());
    }

    private synchronized long getMinSafeAvg() {
        if (this.isLimited()) {
            return this.rateInfo.getClearAvg();
        }
        return this.rateInfo.getLimitedAvg();
    }

    public final synchronized long getTimeUntil(long minAvg) {
        if (this.last == -1L) {
            return 0L;
        }
        long winSize = this.rateInfo.getWindowSize();
        long sinceLast = System.currentTimeMillis() - this.last;
        long minLastDiff = winSize * minAvg - this.runningAvg * (winSize - 1L);
        long toWait = minLastDiff - sinceLast + 1L;
        if (logger.logFineEnabled()) {
            logger.logFine("Class " + this.rateInfo.getRateClass() + " should be waiting " + toWait + "ms (avg is " + this.computeCurrentAvg() + "ms)");
        }
        return Math.max(toWait, 0L);
    }

    public final synchronized int getPossibleCmdCount() {
        return this.getPossibleCmdCount(this.runningAvg);
    }

    public final synchronized int getMaxCmdCount() {
        return this.getPossibleCmdCount(this.rateInfo.getMax());
    }

    private synchronized int getPossibleCmdCount(long currentAvg) {
        long diff = System.currentTimeMillis() - this.last;
        long winSize = this.rateInfo.getWindowSize();
        long limited = this.getMinSafeAvg() + (long)this.getErrorMargin();
        long avg = currentAvg;
        int count = 0;
        while (avg > limited) {
            avg = (diff + avg * (winSize - 1L)) / winSize;
            diff = 0L;
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        return count - 1;
    }

    public String toString() {
        return "RateClassMonitor: rateInfo=" + this.rateInfo + ", last=" + this.last + ", runningAvg=" + this.runningAvg + ", limited=" + this.limited + ", errorMargin=" + this.errorMargin;
    }
}

