/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.sf.cindy.Session;
import net.sf.cindy.impl.Constants;
import net.sf.cindy.impl.SimpleEventGeneratorMBean;
import net.sf.cindy.spi.EventGeneratorSpi;
import net.sf.cindy.spi.SessionSpi;
import net.sf.cindy.util.ElapsedTime;
import net.sf.cindy.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleEventGenerator
implements EventGeneratorSpi,
SimpleEventGeneratorMBean {
    private static final Log log = LogFactory.getLog((Class)SimpleEventGenerator.class);
    private static int i = 0;
    private final int id = i++;
    private final Collection register = new LinkedList();
    private Thread thread = null;
    private Selector selector;
    private volatile boolean close = false;
    private ElapsedTime lastSelectTime;
    private int priority = 5;

    public int getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) throws IllegalArgumentException {
        if (n < 1 || n > 10) {
            throw new IllegalArgumentException();
        }
        if (this.thread != null) {
            this.thread.setPriority(n);
        }
        this.priority = n;
    }

    public boolean isStarted() {
        return this.thread != null;
    }

    public synchronized void start() {
        if (this.isStarted()) {
            this.close = false;
            return;
        }
        this.doStart();
    }

    protected void doStart() {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("start EventGenerator " + this.id));
            }
            this.lastSelectTime = null;
            this.register.clear();
            this.close = false;
            this.selector = Selector.open();
            this.thread = new Thread(){

                public void run() {
                    SimpleEventGenerator.this.run();
                }
            };
            this.thread.setName(Utils.getClassSimpleName(this.getClass()) + this.id);
            this.thread.setPriority(this.priority);
            this.thread.start();
        }
        catch (IOException iOException) {
            log.error((Object)iOException, (Throwable)iOException);
        }
    }

    public synchronized void close() {
        this.stop();
    }

    public synchronized void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.doStop();
    }

    protected void doStop() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("stop EventGenerator " + this.id));
        }
        this.close = true;
        this.selector.wakeup();
        if (!this.isEventGeneratorThread()) {
            while (this.thread.isAlive()) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean isEventGeneratorThread() {
        return Thread.currentThread() == this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(SessionSpi sessionSpi, Object object) {
        if (this.isEventGeneratorThread()) {
            sessionSpi.onEvent(object, this.selector);
        } else {
            Collection collection = this.register;
            synchronized (collection) {
                this.register.add(new Object[]{sessionSpi, object});
            }
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        try {
            while (!this.close) {
                this.beforeSelect(this.selector);
                if (this.close) {
                    break;
                }
                int n = 0;
                try {
                    n = this.selector.select(Constants.CHECK_SESSION_TIMEOUT_INTERVAL);
                }
                catch (ClosedSelectorException closedSelectorException) {
                    break;
                }
                catch (IOException iOException) {
                    log.error((Object)iOException, (Throwable)iOException);
                    break;
                }
                this.afterSelect(this.selector);
                if (n <= 0) continue;
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    try {
                        this.processKey(selectionKey);
                    }
                    catch (Exception exception) {
                        ((Session)selectionKey.attachment()).dispatchException(exception);
                    }
                }
            }
        }
        finally {
            this.finishedSelect(this.selector);
        }
    }

    protected void processKey(SelectionKey selectionKey) {
        SessionSpi sessionSpi = (SessionSpi)selectionKey.attachment();
        if (selectionKey.isAcceptable()) {
            sessionSpi.onEvent(Constants.EV_ACCEPTABLE, null);
        }
        if (selectionKey.isConnectable()) {
            sessionSpi.onEvent(Constants.EV_CONNECTABLE, null);
        }
        if (selectionKey.isValid() && selectionKey.isReadable()) {
            sessionSpi.onEvent(Constants.EV_READABLE, null);
        }
        if (selectionKey.isValid() && selectionKey.isWritable()) {
            sessionSpi.onEvent(Constants.EV_WRITABLE, null);
        }
    }

    protected void beforeSelect(Selector selector) {
        this.changeRegisterChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeRegisterChannel() {
        Object[] objectArray = null;
        Collection collection = this.register;
        synchronized (collection) {
            objectArray = new Object[this.register.size()];
            this.register.toArray(objectArray);
            this.register.clear();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = (Object[])objectArray[i];
            SessionSpi sessionSpi = (SessionSpi)objectArray2[0];
            sessionSpi.onEvent(objectArray2[1], this.selector);
        }
    }

    protected void afterSelect(Selector selector) {
        this.checkSessionTimeout();
    }

    private void checkSessionTimeout() {
        Object object;
        Object object2;
        if (this.lastSelectTime == null) {
            this.lastSelectTime = new ElapsedTime();
            return;
        }
        Set<SelectionKey> set = this.selector.selectedKeys();
        Object object3 = set.iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            object = (SessionSpi)((SelectionKey)object2).attachment();
            object.onEvent(Constants.EV_EVENT_HAPPEN, null);
        }
        if (this.lastSelectTime.getElapsedTime() >= (long)Constants.CHECK_SESSION_TIMEOUT_INTERVAL) {
            object3 = new Integer((int)this.lastSelectTime.reset());
            object2 = this.selector.keys().iterator();
            while (object2.hasNext()) {
                object = (SelectionKey)object2.next();
                if (set.contains(object)) continue;
                SessionSpi sessionSpi = (SessionSpi)((SelectionKey)object).attachment();
                sessionSpi.onEvent(Constants.EV_CHECK_TIMEOUT, object3);
            }
        }
    }

    protected void finishedSelect(Selector selector) {
        Iterator<SelectionKey> iterator = selector.keys().iterator();
        while (iterator.hasNext()) {
            SelectionKey selectionKey = iterator.next();
            Session session = (Session)selectionKey.attachment();
            session.close();
        }
        try {
            selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        selector = null;
        this.lastSelectTime = null;
        this.register.clear();
        this.close = false;
        this.thread = null;
    }
}

