/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.ssi.CreateItemsCmd;
import net.kano.joscar.snaccmd.ssi.DeleteItemsCmd;
import net.kano.joscar.snaccmd.ssi.ModifyItemsCmd;
import net.kano.joscar.snaccmd.ssi.PostModCmd;
import net.kano.joscar.snaccmd.ssi.PreModCmd;
import net.kano.joscar.snaccmd.ssi.SsiDataCmd;
import net.kano.joscar.snaccmd.ssi.SsiDataModResponse;
import net.kano.joscar.snaccmd.ssi.SsiRightsCmd;
import net.kano.joscar.snaccmd.ssi.SsiUnchangedCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSsiCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList(new CmdType(19, 3), new CmdType(19, 6), new CmdType(19, 15), new CmdType(19, 14), new CmdType(19, 17), new CmdType(19, 18), new CmdType(19, 8), new CmdType(19, 9), new CmdType(19, 10));

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket snacPacket) {
        if (snacPacket.getFamily() != 19) {
            return null;
        }
        int n = snacPacket.getCommand();
        if (n == 3) {
            return new SsiRightsCmd(snacPacket);
        }
        if (n == 6) {
            return new SsiDataCmd(snacPacket);
        }
        if (n == 15) {
            return new SsiUnchangedCmd(snacPacket);
        }
        if (n == 14) {
            return new SsiDataModResponse(snacPacket);
        }
        if (n == 17) {
            return new PreModCmd(snacPacket);
        }
        if (n == 18) {
            return new PostModCmd(snacPacket);
        }
        if (n == 8) {
            return new CreateItemsCmd(snacPacket);
        }
        if (n == 9) {
            return new ModifyItemsCmd(snacPacket);
        }
        if (n == 10) {
            return new DeleteItemsCmd(snacPacket);
        }
        return null;
    }
}

