/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.AbstractItemObj;
import net.kano.joscar.ssiitem.SsiItemObjectWithId;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public class IconItem
extends AbstractItemObj
implements SsiItemObjectWithId {
    public static final String NAME_DEFAULT = "1";
    public static final String ALIAS_DEFAULT = "";
    private static final int GROUPID_DEFAULT = 0;
    private static final int TYPE_ICON_HASH = 213;
    private static final int TYPE_ALIAS = 305;
    private final String name;
    private final int id;
    private ExtraInfoData iconInfo;
    private String alias;

    public IconItem(SsiItem ssiItem) {
        Writable writable;
        DefensiveTools.checkNull(ssiItem, "item");
        this.name = ssiItem.getName();
        this.id = ssiItem.getId();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(ssiItem.getData());
        Tlv tlv = immutableTlvChain.getLastTlv(213);
        if (tlv != null) {
            writable = tlv.getData();
            this.iconInfo = ExtraInfoData.readExtraInfoData((ByteBlock)writable);
        } else {
            this.iconInfo = null;
        }
        this.alias = immutableTlvChain.getString(305);
        writable = TlvTools.getMutableCopy(immutableTlvChain);
        writable.removeTlvs(213, 305);
        this.addExtraTlvs((TlvChain)writable);
    }

    public IconItem(IconItem iconItem) {
        this(iconItem.name, iconItem.id, iconItem.iconInfo, iconItem.alias, iconItem.copyExtraTlvs());
    }

    public IconItem(String string, int n, ExtraInfoData extraInfoData) {
        this(string, n, extraInfoData, ALIAS_DEFAULT, null);
    }

    public IconItem(String string, int n, ExtraInfoData extraInfoData, String string2, TlvChain tlvChain) {
        super(tlvChain);
        DefensiveTools.checkNull(string, "name");
        DefensiveTools.checkRange(n, "id", 0);
        this.name = string;
        this.id = n;
        this.iconInfo = extraInfoData;
        this.alias = string2;
    }

    public final String getName() {
        return this.name;
    }

    public final int getId() {
        return this.id;
    }

    public final synchronized ExtraInfoData getIconInfo() {
        return this.iconInfo;
    }

    public final synchronized String getAlias() {
        return this.alias;
    }

    public final synchronized void setIconInfo(ExtraInfoData extraInfoData) {
        this.iconInfo = extraInfoData;
    }

    public final synchronized void setAlias(String string) {
        this.alias = string;
    }

    public synchronized SsiItem toSsiItem() {
        MutableTlvChain mutableTlvChain = TlvTools.createMutableChain();
        if (this.iconInfo != null) {
            ByteBlock byteBlock = ByteBlock.createByteBlock(this.iconInfo);
            mutableTlvChain.addTlv(new Tlv(213, byteBlock));
        }
        if (this.alias != null) {
            mutableTlvChain.addTlv(Tlv.getStringInstance(305, this.alias));
        }
        return this.generateItem(this.name, 0, this.id, 20, mutableTlvChain);
    }

    public synchronized String toString() {
        return "IconItem: name=" + this.name + ", id=0x" + Integer.toHexString(this.id) + ", alias='" + this.alias + "', iconinfo=" + this.iconInfo;
    }
}

