/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jaxrs;

import com.owlike.genson.Context;
import com.owlike.genson.ThreadLocalHolder;
import com.owlike.genson.reflect.BeanProperty;
import com.owlike.genson.reflect.RuntimePropertyFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;

public class UrlQueryParamFilter
implements RuntimePropertyFilter,
ContainerRequestFilter {
    private String paramName = "filter";
    private boolean inclusionFilter = true;
    private String splitBy;

    @Override
    public boolean shouldInclude(BeanProperty property, Context ctx) {
        Set properties = ThreadLocalHolder.get("_jaxrs_params_to_filter", Set.class);
        if (this.inclusionFilter) {
            return properties.contains(property.getName());
        }
        return !properties.contains(property.getName());
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        List properties = (List)containerRequestContext.getUriInfo().getQueryParameters().get((Object)this.paramName);
        HashSet<String> propertiesToFilter = new HashSet<String>();
        if (properties != null) {
            for (String v : properties) {
                if (this.splitBy != null) {
                    Collections.addAll(propertiesToFilter, v.split(this.splitBy));
                    continue;
                }
                propertiesToFilter.add(v);
            }
        }
        ThreadLocalHolder.store("_jaxrs_params_to_filter", propertiesToFilter);
    }

    public UrlQueryParamFilter inclusionFilter(boolean yes) {
        this.inclusionFilter = yes;
        return this;
    }

    public UrlQueryParamFilter paramName(String queryParamName) {
        this.paramName = queryParamName;
        return this;
    }

    public UrlQueryParamFilter splitBy(String pattern) {
        this.splitBy = pattern;
        return this;
    }
}

