/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.multipart;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpConstants;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.multipart.Attribute;
import org.jboss.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import org.jboss.netty.handler.codec.http.multipart.FileUpload;
import org.jboss.netty.handler.codec.http.multipart.HttpDataFactory;
import org.jboss.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import org.jboss.netty.handler.codec.http.multipart.InterfaceHttpData;
import org.jboss.netty.handler.codec.http.multipart.InternalAttribute;
import org.jboss.netty.handler.stream.ChunkedInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPostRequestEncoder
implements ChunkedInput {
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private final Charset charset;
    private boolean isChunked;
    private final List<InterfaceHttpData> bodyListDatas;
    private final List<InterfaceHttpData> multipartHttpDatas;
    private final boolean isMultipart;
    private String multipartDataBoundary;
    private String multipartMixedBoundary;
    private boolean headerFinalized;
    private boolean isLastChunk;
    private boolean isLastChunkSent;
    private FileUpload currentFileUpload;
    private boolean duringMixedMode;
    private long globalBodySize;
    private ListIterator<InterfaceHttpData> iterator;
    private ChannelBuffer currentBuffer;
    private InterfaceHttpData currentData;
    private boolean isKey = true;

    public HttpPostRequestEncoder(HttpRequest request, boolean multipart) throws ErrorDataEncoderException {
        this(new DefaultHttpDataFactory(DefaultHttpDataFactory.MINSIZE), request, multipart, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostRequestEncoder(HttpDataFactory factory, HttpRequest request, boolean multipart) throws ErrorDataEncoderException {
        this(factory, request, multipart, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostRequestEncoder(HttpDataFactory factory, HttpRequest request, boolean multipart, Charset charset) throws ErrorDataEncoderException {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (request.getMethod() != HttpMethod.POST) {
            throw new ErrorDataEncoderException("Cannot create a Encoder if not a POST");
        }
        this.request = request;
        this.charset = charset;
        this.factory = factory;
        this.bodyListDatas = new ArrayList<InterfaceHttpData>();
        this.isLastChunk = false;
        this.isLastChunkSent = false;
        this.isMultipart = multipart;
        this.multipartHttpDatas = new ArrayList<InterfaceHttpData>();
        if (this.isMultipart) {
            this.initDataMultipart();
        }
    }

    public void cleanFiles() {
        this.factory.cleanRequestHttpDatas(this.request);
    }

    public boolean isMultipart() {
        return this.isMultipart;
    }

    private void initDataMultipart() {
        this.multipartDataBoundary = HttpPostRequestEncoder.getNewMultipartDelimiter();
    }

    private void initMixedMultipart() {
        this.multipartMixedBoundary = HttpPostRequestEncoder.getNewMultipartDelimiter();
    }

    private static String getNewMultipartDelimiter() {
        Random random = new Random();
        return Long.toHexString(random.nextLong()).toLowerCase();
    }

    public List<InterfaceHttpData> getBodyListAttributes() {
        return this.bodyListDatas;
    }

    public void setBodyHttpDatas(List<InterfaceHttpData> datas) throws ErrorDataEncoderException {
        if (datas == null) {
            throw new NullPointerException("datas");
        }
        this.globalBodySize = 0L;
        this.bodyListDatas.clear();
        this.currentFileUpload = null;
        this.duringMixedMode = false;
        this.multipartHttpDatas.clear();
        for (InterfaceHttpData data : datas) {
            this.addBodyHttpData(data);
        }
    }

    public void addBodyAttribute(String name, String value) throws ErrorDataEncoderException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String svalue = value;
        if (value == null) {
            svalue = "";
        }
        Attribute data = this.factory.createAttribute(this.request, name, svalue);
        this.addBodyHttpData(data);
    }

    public void addBodyFileUpload(String name, File file, String contentType, boolean isText) throws ErrorDataEncoderException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        String scontentType = contentType;
        String contentTransferEncoding = null;
        if (contentType == null) {
            scontentType = isText ? "text/plain" : "application/octet-stream";
        }
        if (!isText) {
            contentTransferEncoding = HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value;
        }
        FileUpload fileUpload = this.factory.createFileUpload(this.request, name, file.getName(), scontentType, contentTransferEncoding, null, file.length());
        try {
            fileUpload.setContent(file);
        }
        catch (IOException e) {
            throw new ErrorDataEncoderException(e);
        }
        this.addBodyHttpData(fileUpload);
    }

    public void addBodyFileUploads(String name, File[] file, String[] contentType, boolean[] isText) throws ErrorDataEncoderException {
        if (file.length != contentType.length && file.length != isText.length) {
            throw new NullPointerException("Different array length");
        }
        for (int i = 0; i < file.length; ++i) {
            this.addBodyFileUpload(name, file[i], contentType[i], isText[i]);
        }
    }

    public void addBodyHttpData(InterfaceHttpData data) throws ErrorDataEncoderException {
        if (this.headerFinalized) {
            throw new ErrorDataEncoderException("Cannot add value once finalized");
        }
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.bodyListDatas.add(data);
        if (!this.isMultipart) {
            if (data instanceof Attribute) {
                Attribute attribute = (Attribute)data;
                try {
                    String key = HttpPostRequestEncoder.encodeAttribute(attribute.getName(), this.charset);
                    String value = HttpPostRequestEncoder.encodeAttribute(attribute.getValue(), this.charset);
                    Attribute newattribute = this.factory.createAttribute(this.request, key, value);
                    this.multipartHttpDatas.add(newattribute);
                    this.globalBodySize += (long)(newattribute.getName().length() + 1) + newattribute.length() + 1L;
                }
                catch (IOException e) {
                    throw new ErrorDataEncoderException(e);
                }
            } else if (data instanceof FileUpload) {
                FileUpload fileUpload = (FileUpload)data;
                String key = HttpPostRequestEncoder.encodeAttribute(fileUpload.getName(), this.charset);
                String value = HttpPostRequestEncoder.encodeAttribute(fileUpload.getFilename(), this.charset);
                Attribute newattribute = this.factory.createAttribute(this.request, key, value);
                this.multipartHttpDatas.add(newattribute);
                this.globalBodySize += (long)(newattribute.getName().length() + 1) + newattribute.length() + 1L;
            }
            return;
        }
        if (data instanceof Attribute) {
            InternalAttribute internal;
            if (this.duringMixedMode) {
                internal = new InternalAttribute();
                internal.addValue("\r\n--" + this.multipartMixedBoundary + "--");
                this.multipartHttpDatas.add(internal);
                this.multipartMixedBoundary = null;
                this.currentFileUpload = null;
                this.duringMixedMode = false;
            }
            internal = new InternalAttribute();
            if (this.multipartHttpDatas.size() > 0) {
                internal.addValue("\r\n");
            }
            internal.addValue("--" + this.multipartDataBoundary + "\r\n");
            Attribute attribute = (Attribute)data;
            internal.addValue("Content-Disposition: form-data; name=\"" + HttpPostRequestEncoder.encodeAttribute(attribute.getName(), this.charset) + "\"\r\n");
            Charset localcharset = attribute.getCharset();
            if (localcharset != null) {
                internal.addValue("Content-Type: charset=" + localcharset + "\r\n");
            }
            internal.addValue("\r\n");
            this.multipartHttpDatas.add(internal);
            this.multipartHttpDatas.add(data);
            this.globalBodySize += attribute.length() + (long)internal.size();
        } else if (data instanceof FileUpload) {
            FileUpload fileUpload = (FileUpload)data;
            InternalAttribute internal = new InternalAttribute();
            if (this.multipartHttpDatas.size() > 0) {
                internal.addValue("\r\n");
            }
            boolean localMixed = false;
            if (this.duringMixedMode) {
                if (this.currentFileUpload != null && this.currentFileUpload.getName().equals(fileUpload.getName())) {
                    localMixed = true;
                } else {
                    internal.addValue("--" + this.multipartMixedBoundary + "--");
                    this.multipartHttpDatas.add(internal);
                    this.multipartMixedBoundary = null;
                    internal = new InternalAttribute();
                    internal.addValue("\r\n");
                    localMixed = false;
                    this.currentFileUpload = fileUpload;
                    this.duringMixedMode = false;
                }
            } else if (this.currentFileUpload != null && this.currentFileUpload.getName().equals(fileUpload.getName())) {
                this.initMixedMultipart();
                InternalAttribute pastAttribute = (InternalAttribute)this.multipartHttpDatas.get(this.multipartHttpDatas.size() - 2);
                this.globalBodySize -= (long)pastAttribute.size();
                String replacement = "Content-Disposition: form-data; name=\"" + HttpPostRequestEncoder.encodeAttribute(fileUpload.getName(), this.charset) + "\"\r\n";
                replacement = replacement + "Content-Type: multipart/mixed; boundary=" + this.multipartMixedBoundary + "\r\n\r\n";
                replacement = replacement + "--" + this.multipartMixedBoundary + "\r\n";
                replacement = replacement + "Content-Disposition: file; filename=\"" + HttpPostRequestEncoder.encodeAttribute(fileUpload.getFilename(), this.charset) + "\"\r\n";
                pastAttribute.setValue(replacement, 1);
                this.globalBodySize += (long)pastAttribute.size();
                localMixed = true;
                this.duringMixedMode = true;
            } else {
                localMixed = false;
                this.currentFileUpload = fileUpload;
                this.duringMixedMode = false;
            }
            if (localMixed) {
                internal.addValue("--" + this.multipartMixedBoundary + "\r\n");
                internal.addValue("Content-Disposition: file; filename=\"" + HttpPostRequestEncoder.encodeAttribute(fileUpload.getFilename(), this.charset) + "\"\r\n");
            } else {
                internal.addValue("--" + this.multipartDataBoundary + "\r\n");
                internal.addValue("Content-Disposition: form-data; name=\"" + HttpPostRequestEncoder.encodeAttribute(fileUpload.getName(), this.charset) + "\"; " + "filename" + "=\"" + HttpPostRequestEncoder.encodeAttribute(fileUpload.getFilename(), this.charset) + "\"\r\n");
            }
            internal.addValue("Content-Type: " + fileUpload.getContentType());
            String contentTransferEncoding = fileUpload.getContentTransferEncoding();
            if (contentTransferEncoding != null && contentTransferEncoding.equals(HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value)) {
                internal.addValue("\r\nContent-Transfer-Encoding: " + HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value + "\r\n\r\n");
            } else if (fileUpload.getCharset() != null) {
                internal.addValue("; charset=" + fileUpload.getCharset() + "\r\n\r\n");
            } else {
                internal.addValue("\r\n\r\n");
            }
            this.multipartHttpDatas.add(internal);
            this.multipartHttpDatas.add(data);
            this.globalBodySize += fileUpload.length() + (long)internal.size();
        }
    }

    public HttpRequest finalizeRequest() throws ErrorDataEncoderException {
        if (!this.headerFinalized) {
            if (this.isMultipart) {
                InternalAttribute internal = new InternalAttribute();
                if (this.duringMixedMode) {
                    internal.addValue("\r\n--" + this.multipartMixedBoundary + "--");
                }
                internal.addValue("\r\n--" + this.multipartDataBoundary + "--\r\n");
                this.multipartHttpDatas.add(internal);
                this.multipartMixedBoundary = null;
                this.currentFileUpload = null;
                this.duringMixedMode = false;
                this.globalBodySize += (long)internal.size();
            }
        } else {
            throw new ErrorDataEncoderException("Header already encoded");
        }
        this.headerFinalized = true;
        List<String> contentTypes = this.request.getHeaders("Content-Type");
        List<String> transferEncoding = this.request.getHeaders("Transfer-Encoding");
        if (contentTypes != null) {
            this.request.removeHeader("Content-Type");
            for (String contentType : contentTypes) {
                if (contentType.toLowerCase().startsWith("multipart/form-data") || contentType.toLowerCase().startsWith("application/x-www-form-urlencoded")) continue;
                this.request.addHeader("Content-Type", contentType);
            }
        }
        if (this.isMultipart) {
            String value = "multipart/form-data; boundary=" + this.multipartDataBoundary;
            this.request.addHeader("Content-Type", value);
        } else {
            this.request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        long realSize = this.globalBodySize;
        if (this.isMultipart) {
            this.iterator = this.multipartHttpDatas.listIterator();
        } else {
            --realSize;
            this.iterator = this.multipartHttpDatas.listIterator();
        }
        this.request.setHeader("Content-Length", String.valueOf(realSize));
        if (realSize > (long)HttpPostBodyUtil.chunkSize) {
            this.isChunked = true;
            if (transferEncoding != null) {
                this.request.removeHeader("Transfer-Encoding");
                for (String v : transferEncoding) {
                    if (v.equalsIgnoreCase("chunked")) continue;
                    this.request.addHeader("Transfer-Encoding", v);
                }
            }
            this.request.addHeader("Transfer-Encoding", "chunked");
            this.request.setContent(ChannelBuffers.EMPTY_BUFFER);
        } else {
            HttpChunk chunk = this.nextChunk();
            this.request.setContent(chunk.getContent());
        }
        return this.request;
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    private static String encodeAttribute(String s, Charset charset) throws ErrorDataEncoderException {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ErrorDataEncoderException(charset.name(), e);
        }
    }

    private ChannelBuffer fillChannelBuffer() {
        int length = this.currentBuffer.readableBytes();
        if (length > HttpPostBodyUtil.chunkSize) {
            ChannelBuffer slice = this.currentBuffer.slice(this.currentBuffer.readerIndex(), HttpPostBodyUtil.chunkSize);
            this.currentBuffer.skipBytes(HttpPostBodyUtil.chunkSize);
            return slice;
        }
        ChannelBuffer slice = this.currentBuffer;
        this.currentBuffer = null;
        return slice;
    }

    private HttpChunk encodeNextChunkMultipart(int sizeleft) throws ErrorDataEncoderException {
        ChannelBuffer buffer;
        if (this.currentData == null) {
            return null;
        }
        if (this.currentData instanceof InternalAttribute) {
            byte[] bytes;
            String internal = ((InternalAttribute)this.currentData).toString();
            try {
                bytes = internal.getBytes("ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new ErrorDataEncoderException(e);
            }
            buffer = ChannelBuffers.wrappedBuffer(bytes);
            this.currentData = null;
        } else {
            if (this.currentData instanceof Attribute) {
                try {
                    buffer = ((Attribute)this.currentData).getChunk(sizeleft);
                }
                catch (IOException e) {
                    throw new ErrorDataEncoderException(e);
                }
            }
            try {
                buffer = ((FileUpload)this.currentData).getChunk(sizeleft);
            }
            catch (IOException e) {
                throw new ErrorDataEncoderException(e);
            }
            if (buffer.capacity() == 0) {
                this.currentData = null;
                return null;
            }
        }
        this.currentBuffer = this.currentBuffer == null ? buffer : ChannelBuffers.wrappedBuffer(this.currentBuffer, buffer);
        if (this.currentBuffer.readableBytes() < HttpPostBodyUtil.chunkSize) {
            this.currentData = null;
            return null;
        }
        buffer = this.fillChannelBuffer();
        return new DefaultHttpChunk(buffer);
    }

    private HttpChunk encodeNextChunkUrlEncoded(int sizeleft) throws ErrorDataEncoderException {
        ChannelBuffer buffer;
        if (this.currentData == null) {
            return null;
        }
        int size = sizeleft;
        if (this.isKey) {
            String key = this.currentData.getName();
            buffer = ChannelBuffers.wrappedBuffer(key.getBytes());
            this.isKey = false;
            if (this.currentBuffer == null) {
                this.currentBuffer = ChannelBuffers.wrappedBuffer(buffer, ChannelBuffers.wrappedBuffer("=".getBytes()));
                size -= buffer.readableBytes() + 1;
            } else {
                this.currentBuffer = ChannelBuffers.wrappedBuffer(this.currentBuffer, buffer, ChannelBuffers.wrappedBuffer("=".getBytes()));
                size -= buffer.readableBytes() + 1;
            }
            if (this.currentBuffer.readableBytes() >= HttpPostBodyUtil.chunkSize) {
                buffer = this.fillChannelBuffer();
                return new DefaultHttpChunk(buffer);
            }
        }
        try {
            buffer = ((Attribute)this.currentData).getChunk(size);
        }
        catch (IOException e) {
            throw new ErrorDataEncoderException(e);
        }
        ChannelBuffer delimiter = null;
        if (buffer.readableBytes() < size) {
            this.isKey = true;
            ChannelBuffer channelBuffer = delimiter = this.iterator.hasNext() ? ChannelBuffers.wrappedBuffer("&".getBytes()) : null;
        }
        if (buffer.capacity() == 0) {
            this.currentData = null;
            if (this.currentBuffer == null) {
                this.currentBuffer = delimiter;
            } else if (delimiter != null) {
                this.currentBuffer = ChannelBuffers.wrappedBuffer(this.currentBuffer, delimiter);
            }
            if (this.currentBuffer.readableBytes() >= HttpPostBodyUtil.chunkSize) {
                buffer = this.fillChannelBuffer();
                return new DefaultHttpChunk(buffer);
            }
            return null;
        }
        this.currentBuffer = this.currentBuffer == null ? (delimiter != null ? ChannelBuffers.wrappedBuffer(buffer, delimiter) : buffer) : (delimiter != null ? ChannelBuffers.wrappedBuffer(this.currentBuffer, buffer, delimiter) : ChannelBuffers.wrappedBuffer(this.currentBuffer, buffer));
        if (this.currentBuffer.readableBytes() < HttpPostBodyUtil.chunkSize) {
            this.currentData = null;
            this.isKey = true;
            return null;
        }
        buffer = this.fillChannelBuffer();
        return new DefaultHttpChunk(buffer);
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public HttpChunk nextChunk() throws ErrorDataEncoderException {
        HttpChunk chunk;
        if (this.isLastChunk) {
            this.isLastChunkSent = true;
            return new DefaultHttpChunk(ChannelBuffers.EMPTY_BUFFER);
        }
        ChannelBuffer buffer = null;
        int size = HttpPostBodyUtil.chunkSize;
        if (this.currentBuffer != null) {
            size -= this.currentBuffer.readableBytes();
        }
        if (size <= 0) {
            buffer = this.fillChannelBuffer();
            return new DefaultHttpChunk(buffer);
        }
        if (this.currentData != null) {
            if (this.isMultipart ? (chunk = this.encodeNextChunkMultipart(size)) != null : (chunk = this.encodeNextChunkUrlEncoded(size)) != null) {
                return chunk;
            }
            size = HttpPostBodyUtil.chunkSize - this.currentBuffer.readableBytes();
        }
        if (!this.iterator.hasNext()) {
            this.isLastChunk = true;
            buffer = this.currentBuffer;
            this.currentBuffer = null;
            return new DefaultHttpChunk(buffer);
        }
        while (size > 0 && this.iterator.hasNext()) {
            this.currentData = this.iterator.next();
            chunk = this.isMultipart ? this.encodeNextChunkMultipart(size) : this.encodeNextChunkUrlEncoded(size);
            if (chunk == null) {
                size = HttpPostBodyUtil.chunkSize - this.currentBuffer.readableBytes();
                continue;
            }
            return chunk;
        }
        this.isLastChunk = true;
        if (this.currentBuffer == null) {
            this.isLastChunkSent = true;
            return new DefaultHttpChunk(ChannelBuffers.EMPTY_BUFFER);
        }
        buffer = this.currentBuffer;
        this.currentBuffer = null;
        return new DefaultHttpChunk(buffer);
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        return this.isLastChunkSent;
    }

    @Override
    public boolean hasNextChunk() throws Exception {
        return !this.isLastChunkSent;
    }

    public static class ErrorDataEncoderException
    extends Exception {
        private static final long serialVersionUID = 5020247425493164465L;

        public ErrorDataEncoderException() {
        }

        public ErrorDataEncoderException(String arg0) {
            super(arg0);
        }

        public ErrorDataEncoderException(Throwable arg0) {
            super(arg0);
        }

        public ErrorDataEncoderException(String arg0, Throwable arg1) {
            super(arg0, arg1);
        }
    }
}

