/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.servlet;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;

public class ServletUpgradeResponse
extends UpgradeResponse {
    private HttpServletResponse response;
    private boolean extensionsNegotiated = false;
    private boolean subprotocolNegotiated = false;

    public ServletUpgradeResponse(HttpServletResponse response) {
        this.response = response;
    }

    public int getStatusCode() {
        return this.response.getStatus();
    }

    public void setStatus(int status) {
        this.response.setStatus(status);
    }

    public String getStatusReason() {
        throw new UnsupportedOperationException("Server cannot get Status Reason Message");
    }

    public boolean isCommitted() {
        if (this.response != null) {
            return this.response.isCommitted();
        }
        return true;
    }

    public boolean isExtensionsNegotiated() {
        return this.extensionsNegotiated;
    }

    public boolean isSubprotocolNegotiated() {
        return this.subprotocolNegotiated;
    }

    public void sendError(int statusCode, String message) throws IOException {
        this.setSuccess(false);
        this.commitHeaders();
        this.response.sendError(statusCode, message);
        this.response = null;
    }

    public void sendForbidden(String message) throws IOException {
        this.setSuccess(false);
        this.commitHeaders();
        this.response.sendError(403, message);
        this.response = null;
    }

    public void setAcceptedSubProtocol(String protocol) {
        super.setAcceptedSubProtocol(protocol);
        this.subprotocolNegotiated = true;
    }

    public void setExtensions(List<ExtensionConfig> extensions) {
        super.setExtensions(extensions);
        this.extensionsNegotiated = true;
    }

    public void complete() {
        this.commitHeaders();
        this.response = null;
    }

    private void commitHeaders() {
        for (Map.Entry entry : this.getHeaders().entrySet()) {
            for (String value : (List)entry.getValue()) {
                this.response.addHeader((String)entry.getKey(), value);
            }
        }
    }
}

