/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.extensions.compress.CompressExtension;

public class DeflateFrameExtension
extends CompressExtension {
    @Override
    public String getName() {
        return "deflate-frame";
    }

    @Override
    int getRsvUseMode() {
        return 0;
    }

    @Override
    int getTailDropMode() {
        return 1;
    }

    public void incomingFrame(Frame frame) {
        if (OpCode.isControlFrame(frame.getOpCode()) || !frame.isRsv1() || !frame.hasPayload()) {
            this.nextIncomingFrame(frame);
            return;
        }
        ByteBuffer payload = frame.getPayload();
        int remaining = payload.remaining();
        byte[] input = new byte[remaining + TAIL_BYTES.length];
        payload.get(input, 0, remaining);
        System.arraycopy(TAIL_BYTES, 0, input, remaining, TAIL_BYTES.length);
        this.forwardIncoming(frame, this.decompress(input));
    }
}

