/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.NextScreenListener;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.util.FileResourceBundle;
import com.install4j.runtime.util.KeyboardUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProgramGroupSelector
extends JPanel {
    public static final String PROPERTY_GROUP = "group";
    private static final String BAD_CHARS = "/:*?\"<>|,";
    private String initialGroup;
    private boolean allUsers;
    private NextScreenListener nextScreenListener;
    private JTextField txtGroup;
    private JList lstGroups;
    private JScrollPane scpGroups;
    static /* synthetic */ Class class$java$awt$Window;

    public ProgramGroupSelector(String string, boolean bl, NextScreenListener nextScreenListener) {
        this.initialGroup = string;
        this.allUsers = bl;
        this.nextScreenListener = nextScreenListener;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    public void setEnabled(boolean bl) {
        this.txtGroup.setEnabled(bl);
        this.lstGroups.setEnabled(bl);
    }

    public String getSelectedProgramGroup() {
        String string = this.txtGroup.getText().trim();
        while (string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public boolean checkSelectedProgramGroup() {
        String string = this.getSelectedProgramGroup();
        Window window = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = ProgramGroupSelector.class$("java.awt.Window")) : class$java$awt$Window, this);
        FileResourceBundle fileResourceBundle = Messages.getMessages();
        if (string.length() == 0) {
            GUIHelper.showMessage(window, fileResourceBundle.getString("MustEnterGroupName"), 2);
            return false;
        }
        char[] cArray = BAD_CHARS.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (string.indexOf(cArray[i]) < 0) continue;
            GUIHelper.showMessage(window, MessageFormat.format(fileResourceBundle.getString("BadGroupName"), BAD_CHARS), 2);
            return false;
        }
        return true;
    }

    public void focusTextField() {
        this.txtGroup.requestFocus();
        this.txtGroup.setSelectionStart(0);
        this.txtGroup.setSelectionEnd(this.txtGroup.getDocument().getLength());
    }

    private void setupControls() {
        this.txtGroup = new JTextField(this.initialGroup);
        this.lstGroups = new JList();
        this.scpGroups = new JScrollPane(this.lstGroups);
        this.fillGroupList();
    }

    private void setupComponent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtGroup, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.scpGroups, gridBagConstraints);
    }

    private void setupEventHandlers() {
        this.lstGroups.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProgramGroupSelector.this.txtGroup.setText(ProgramGroupSelector.this.lstGroups.getSelectedValue().toString());
            }
        });
        KeyboardUtil.addAccelerator(0, this.txtGroup, this.txtGroup, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ProgramGroupSelector.this.nextScreenListener != null) {
                    ProgramGroupSelector.this.nextScreenListener.nextScreen();
                }
            }
        }, 10, 0);
    }

    private void fillGroupList() {
        File file = FolderInfo.getSpecialFolder(3, this.allUsers);
        File file2 = FolderInfo.getSpecialFolder(4, this.allUsers);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        try {
            file2 = file2.getCanonicalFile();
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file3 = fileArray[i];
                if (!file3.isDirectory() || (file3 = file3.getCanonicalFile()).equals(file2)) continue;
                defaultListModel.addElement(file3.getName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.lstGroups.setModel(defaultListModel);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

