/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.runtime.installer.platform.JVMLocator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UnixJVMLocator {
    private static final String[] UNIX_ROOT_LOCATIONS = new String[]{"/opt/i4j_jres", "usr/local/i4j_jres", "/usr/bin", "/usr", "/usr/java", "/usr/lib/java", "/usr/local", "/usr/lib"};
    private static final String[] UNIX_DIR_KEYWORDS = new String[]{"java", "jre", "jdk", "j2sdk", "j2re", "j2jre"};
    private static final String[] UNIX_JDK_FILES = new String[]{"bin/javac", "lib/tools.jar"};
    private static final String JAVA_EXECUTABLE = "bin/java";

    public static List getJVMLocations() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < UNIX_ROOT_LOCATIONS.length; ++i) {
            arrayList.addAll(UnixJVMLocator.searchRootLocation(UNIX_ROOT_LOCATIONS[i]));
        }
        return arrayList;
    }

    private static Collection searchRootLocation(String string) {
        ArrayList<JVMLocator.JVMLocation> arrayList = new ArrayList<JVMLocator.JVMLocation>();
        File[] fileArray = new File(string).listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (!file.isDirectory()) continue;
                for (int j = 0; j < UNIX_DIR_KEYWORDS.length; ++j) {
                    if (file.getName().indexOf(UNIX_DIR_KEYWORDS[j]) <= -1) continue;
                    try {
                        JVMLocator.JVMLocation jVMLocation = UnixJVMLocator.checkJVMLocation(file);
                        if (jVMLocation == null) continue;
                        arrayList.add(jVMLocation);
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        return arrayList;
    }

    private static JVMLocator.JVMLocation checkJVMLocation(File file) throws IOException {
        String string;
        File file2 = new File(file, JAVA_EXECUTABLE);
        if (file2.exists() && (string = UnixJVMLocator.getVersionOutput(file2)) != null && string.startsWith("java version \"") && string.endsWith("\"")) {
            JVMLocator.JVMLocation jVMLocation = new JVMLocator.JVMLocation();
            jVMLocation.setJavaHome(file);
            jVMLocation.setVersion(string.substring(14, string.length() - 1));
            jVMLocation.setJDK(UnixJVMLocator.isJDK(file));
            return jVMLocation;
        }
        return null;
    }

    private static boolean isJDK(File file) {
        for (int i = 0; i < UNIX_JDK_FILES.length; ++i) {
            if (new File(file, UNIX_JDK_FILES[i]).exists()) continue;
            return false;
        }
        return true;
    }

    private static String getVersionOutput(File file) throws IOException {
        String string = null;
        Process process = Runtime.getRuntime().exec(new String[]{file.getAbsolutePath(), "-version"});
        try {
            Thread.interrupted();
            TimeoutThread timeoutThread = new TimeoutThread(Thread.currentThread());
            timeoutThread.start();
            int n = process.waitFor();
            if (n == 0) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                string = bufferedReader.readLine();
                bufferedReader.close();
            }
            timeoutThread.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return string;
    }

    public static void main(String[] stringArray) {
        List list = UnixJVMLocator.getJVMLocations();
        for (int i = 0; i < list.size(); ++i) {
            JVMLocator.JVMLocation jVMLocation = (JVMLocator.JVMLocation)list.get(i);
            System.out.println(jVMLocation);
        }
    }

    private static class TimeoutThread
    extends Thread {
        private Thread watchedThread;

        public TimeoutThread(Thread thread) {
            super("timeout");
            this.setDaemon(true);
            this.watchedThread = thread;
        }

        public void run() {
            try {
                TimeoutThread.sleep(8000L);
                this.watchedThread.interrupt();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

