/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class Message
extends Packet {
    private Type type = Type.normal;
    private String subject = null;
    private String body = null;
    private String thread = null;

    public Message() {
    }

    public Message(String to) {
        if (to == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        this.setTo(to);
    }

    public Message(String to, Type type) {
        if (to == null || type == null) {
            throw new IllegalArgumentException("Parameters cannot be null.");
        }
        this.setTo(to);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null.");
        }
        this.type = type;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getThread() {
        return this.thread;
    }

    public void setThread(String thread) {
        this.thread = thread;
    }

    public String toXML() {
        XMPPError error;
        StringBuilder buf = new StringBuilder();
        buf.append("<message");
        if (this.getPacketID() != null) {
            buf.append(" id=\"").append(this.getPacketID()).append("\"");
        }
        if (this.getTo() != null) {
            buf.append(" to=\"").append(StringUtils.escapeForXML(this.getTo())).append("\"");
        }
        if (this.getFrom() != null) {
            buf.append(" from=\"").append(StringUtils.escapeForXML(this.getFrom())).append("\"");
        }
        if (this.type != Type.normal) {
            buf.append(" type=\"").append((Object)this.type).append("\"");
        }
        buf.append(">");
        if (this.subject != null) {
            buf.append("<subject>").append(StringUtils.escapeForXML(this.subject)).append("</subject>");
        }
        if (this.body != null) {
            buf.append("<body>").append(StringUtils.escapeForXML(this.body)).append("</body>");
        }
        if (this.thread != null) {
            buf.append("<thread>").append(this.thread).append("</thread>");
        }
        if (this.type == Type.error && (error = this.getError()) != null) {
            buf.append(error.toXML());
        }
        buf.append(this.getExtensionsXML());
        buf.append("</message>");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        normal,
        chat,
        groupchat,
        headline,
        error;


        public static Type fromString(String name) {
            try {
                return Type.valueOf(name);
            }
            catch (Exception e) {
                return normal;
            }
        }
    }
}

