/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl.xa;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.transaction.impl.xa.XAService;
import com.hazelcast.transaction.impl.xa.XATransactionHolder;
import com.hazelcast.transaction.impl.xa.XATransactionImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class XaReplicationOperation
extends AbstractOperation {
    List<XATransactionHolder> migrationData;

    public XaReplicationOperation() {
    }

    public XaReplicationOperation(List<XATransactionHolder> migrationData, int partitionId, int replicaIndex) {
        this.setPartitionId(partitionId);
        this.setReplicaIndex(replicaIndex);
        this.migrationData = migrationData;
    }

    @Override
    public void run() throws Exception {
        XAService xaService = (XAService)this.getService();
        NodeEngine nodeEngine = this.getNodeEngine();
        for (XATransactionHolder holder : this.migrationData) {
            XATransactionImpl xaTransaction = new XATransactionImpl(nodeEngine, holder.txLogs, holder.txnId, holder.xid, holder.ownerUuid, holder.timeoutMilis, holder.startTime);
            xaService.putTransaction(xaTransaction);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.migrationData.size());
        for (XATransactionHolder xaTransactionHolder : this.migrationData) {
            out.writeObject(xaTransactionHolder);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.migrationData = new ArrayList<XATransactionHolder>(size);
        for (int i = 0; i < size; ++i) {
            XATransactionHolder xaTransactionHolder = (XATransactionHolder)in.readObject();
            this.migrationData.add(xaTransactionHolder);
        }
    }
}

