/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.map.impl.MapEntrySimple;
import com.hazelcast.map.impl.MapEventPublisher;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.NearCacheProvider;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.operation.AbstractMapOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.impl.MutatingOperation;
import com.hazelcast.util.Clock;
import java.util.AbstractMap;
import java.util.Map;

abstract class AbstractMultipleEntryOperation
extends AbstractMapOperation
implements MutatingOperation {
    protected MapEntrySet responses;
    protected EntryProcessor entryProcessor;
    protected EntryBackupProcessor backupProcessor;
    protected transient RecordStore recordStore;

    protected AbstractMultipleEntryOperation() {
    }

    protected AbstractMultipleEntryOperation(String name, EntryProcessor entryProcessor) {
        super(name);
        this.entryProcessor = entryProcessor;
    }

    protected AbstractMultipleEntryOperation(String name, EntryBackupProcessor backupProcessor) {
        super(name);
        this.backupProcessor = backupProcessor;
    }

    @Override
    public void innerBeforeRun() {
        super.innerBeforeRun();
        this.recordStore = this.getRecordStore();
    }

    protected RecordStore getRecordStore() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.getRecordStore(this.getPartitionId(), this.name);
    }

    protected Map.Entry createMapEntry(Object key, Object value) {
        return new MapEntrySimple<Object, Object>(key, value);
    }

    protected boolean hasRegisteredListenerForThisMap() {
        EventService eventService = this.getNodeEngine().getEventService();
        return eventService.hasEventRegistration("hz:impl:mapService", this.name);
    }

    protected Object nullifyOldValueIfNecessary(Object oldValue, EntryEventType eventType) {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        InMemoryFormat format = mapConfig.getInMemoryFormat();
        if (format == InMemoryFormat.OBJECT && eventType != EntryEventType.REMOVED) {
            return null;
        }
        return oldValue;
    }

    protected MapEventPublisher getMapEventPublisher() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.getMapEventPublisher();
    }

    protected LocalMapStatsImpl getLocalMapStats() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        LocalMapStatsProvider localMapStatsProvider = mapServiceContext.getLocalMapStatsProvider();
        return localMapStatsProvider.getLocalMapStatsImpl(this.name);
    }

    private EntryEventType pickEventTypeOrNull(Map.Entry entry, Object oldValue) {
        Object value = entry.getValue();
        if (value == null) {
            return EntryEventType.REMOVED;
        }
        if (oldValue == null) {
            return EntryEventType.ADDED;
        }
        MapEntrySimple mapEntrySimple = (MapEntrySimple)entry;
        if (mapEntrySimple.isModified()) {
            return EntryEventType.UPDATED;
        }
        return null;
    }

    protected boolean noOp(Map.Entry entry, Object oldValue) {
        MapEntrySimple mapEntrySimple = (MapEntrySimple)entry;
        return !mapEntrySimple.isModified() || oldValue == null && entry.getValue() == null;
    }

    protected boolean entryRemoved(Map.Entry entry, Data key, Object oldValue, long now) {
        Object value = entry.getValue();
        if (value == null) {
            this.recordStore.remove(key);
            this.getLocalMapStats().incrementRemoves(this.getLatencyFrom(now));
            this.doPostOps(key, oldValue, entry);
            return true;
        }
        return false;
    }

    protected boolean entryAddedOrUpdated(Map.Entry entry, Data key, Object oldValue, long now) {
        Object value = entry.getValue();
        if (value != null) {
            this.put(key, value);
            this.getLocalMapStats().incrementPuts(this.getLatencyFrom(now));
            this.doPostOps(key, oldValue, entry);
            return true;
        }
        return false;
    }

    protected void doPostOps(Data key, Object oldValue, Map.Entry entry) {
        EntryEventType eventType = this.pickEventTypeOrNull(entry, oldValue);
        if (eventType == null) {
            return;
        }
        Object newValue = entry.getValue();
        this.invalidateNearCaches(key);
        newValue = this.publishEntryEvent(key, newValue, oldValue, eventType);
        this.publishWanReplicationEvent(key, newValue, eventType);
    }

    protected boolean entryRemovedBackup(Map.Entry entry, Data key) {
        Object value = entry.getValue();
        if (value == null) {
            this.recordStore.removeBackup(key);
            return true;
        }
        return false;
    }

    protected boolean entryAddedOrUpdatedBackup(Map.Entry entry, Data key) {
        Object value = entry.getValue();
        if (value != null) {
            this.recordStore.putBackup(key, value);
            return true;
        }
        return false;
    }

    protected void put(Data key, Object value) {
        this.recordStore.put(new AbstractMap.SimpleImmutableEntry<Data, Object>(key, value));
    }

    protected Object toObject(Object data) {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.toObject(data);
    }

    protected Data toData(Object obj) {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.toData(obj);
    }

    protected long getNow() {
        return Clock.currentTimeMillis();
    }

    protected void invalidateNearCaches(Data key) {
        String mapName = this.name;
        MapServiceContext mapServiceContext = this.getMapServiceContext();
        NearCacheProvider nearCacheProvider = mapServiceContext.getNearCacheProvider();
        if (nearCacheProvider.isNearCacheAndInvalidationEnabled(mapName)) {
            nearCacheProvider.invalidateAllNearCaches(mapName, key);
        }
    }

    protected Object publishEntryEvent(Data key, Object value, Object oldValue, EntryEventType eventType) {
        if (this.hasRegisteredListenerForThisMap()) {
            oldValue = this.nullifyOldValueIfNecessary(oldValue, eventType);
            MapEventPublisher mapEventPublisher = this.getMapEventPublisher();
            value = this.toData(value);
            mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, eventType, key, this.toData(oldValue), (Data)value);
        }
        return value;
    }

    protected void publishWanReplicationEvent(Data key, Object value, EntryEventType eventType) {
        MapContainer mapContainer = this.mapContainer;
        if (mapContainer.getWanReplicationPublisher() == null && mapContainer.getWanMergePolicy() == null) {
            return;
        }
        MapEventPublisher mapEventPublisher = this.getMapEventPublisher();
        if (EntryEventType.REMOVED.equals((Object)eventType)) {
            mapEventPublisher.publishWanReplicationRemove(this.name, key, this.getNow());
        } else {
            Record record = this.recordStore.getRecord(key);
            if (record != null) {
                Data dataValueAsData = this.toData(value);
                EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(key, dataValueAsData, record);
                mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
            }
        }
    }

    protected MapServiceContext getMapServiceContext() {
        MapService mapService = (MapService)this.getService();
        return mapService.getMapServiceContext();
    }

    protected long getLatencyFrom(long begin) {
        return Clock.currentTimeMillis() - begin;
    }

    protected void addToResponses(Data key, Data response) {
        if (response == null) {
            return;
        }
        if (this.responses == null) {
            this.responses = new MapEntrySet();
        }
        this.responses.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(key, response));
    }

    protected Data process(Map.Entry entry) {
        Object result = this.entryProcessor.process(entry);
        return this.toData(result);
    }

    protected void processBackup(Map.Entry entry) {
        this.backupProcessor.processBackup(entry);
    }

    protected Object getValueFor(Data dataKey, long now) {
        Map.Entry<Data, Object> mapEntry = this.recordStore.getMapEntry(dataKey, now);
        return mapEntry.getValue();
    }

    protected boolean keyNotOwnedByThisPartition(Data key) {
        InternalPartitionService partitionService = this.getNodeEngine().getPartitionService();
        return partitionService.getPartitionId(key) != this.getPartitionId();
    }

    protected void evict(boolean backup) {
        long now = Clock.currentTimeMillis();
        this.recordStore.evictEntries(now, backup);
    }
}

