/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rvcmd.AbstractRvCmd;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public abstract class AbstractRequestRvCmd
extends AbstractRvCmd {
    public static final int REQTYPE_INITIALREQUEST = 1;
    public static final int REQTYPE_REDIRECT = 2;
    public static final boolean FPRESENT_DEFAULT = true;
    private static final int TYPE_REQTYPE = 10;
    private static final int TYPE_F = 15;
    private final int reqType;
    private final boolean fPresent;

    protected AbstractRequestRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        TlvChain tlvChain = this.getRvTlvs();
        this.reqType = tlvChain.getUShort(10);
        this.fPresent = tlvChain.hasTlv(15);
        this.getMutableTlvs().removeTlvs(new int[]{10, 15});
    }

    protected AbstractRequestRvCmd(CapabilityBlock capabilityBlock) {
        this(capabilityBlock, 1);
    }

    protected AbstractRequestRvCmd(CapabilityBlock capabilityBlock, int n) {
        this(capabilityBlock, n, true);
    }

    protected AbstractRequestRvCmd(CapabilityBlock capabilityBlock, int n, boolean bl) {
        super(0, capabilityBlock);
        DefensiveTools.checkRange(n, "requestType", -1);
        this.reqType = n;
        this.fPresent = bl;
    }

    public final int getRequestType() {
        return this.reqType;
    }

    protected final boolean isFPresent() {
        return this.fPresent;
    }

    protected final void writeHeaderRvTlvs(OutputStream outputStream) throws IOException {
        if (this.reqType != -1) {
            Tlv.getUShortInstance(10, this.reqType).write(outputStream);
        }
        if (this.fPresent) {
            new Tlv(15).write(outputStream);
        }
    }
}

