/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.IcbmCommand;

public class WarnCmd
extends IcbmCommand {
    public static final int CODE_ANONYMOUS = 1;
    public static final int CODE_NOT_ANONYMOUS = 0;
    private final int anonymityCode;
    private final String warnee;

    protected WarnCmd(SnacPacket snacPacket) {
        super(8);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.anonymityCode = BinaryTools.getUShort(byteBlock, 0);
        ByteBlock byteBlock2 = byteBlock.subBlock(2);
        this.warnee = OscarTools.readScreenname(byteBlock2).getString();
    }

    public WarnCmd(String string) {
        this(string, 0);
    }

    public WarnCmd(String string, boolean bl) {
        this(string, bl ? 1 : 0);
    }

    public WarnCmd(String string, int n) {
        super(8);
        DefensiveTools.checkNull(string, "warnee");
        this.anonymityCode = n;
        this.warnee = string;
    }

    public final boolean isAnonymous() {
        return this.anonymityCode == 1;
    }

    public final int getAnonymityCode() {
        return this.anonymityCode;
    }

    public final String getWarnee() {
        return this.warnee;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.anonymityCode);
        OscarTools.writeScreenname(outputStream, this.warnee);
    }

    public String toString() {
        return "WarnCmd: warning " + this.warnee + ", anonymous=" + (this.anonymityCode == 1 ? "yes" : (this.anonymityCode == 0 ? "no" : "0x" + this.anonymityCode));
    }
}

