/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import net.sf.cindy.Message;
import net.sf.cindy.MessageRecognizer;
import net.sf.cindy.Session;
import net.sf.cindy.util.CopyOnWriteCollection;

public class MessageRecognizerChain
implements MessageRecognizer {
    private final Collection chain = new CopyOnWriteCollection();

    public void addMessageRecognizer(MessageRecognizer messageRecognizer) {
        if (messageRecognizer != null) {
            this.chain.add(messageRecognizer);
        }
    }

    public void removeMessageRecognizer(MessageRecognizer messageRecognizer) {
        if (messageRecognizer != null) {
            this.chain.remove(messageRecognizer);
        }
    }

    public Message recognize(Session session, ByteBuffer byteBuffer) {
        Iterator iterator = this.chain.iterator();
        while (iterator.hasNext()) {
            MessageRecognizer messageRecognizer = (MessageRecognizer)iterator.next();
            Message message = messageRecognizer.recognize(session, byteBuffer.slice());
            if (message == null) continue;
            return message;
        }
        return null;
    }
}

