/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import net.sourceforge.jtds.util.DESEngine;
import net.sourceforge.jtds.util.MD4Digest;

public class NtlmAuth {
    public static final byte[] answerNtChallenge(String password, byte[] nonce) throws UnsupportedEncodingException {
        byte[] key = new byte[21];
        Arrays.fill(key, (byte)0);
        byte[] pwd = password.getBytes("UnicodeLittleUnmarked");
        MD4Digest md4 = new MD4Digest();
        md4.update(pwd, 0, pwd.length);
        md4.doFinal(key, 0);
        return NtlmAuth.encryptNonce(key, nonce);
    }

    public static final byte[] answerLmChallenge(String pwd, byte[] nonce) throws UnsupportedEncodingException {
        byte[] password = NtlmAuth.convertPassword(pwd);
        DESEngine d1 = new DESEngine(true, NtlmAuth.makeDESkey(password, 0));
        DESEngine d2 = new DESEngine(true, NtlmAuth.makeDESkey(password, 7));
        byte[] encrypted = new byte[21];
        Arrays.fill(encrypted, (byte)0);
        d1.processBlock(nonce, 0, encrypted, 0);
        d2.processBlock(nonce, 0, encrypted, 8);
        return NtlmAuth.encryptNonce(encrypted, nonce);
    }

    private static byte[] encryptNonce(byte[] key, byte[] nonce) {
        byte[] out = new byte[24];
        DESEngine d1 = new DESEngine(true, NtlmAuth.makeDESkey(key, 0));
        DESEngine d2 = new DESEngine(true, NtlmAuth.makeDESkey(key, 7));
        DESEngine d3 = new DESEngine(true, NtlmAuth.makeDESkey(key, 14));
        d1.processBlock(nonce, 0, out, 0);
        d2.processBlock(nonce, 0, out, 8);
        d3.processBlock(nonce, 0, out, 16);
        return out;
    }

    private static final byte[] convertPassword(String password) throws UnsupportedEncodingException {
        byte[] pwd = password.toUpperCase().getBytes("UTF8");
        byte[] rtn = new byte[14];
        Arrays.fill(rtn, (byte)0);
        System.arraycopy(pwd, 0, rtn, 0, pwd.length > 14 ? 14 : pwd.length);
        return rtn;
    }

    private static final byte[] makeDESkey(byte[] buf, int off) {
        byte[] ret = new byte[]{(byte)(buf[off + 0] >> 1 & 0xFF), (byte)(((buf[off + 0] & 1) << 6 | (buf[off + 1] & 0xFF) >> 2 & 0xFF) & 0xFF), (byte)(((buf[off + 1] & 3) << 5 | (buf[off + 2] & 0xFF) >> 3 & 0xFF) & 0xFF), (byte)(((buf[off + 2] & 7) << 4 | (buf[off + 3] & 0xFF) >> 4 & 0xFF) & 0xFF), (byte)(((buf[off + 3] & 0xF) << 3 | (buf[off + 4] & 0xFF) >> 5 & 0xFF) & 0xFF), (byte)(((buf[off + 4] & 0x1F) << 2 | (buf[off + 5] & 0xFF) >> 6 & 0xFF) & 0xFF), (byte)(((buf[off + 5] & 0x3F) << 1 | (buf[off + 6] & 0xFF) >> 7 & 0xFF) & 0xFF), (byte)(buf[off + 6] & 0x7F)};
        int i = 0;
        while (i < 8) {
            ret[i] = (byte)(ret[i] << 1);
            ++i;
        }
        return ret;
    }
}

