/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;

public class MessageContext {
    private Part part;

    public MessageContext(Part part) {
        this.part = part;
    }

    public Part getPart() {
        return this.part;
    }

    public Message getMessage() {
        try {
            return MessageContext.getMessage(this.part);
        }
        catch (MessagingException messagingException) {
            return null;
        }
    }

    private static Message getMessage(Part part) throws MessagingException {
        while (part != null) {
            if (part instanceof Message) {
                return (Message)part;
            }
            BodyPart bodyPart = (BodyPart)part;
            Multipart multipart = bodyPart.getParent();
            if (multipart == null) {
                return null;
            }
            part = multipart.getParent();
        }
        return null;
    }

    public Session getSession() {
        Message message = this.getMessage();
        if (message != null) {
            return message.session;
        }
        return null;
    }
}

