/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.xml;

import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.voxeo.utils.Dates;
import org.joda.time.DateMidnight;
import org.joda.time.ReadableDateTime;

public class DateMidnightConverter
extends AbstractSingleValueConverter {
    public boolean canConvert(Class type) {
        return DateMidnight.class.isAssignableFrom(type);
    }

    public Object fromString(String str) {
        DateMidnight result;
        try {
            result = Dates.getDateTime(str, "yyyy-MM-dd").toDateMidnight();
        }
        catch (IllegalArgumentException e) {
            result = Dates.getDateTime(str, "yyyyMMdd").toDateMidnight();
        }
        return result;
    }

    public String toString(Object obj) {
        return Dates.format("yyyy-MM-dd", (ReadableDateTime)((DateMidnight)obj));
    }
}

