/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.security;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.ice4j.StunException;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.security.CredentialsAuthority;
import org.ice4j.security.LongTermCredential;

public class LongTermCredentialSession
implements CredentialsAuthority {
    private final LongTermCredential longTermCredential;
    private byte[] nonce;
    private final byte[] realm;

    public LongTermCredentialSession(LongTermCredential longTermCredential, byte[] realm) {
        this.longTermCredential = longTermCredential;
        this.realm = realm == null ? null : (byte[])realm.clone();
    }

    public void addAttributes(Request request) throws StunException {
        MessageFactory.addLongTermCredentialAttributes(request, this.getUsername(), this.getRealm(), this.getNonce());
    }

    public boolean checkLocalUserName(String username) {
        return this.usernameEquals(LongTermCredential.getBytes(username));
    }

    public byte[] getLocalKey(String username) {
        MessageDigest md5;
        if (!this.checkLocalUserName(username)) {
            return null;
        }
        StringBuilder localKeyBuilder = new StringBuilder();
        if (username != null) {
            localKeyBuilder.append(username);
        }
        localKeyBuilder.append(':');
        String realm = LongTermCredential.toString(this.getRealm());
        if (realm != null) {
            localKeyBuilder.append(realm);
        }
        localKeyBuilder.append(':');
        String password = LongTermCredential.toString(this.getPassword());
        if (password != null) {
            localKeyBuilder.append(password);
        }
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsaex) {
            throw new UndeclaredThrowableException(nsaex);
        }
        return md5.digest(LongTermCredential.getBytes(localKeyBuilder.toString()));
    }

    public byte[] getNonce() {
        return this.nonce == null ? null : (byte[])this.nonce.clone();
    }

    public byte[] getPassword() {
        return this.longTermCredential.getPassword();
    }

    public byte[] getRealm() {
        return this.realm == null ? null : (byte[])this.realm.clone();
    }

    public byte[] getRemoteKey(String username, String media) {
        return this.getLocalKey(username);
    }

    public byte[] getUsername() {
        return this.longTermCredential.getUsername();
    }

    public boolean realmEquals(byte[] realm) {
        return realm == null ? this.realm == null : Arrays.equals(realm, this.realm);
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce == null ? null : (byte[])nonce.clone();
    }

    public boolean usernameEquals(byte[] username) {
        byte[] thisUsername = this.getUsername();
        return username == null ? thisUsername == null : Arrays.equals(username, thisUsername);
    }
}

