/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.AbstractCallPeerJabberGTalkImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerMediaHandlerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.AbstractPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CoinPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleAction;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JinglePacketFactory;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.Reason;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ReasonPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SessionInfoPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SessionInfoType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.TransferPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.TransferredPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaType;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.packet.DiscoverInfo;

public class CallPeerJabberImpl
extends AbstractCallPeerJabberGTalkImpl<CallJabberImpl, CallPeerMediaHandlerJabberImpl, JingleIQ> {
    private static final Logger logger = Logger.getLogger(CallPeerJabberImpl.class);
    private boolean cancelled = false;
    private final Object candSyncRoot = new Object();
    private boolean contentAddWithNoCands = false;
    private boolean sessionInitiateProcessed = false;
    private final Object sessionInitiateSyncRoot = new Object();
    private final Object sidSyncRoot = new Object();
    private ContentPacketExtension.SendersEnum audioSenders = ContentPacketExtension.SendersEnum.none;
    private ContentPacketExtension.SendersEnum videoSenders = ContentPacketExtension.SendersEnum.none;

    public CallPeerJabberImpl(String peerAddress, CallJabberImpl owningCall) {
        super(peerAddress, owningCall);
        this.setMediaHandler(new CallPeerMediaHandlerJabberImpl(this));
    }

    public CallPeerJabberImpl(String peerAddress, CallJabberImpl owningCall, JingleIQ sessionIQ) {
        this(peerAddress, owningCall);
        this.sessionInitIQ = sessionIQ;
    }

    public synchronized void answer() throws OperationFailedException {
        Iterable<ContentPacketExtension> answer;
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        try {
            mediaHandler.getTransportManager().wrapupConnectivityEstablishment();
            answer = mediaHandler.generateSessionAccept();
            for (ContentPacketExtension c : answer) {
                this.setSenders(this.getMediaType(c), c.getSenders());
            }
        }
        catch (Exception exc) {
            logger.info((Object)"Failed to answer an incoming call", (Throwable)exc);
            String reasonText = "Error: " + exc.getMessage();
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate(((JingleIQ)this.sessionInitIQ).getTo(), ((JingleIQ)this.sessionInitIQ).getFrom(), ((JingleIQ)this.sessionInitIQ).getSID(), Reason.FAILED_APPLICATION, reasonText);
            this.setState(CallPeerState.FAILED, reasonText);
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)errResp);
            return;
        }
        JingleIQ response = JinglePacketFactory.createSessionAccept(((JingleIQ)this.sessionInitIQ).getTo(), ((JingleIQ)this.sessionInitIQ).getFrom(), this.getSID(), answer);
        ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)response);
        try {
            mediaHandler.start();
        }
        catch (UndeclaredThrowableException e) {
            Throwable exc = e.getUndeclaredThrowable();
            logger.info((Object)"Failed to establish a connection", exc);
            String reasonText = "Error: " + exc.getMessage();
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate(((JingleIQ)this.sessionInitIQ).getTo(), ((JingleIQ)this.sessionInitIQ).getFrom(), ((JingleIQ)this.sessionInitIQ).getSID(), Reason.GENERAL_ERROR, reasonText);
            this.setState(CallPeerState.FAILED, reasonText);
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)errResp);
            return;
        }
        this.setState(CallPeerState.CONNECTED);
    }

    @Override
    public String getSID() {
        return this.sessionInitIQ != null ? ((JingleIQ)this.sessionInitIQ).getSID() : null;
    }

    public JingleIQ getSessionIQ() {
        return (JingleIQ)this.sessionInitIQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hangup(boolean failed, String reasonText, PacketExtension reasonOtherExtension) {
        CallPeerState prevPeerState = this.getState();
        if (CallPeerState.DISCONNECTED.equals(prevPeerState) || CallPeerState.FAILED.equals(prevPeerState)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Ignoring a request to hangup a call peer that is already DISCONNECTED");
            }
            return;
        }
        this.setState(failed ? CallPeerState.FAILED : CallPeerState.DISCONNECTED, reasonText);
        JingleIQ responseIQ = null;
        if (prevPeerState.equals(CallPeerState.CONNECTED) || CallPeerState.isOnHold((CallPeerState)prevPeerState)) {
            responseIQ = JinglePacketFactory.createBye(((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), this.peerJID, this.getSID());
        } else if (CallPeerState.CONNECTING.equals(prevPeerState) || CallPeerState.CONNECTING_WITH_EARLY_MEDIA.equals(prevPeerState) || CallPeerState.ALERTING_REMOTE_SIDE.equals(prevPeerState)) {
            String jingleSID = this.getSID();
            if (jingleSID == null) {
                Object object = this.sidSyncRoot;
                synchronized (object) {
                    this.cancelled = true;
                    return;
                }
            }
            responseIQ = JinglePacketFactory.createCancel(((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), this.peerJID, this.getSID());
        } else if (prevPeerState.equals(CallPeerState.INCOMING_CALL)) {
            responseIQ = JinglePacketFactory.createBusy(((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), this.peerJID, this.getSID());
        } else if (!prevPeerState.equals(CallPeerState.BUSY) && !prevPeerState.equals(CallPeerState.FAILED)) {
            logger.info((Object)"Could not determine call peer state!");
        }
        if (responseIQ != null) {
            if (reasonOtherExtension != null) {
                ReasonPacketExtension reason = (ReasonPacketExtension)responseIQ.getExtension("reason", "");
                if (reason != null) {
                    reason.setOtherExtension(reasonOtherExtension);
                } else if (reasonOtherExtension instanceof ReasonPacketExtension) {
                    responseIQ.setReason((ReasonPacketExtension)reasonOtherExtension);
                }
            }
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)responseIQ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initiateSession(Iterable<PacketExtension> sessionInitiateExtensions) throws OperationFailedException {
        this.initiator = false;
        List<ContentPacketExtension> offer = ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).createContentList();
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        Object object = this.sidSyncRoot;
        synchronized (object) {
            this.sessionInitIQ = JinglePacketFactory.createSessionInitiate(protocolProvider.getOurJID(), this.peerJID, JingleIQ.generateSID(), offer);
            if (this.cancelled) {
                ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).getTransportManager().close();
                return;
            }
        }
        if (sessionInitiateExtensions != null) {
            for (PacketExtension sessionInitiateExtension : sessionInitiateExtensions) {
                ((JingleIQ)this.sessionInitIQ).addExtension(sessionInitiateExtension);
            }
        }
        protocolProvider.getConnection().sendPacket((Packet)this.sessionInitIQ);
    }

    void processColibriConferenceIQ(ColibriConferenceIQ conferenceIQ) {
        ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).processColibriConferenceIQ(conferenceIQ);
    }

    public void processContentAccept(JingleIQ content) {
        List<ContentPacketExtension> contents = content.getContentList();
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        try {
            mediaHandler.getTransportManager().wrapupConnectivityEstablishment();
            mediaHandler.processAnswer(contents);
            for (ContentPacketExtension c : contents) {
                this.setSenders(this.getMediaType(c), c.getSenders());
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to process a content-accept", (Throwable)e);
            String reason = "Error: " + e.getMessage();
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate(((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), this.peerJID, ((JingleIQ)this.sessionInitIQ).getSID(), Reason.INCOMPATIBLE_PARAMETERS, reason);
            this.setState(CallPeerState.FAILED, reason);
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)errResp);
            return;
        }
        mediaHandler.start();
    }

    public void processContentAdd(final JingleIQ content) {
        MediaStream newVideoStream;
        JingleIQ contentIQ;
        Iterable<ContentPacketExtension> answerContents;
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        List<ContentPacketExtension> contents = content.getContentList();
        boolean noCands = false;
        MediaStream oldVideoStream = mediaHandler.getStream(MediaType.VIDEO);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Looking for candidates in content-add.");
        }
        try {
            if (!this.contentAddWithNoCands) {
                mediaHandler.processOffer(contents);
                for (ContentPacketExtension c : contents) {
                    if (JingleUtils.getFirstCandidate(c, 1) != null) continue;
                    this.contentAddWithNoCands = true;
                    noCands = true;
                }
            }
            if (noCands) {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object object = CallPeerJabberImpl.this.candSyncRoot;
                            synchronized (object) {
                                CallPeerJabberImpl.this.candSyncRoot.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        CallPeerJabberImpl.this.processContentAdd(content);
                        CallPeerJabberImpl.this.contentAddWithNoCands = false;
                    }
                }.start();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"No candidates found in content-add, started new thread.");
                }
                return;
            }
            mediaHandler.getTransportManager().wrapupConnectivityEstablishment();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Wrapping up connectivity establishment");
            }
            answerContents = mediaHandler.generateSessionAccept();
            contentIQ = null;
        }
        catch (Exception e) {
            logger.warn((Object)"Exception occurred", (Throwable)e);
            answerContents = null;
            contentIQ = JinglePacketFactory.createContentReject(((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), this.peerJID, this.getSID(), answerContents);
        }
        if (contentIQ == null) {
            contentIQ = JinglePacketFactory.createContentAccept(((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), this.peerJID, this.getSID(), answerContents);
            for (ContentPacketExtension c : answerContents) {
                this.setSenders(this.getMediaType(c), c.getSenders());
            }
        }
        ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)contentIQ);
        mediaHandler.start();
        if (oldVideoStream == null && (newVideoStream = mediaHandler.getStream(MediaType.VIDEO)) != null && mediaHandler.isRTPTranslationEnabled(MediaType.VIDEO)) {
            try {
                ((CallJabberImpl)this.getCall()).modifyVideoContent();
            }
            catch (OperationFailedException ofe) {
                logger.error((Object)"Failed to enable RTP translation", (Throwable)ofe);
            }
        }
    }

    public void processContentModify(JingleIQ content) {
        ContentPacketExtension ext = content.getContentList().get(0);
        MediaType mediaType = this.getMediaType(ext);
        try {
            boolean modify = ext.getFirstChildOfType(RtpDescriptionPacketExtension.class) != null;
            ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).reinitContent(ext.getName(), ext, modify);
            this.setSenders(mediaType, ext.getSenders());
            if (MediaType.VIDEO.equals((Object)mediaType)) {
                ((CallJabberImpl)this.getCall()).modifyVideoContent();
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to process an incoming content-modify", (Throwable)e);
            String reason = "Error: " + e.getMessage();
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate(((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), this.peerJID, ((JingleIQ)this.sessionInitIQ).getSID(), Reason.INCOMPATIBLE_PARAMETERS, reason);
            this.setState(CallPeerState.FAILED, reason);
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)errResp);
            return;
        }
    }

    public void processContentReject(JingleIQ content) {
        if (content.getContentList().isEmpty()) {
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate(((JingleIQ)this.sessionInitIQ).getTo(), ((JingleIQ)this.sessionInitIQ).getFrom(), ((JingleIQ)this.sessionInitIQ).getSID(), Reason.INCOMPATIBLE_PARAMETERS, "Error: content rejected");
            this.setState(CallPeerState.FAILED, "Error: content rejected");
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)errResp);
            return;
        }
    }

    public void processContentRemove(JingleIQ content) {
        List<ContentPacketExtension> contents = content.getContentList();
        boolean videoContentRemoved = false;
        if (!contents.isEmpty()) {
            CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
            for (ContentPacketExtension c : contents) {
                mediaHandler.removeContent(c.getName());
                MediaType mediaType = this.getMediaType(c);
                this.setSenders(mediaType, ContentPacketExtension.SendersEnum.none);
                if (!MediaType.VIDEO.equals((Object)mediaType)) continue;
                videoContentRemoved = true;
            }
        }
        if (videoContentRemoved) {
            try {
                ((CallJabberImpl)this.getCall()).modifyVideoContent();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to update Jingle sessions");
            }
        }
    }

    public void processSessionAccept(JingleIQ sessionInitIQ) {
        this.sessionInitIQ = sessionInitIQ;
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        List<ContentPacketExtension> answer = sessionInitIQ.getContentList();
        try {
            mediaHandler.getTransportManager().wrapupConnectivityEstablishment();
            mediaHandler.processAnswer(answer);
            for (ContentPacketExtension c : answer) {
                this.setSenders(this.getMediaType(c), c.getSenders());
            }
        }
        catch (Exception exc) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Failed to process a session-accept", (Throwable)exc);
            }
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate(sessionInitIQ.getTo(), sessionInitIQ.getFrom(), sessionInitIQ.getSID(), Reason.INCOMPATIBLE_PARAMETERS, String.valueOf(exc.getClass().getName()) + ": " + exc.getMessage());
            this.setState(CallPeerState.FAILED, "Error: " + exc.getMessage());
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)errResp);
            return;
        }
        this.setState(CallPeerState.CONNECTED);
        mediaHandler.start();
        this.sendModifyVideoContent();
    }

    public void processSessionInfo(SessionInfoPacketExtension info) {
        switch (info.getType()) {
            case ringing: {
                this.setState(CallPeerState.ALERTING_REMOTE_SIDE);
                break;
            }
            case hold: {
                ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).setRemotelyOnHold(true);
                this.reevalRemoteHoldStatus();
                break;
            }
            case active: 
            case unhold: {
                ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).setRemotelyOnHold(false);
                this.reevalRemoteHoldStatus();
                break;
            }
            default: {
                logger.warn((Object)"Received SessionInfoPacketExtension of unknown type");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void processSessionInitiate(JingleIQ sessionInitIQ) {
        Object calleeURI;
        this.sessionInitIQ = sessionInitIQ;
        this.initiator = true;
        List<ContentPacketExtension> offer = sessionInitIQ.getContentList();
        try {
            ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).processOffer(offer);
            AbstractPacketExtension coin = null;
            for (PacketExtension ext : sessionInitIQ.getExtensions()) {
                if (!ext.getElementName().equals("conference-info")) continue;
                coin = (CoinPacketExtension)ext;
                break;
            }
            if (coin != null) {
                this.setConferenceFocus(Boolean.parseBoolean((String)coin.getAttribute("isfocus")));
            }
        }
        catch (Exception ex) {
            logger.info((Object)"Failed to process an incoming session initiate", (Throwable)ex);
            String reasonText = "Error: " + ex.getMessage();
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate(sessionInitIQ.getTo(), sessionInitIQ.getFrom(), sessionInitIQ.getSID(), Reason.INCOMPATIBLE_PARAMETERS, reasonText);
            this.setState(CallPeerState.FAILED, reasonText);
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)errResp);
            return;
        }
        if (this.getDiscoveryInfo() == null) {
            calleeURI = sessionInitIQ.getFrom();
            this.retrieveDiscoveryInfo((String)calleeURI);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"will send ringing response: ");
        }
        ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)JinglePacketFactory.createRinging(sessionInitIQ));
        calleeURI = this.sessionInitiateSyncRoot;
        synchronized (calleeURI) {
            this.sessionInitiateProcessed = true;
            this.sessionInitiateSyncRoot.notify();
        }
        DiscoverInfo discoverInfo = this.getDiscoveryInfo();
        if (discoverInfo != null && discoverInfo.containsFeature("urn:ietf:rfc:3264")) {
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)JinglePacketFactory.createDescriptionInfo(sessionInitIQ.getTo(), sessionInitIQ.getFrom(), sessionInitIQ.getSID(), ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).getLocalContentList()));
        }
    }

    public void processSessionTerminate(JingleIQ jingleIQ) {
        String reasonStr = "Call ended by remote side.";
        ReasonPacketExtension reasonExt = jingleIQ.getReason();
        if (reasonExt != null) {
            String text;
            Reason reason = reasonExt.getReason();
            if (reason != null) {
                reasonStr = String.valueOf(reasonStr) + " Reason: " + reason.toString() + ".";
            }
            if ((text = reasonExt.getText()) != null) {
                reasonStr = String.valueOf(reasonStr) + " " + text;
            }
        }
        this.setState(CallPeerState.DISCONNECTED, reasonStr);
    }

    public void processTransfer(TransferPacketExtension transfer) throws OperationFailedException {
        String attendantAddress = transfer.getFrom();
        if (attendantAddress == null) {
            throw new OperationFailedException("Session transfer must contain a 'from' attribute value.", 11);
        }
        String calleeAddress = transfer.getTo();
        if (calleeAddress == null) {
            throw new OperationFailedException("Session transfer must contain a 'to' attribute value.", 11);
        }
        Roster roster = ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().getRoster();
        if (!roster.contains(StringUtils.parseBareAddress((String)calleeAddress))) {
            String failedMessage = "Tranfer impossible:\nAccount roster does not contain tansfer peer: " + StringUtils.parseBareAddress((String)calleeAddress);
            this.setState(CallPeerState.FAILED, failedMessage);
            logger.info((Object)failedMessage);
        }
        OperationSetBasicTelephonyJabberImpl basicTelephony = (OperationSetBasicTelephonyJabberImpl)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOperationSet(OperationSetBasicTelephony.class);
        CallJabberImpl calleeCall = new CallJabberImpl(basicTelephony);
        TransferPacketExtension calleeTransfer = new TransferPacketExtension();
        String sid = transfer.getSID();
        calleeTransfer.setFrom(attendantAddress);
        if (sid != null) {
            calleeTransfer.setSID(sid);
            calleeTransfer.setTo(calleeAddress);
        }
        basicTelephony.createOutgoingCall(calleeCall, calleeAddress, Arrays.asList(calleeTransfer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTransportInfo(JingleIQ jingleIQ) {
        Object object;
        try {
            if (this.isInitiator()) {
                object = this.sessionInitiateSyncRoot;
                synchronized (object) {
                    if (!this.sessionInitiateProcessed) {
                        try {
                            this.sessionInitiateSyncRoot.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).processTransportInfo(jingleIQ.getContentList());
        }
        catch (OperationFailedException ofe) {
            logger.warn((Object)"Failed to process an incoming transport-info", (Throwable)ofe);
            String reasonText = "Error: " + ofe.getMessage();
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate(((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), this.peerJID, ((JingleIQ)this.sessionInitIQ).getSID(), Reason.GENERAL_ERROR, reasonText);
            this.setState(CallPeerState.FAILED, reasonText);
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)errResp);
            return;
        }
        object = this.candSyncRoot;
        synchronized (object) {
            this.candSyncRoot.notify();
        }
    }

    public void putOnHold(boolean onHold) throws OperationFailedException {
        SessionInfoType type;
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        mediaHandler.setLocallyOnHold(onHold);
        if (onHold) {
            type = SessionInfoType.hold;
        } else {
            type = SessionInfoType.unhold;
            ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).reinitAllContents();
        }
        this.reevalLocalHoldStatus();
        JingleIQ onHoldIQ = JinglePacketFactory.createSessionInfo(((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), this.peerJID, this.getSID(), type);
        ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)onHoldIQ);
    }

    private void sendAddVideoContent() {
        List<ContentPacketExtension> contents;
        try {
            contents = ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).createContentList(MediaType.VIDEO);
        }
        catch (Exception exc) {
            logger.warn((Object)"Failed to gather content for video type", (Throwable)exc);
            return;
        }
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        JingleIQ contentIQ = JinglePacketFactory.createContentAdd(protocolProvider.getOurJID(), this.peerJID, this.getSID(), contents);
        protocolProvider.getConnection().sendPacket((Packet)contentIQ);
    }

    public void sendCoinSessionInfo() {
        JingleIQ sessionInfoIQ = JinglePacketFactory.createSessionInfo(((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOurJID(), this.peerJID, this.getSID());
        CoinPacketExtension coinExt = new CoinPacketExtension(((CallJabberImpl)this.getCall()).isConferenceFocus());
        sessionInfoIQ.addExtension(coinExt);
        ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)sessionInfoIQ);
    }

    private MediaDirection getDirectionForJingle(MediaType mediaType) {
        ContentPacketExtension.SendersEnum senders;
        MediaDirection direction = MediaDirection.INACTIVE;
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        if (MediaType.AUDIO == mediaType && mediaHandler.isLocalAudioTransmissionEnabled() || MediaType.VIDEO == mediaType && this.isLocalVideoStreaming()) {
            direction = direction.or(MediaDirection.SENDONLY);
        }
        if ((senders = this.getSenders(mediaType)) == null || senders == ContentPacketExtension.SendersEnum.both || this.isInitiator() && senders == ContentPacketExtension.SendersEnum.initiator || !this.isInitiator() && senders == ContentPacketExtension.SendersEnum.responder) {
            direction = direction.or(MediaDirection.RECVONLY);
        }
        if (((CallJabberImpl)this.getCall()).isConferenceFocus()) {
            for (CallPeerJabberImpl peer : ((CallJabberImpl)this.getCall()).getCallPeerList()) {
                if (peer == this || (senders = peer.getSenders(mediaType)) != null && senders != ContentPacketExtension.SendersEnum.both && (!peer.isInitiator() || senders != ContentPacketExtension.SendersEnum.initiator) && (peer.isInitiator() || senders != ContentPacketExtension.SendersEnum.responder)) continue;
                direction = direction.or(MediaDirection.SENDONLY);
                break;
            }
        }
        return direction;
    }

    public boolean sendModifyVideoContent() {
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        MediaDirection direction = this.getDirectionForJingle(MediaType.VIDEO);
        ContentPacketExtension remoteContent = mediaHandler.getLocalContent(MediaType.VIDEO.toString());
        if (remoteContent == null) {
            if (direction == MediaDirection.INACTIVE) {
                return false;
            }
            if (this.getState() == CallPeerState.CONNECTED) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Adding video content for " + (Object)((Object)this)));
                }
                this.sendAddVideoContent();
                return true;
            }
            return false;
        }
        if (direction == MediaDirection.INACTIVE) {
            this.sendRemoveVideoContent();
            return true;
        }
        ContentPacketExtension.SendersEnum senders = this.getSenders(MediaType.VIDEO);
        if (senders == null) {
            senders = ContentPacketExtension.SendersEnum.both;
        }
        ContentPacketExtension.SendersEnum newSenders = ContentPacketExtension.SendersEnum.none;
        if (MediaDirection.SENDRECV == direction) {
            newSenders = ContentPacketExtension.SendersEnum.both;
        } else if (MediaDirection.RECVONLY == direction) {
            newSenders = this.isInitiator() ? ContentPacketExtension.SendersEnum.initiator : ContentPacketExtension.SendersEnum.responder;
        } else if (MediaDirection.SENDONLY == direction) {
            newSenders = this.isInitiator() ? ContentPacketExtension.SendersEnum.responder : ContentPacketExtension.SendersEnum.initiator;
        }
        ContentPacketExtension ext = new ContentPacketExtension();
        String remoteContentName = remoteContent.getName();
        ext.setSenders(newSenders);
        ext.setCreator(remoteContent.getCreator());
        ext.setName(remoteContentName);
        if (newSenders != senders) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Sending content modify, senders: " + (Object)((Object)senders) + "->" + (Object)((Object)newSenders)));
            }
            ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
            JingleIQ contentIQ = JinglePacketFactory.createContentModify(protocolProvider.getOurJID(), this.peerJID, this.getSID(), ext);
            protocolProvider.getConnection().sendPacket((Packet)contentIQ);
        }
        try {
            mediaHandler.reinitContent(remoteContentName, ext, false);
            mediaHandler.start();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception occurred during media reinitialization", (Throwable)e);
        }
        return newSenders != senders;
    }

    public void sendModifyVideoResolutionContent() {
        ContentPacketExtension content;
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        ContentPacketExtension remoteContent = mediaHandler.getRemoteContent(MediaType.VIDEO.toString());
        logger.info((Object)"send modify-content to change resolution");
        try {
            content = mediaHandler.createContentForMedia(MediaType.VIDEO);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to gather content for video type", (Throwable)e);
            return;
        }
        ContentPacketExtension.SendersEnum senders = remoteContent.getSenders();
        if (senders != null) {
            content.setSenders(senders);
        }
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        JingleIQ contentIQ = JinglePacketFactory.createContentModify(protocolProvider.getOurJID(), this.peerJID, this.getSID(), content);
        protocolProvider.getConnection().sendPacket((Packet)contentIQ);
        try {
            mediaHandler.reinitContent(remoteContent.getName(), content, false);
            mediaHandler.start();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception occurred when media reinitialization", (Throwable)e);
        }
    }

    private void sendRemoveVideoContent() {
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
        ContentPacketExtension content = new ContentPacketExtension();
        ContentPacketExtension remoteContent = mediaHandler.getRemoteContent(MediaType.VIDEO.toString());
        if (remoteContent == null) {
            return;
        }
        String remoteContentName = remoteContent.getName();
        content.setName(remoteContentName);
        content.setCreator(remoteContent.getCreator());
        content.setSenders(remoteContent.getSenders());
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        JingleIQ contentIQ = JinglePacketFactory.createContentRemove(protocolProvider.getOurJID(), this.peerJID, this.getSID(), Arrays.asList(content));
        protocolProvider.getConnection().sendPacket((Packet)contentIQ);
        mediaHandler.removeContent(remoteContentName);
        this.setSenders(MediaType.VIDEO, ContentPacketExtension.SendersEnum.none);
    }

    protected void sendTransportInfo(Iterable<ContentPacketExtension> contents) {
        if (this.cancelled) {
            return;
        }
        JingleIQ transportInfo = new JingleIQ();
        for (ContentPacketExtension content : contents) {
            transportInfo.addContent(content);
        }
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        transportInfo.setAction(JingleAction.TRANSPORT_INFO);
        transportInfo.setFrom(protocolProvider.getOurJID());
        transportInfo.setSID(this.getSID());
        transportInfo.setTo(this.getAddress());
        transportInfo.setType(IQ.Type.SET);
        PacketCollector collector = protocolProvider.getConnection().createPacketCollector((PacketFilter)new PacketIDFilter(transportInfo.getPacketID()));
        protocolProvider.getConnection().sendPacket((Packet)transportInfo);
        collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
    }

    public void setState(CallPeerState newState, String reason, int reasonCode) {
        CallPeerState oldState = this.getState();
        try {
            if (CallPeerState.DISCONNECTED.equals(newState) || CallPeerState.FAILED.equals(newState)) {
                ((CallPeerMediaHandlerJabberImpl)this.getMediaHandler()).getTransportManager().close();
            }
        }
        finally {
            super.setState(newState, reason, reasonCode);
        }
        if (CallPeerState.isOnHold((CallPeerState)oldState) && CallPeerState.CONNECTED.equals(newState)) {
            try {
                ((CallJabberImpl)this.getCall()).modifyVideoContent();
            }
            catch (OperationFailedException ofe) {
                logger.error((Object)("Failed to update call video state after 'hold' status removed for " + (Object)((Object)this)));
            }
        }
    }

    protected void transfer(String to, String sid) throws OperationFailedException {
        JingleIQ transferSessionInfo = new JingleIQ();
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        transferSessionInfo.setAction(JingleAction.SESSION_INFO);
        transferSessionInfo.setFrom(protocolProvider.getOurJID());
        transferSessionInfo.setSID(this.getSID());
        transferSessionInfo.setTo(this.getAddress());
        transferSessionInfo.setType(IQ.Type.SET);
        TransferPacketExtension transfer = new TransferPacketExtension();
        if (sid != null) {
            transfer.setFrom(protocolProvider.getOurJID());
            transfer.setSID(sid);
            OperationSetBasicTelephonyJabberImpl basicTelephony = (OperationSetBasicTelephonyJabberImpl)protocolProvider.getOperationSet(OperationSetBasicTelephony.class);
            CallPeerJabberImpl callPeer = basicTelephony.getActiveCallPeer(sid);
            if (callPeer != null && !CallPeerState.isOnHold((CallPeerState)callPeer.getState())) {
                callPeer.putOnHold(true);
            }
            if (!CallPeerState.isOnHold((CallPeerState)this.getState())) {
                this.putOnHold(true);
            }
        }
        transfer.setTo(to);
        transferSessionInfo.addExtension(transfer);
        XMPPConnection connection = protocolProvider.getConnection();
        PacketCollector collector = connection.createPacketCollector((PacketFilter)new PacketIDFilter(transferSessionInfo.getPacketID()));
        protocolProvider.getConnection().sendPacket((Packet)transferSessionInfo);
        Packet result = collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        if (result == null) {
            throw new OperationFailedException("No response to the \"transfer\" request.", 11);
        }
        if (((IQ)result).getType() != IQ.Type.RESULT) {
            throw new OperationFailedException("Remote peer does not manage call \"transfer\".Response to the \"transfer\" request is: " + ((IQ)result).getType(), 11);
        }
        String message = String.valueOf(sid == null ? "Unattended" : "Attended") + " transfer to: " + to;
        this.hangup(false, message, new ReasonPacketExtension(Reason.SUCCESS, message, new TransferredPacketExtension()));
    }

    public String getEntity() {
        return this.getAddress();
    }

    public MediaDirection getDirection(MediaType mediaType) {
        ContentPacketExtension.SendersEnum senders = this.getSenders(mediaType);
        if (senders == ContentPacketExtension.SendersEnum.none) {
            return MediaDirection.INACTIVE;
        }
        if (senders == null || senders == ContentPacketExtension.SendersEnum.both) {
            return MediaDirection.SENDRECV;
        }
        if (senders == ContentPacketExtension.SendersEnum.initiator) {
            return this.isInitiator() ? MediaDirection.RECVONLY : MediaDirection.SENDONLY;
        }
        return this.isInitiator() ? MediaDirection.SENDONLY : MediaDirection.RECVONLY;
    }

    public ContentPacketExtension.SendersEnum getSenders(MediaType mediaType) {
        if (MediaType.AUDIO.equals((Object)mediaType)) {
            return this.audioSenders;
        }
        if (MediaType.VIDEO.equals((Object)mediaType)) {
            return this.videoSenders;
        }
        throw new IllegalArgumentException("mediaType");
    }

    public void setSenders(MediaType mediaType, ContentPacketExtension.SendersEnum senders) {
        if (mediaType == null) {
            return;
        }
        if (MediaType.AUDIO.equals((Object)mediaType)) {
            this.audioSenders = senders;
        } else if (MediaType.VIDEO.equals((Object)mediaType)) {
            this.videoSenders = senders;
        } else {
            throw new IllegalArgumentException("mediaType");
        }
    }

    public MediaType getMediaType(ContentPacketExtension content) {
        String contentName = content.getName();
        if (contentName == null) {
            return null;
        }
        MediaType mediaType = JingleUtils.getMediaType(content);
        if (mediaType == null) {
            CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)this.getMediaHandler();
            MediaType[] mediaTypeArray = MediaType.values();
            int n = mediaTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MediaType m = mediaTypeArray[n2];
                ContentPacketExtension sessionContent = mediaHandler.getRemoteContent(m.toString());
                if (sessionContent == null) {
                    sessionContent = mediaHandler.getLocalContent(m.toString());
                }
                if (sessionContent != null && contentName.equals(sessionContent.getName())) {
                    mediaType = m;
                    break;
                }
                ++n2;
            }
        }
        return mediaType;
    }
}

