/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.format;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.impl.neomedia.format.AudioMediaFormatImpl;
import org.jitsi.impl.neomedia.format.VideoMediaFormatImpl;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.format.AudioMediaFormat;
import org.jitsi.service.neomedia.format.MediaFormat;

public abstract class MediaFormatImpl<T extends Format>
implements MediaFormat {
    public static final String CLOCK_RATE_PNAME = "clockRate";
    static final Map<String, String> EMPTY_FORMAT_PARAMETERS = Collections.emptyMap();
    public static final String ENCODING_PNAME = "encoding";
    public static final String FORMAT_PARAMETERS_PNAME = "fmtps";
    private final Map<String, String> advancedAttributes;
    private Map<String, String> codecSettings = EMPTY_FORMAT_PARAMETERS;
    protected final T format;
    private final Map<String, String> formatParameters;

    public static MediaFormat createInstance(Format format) {
        MediaFormat mediaFormat = MediaUtils.getMediaFormat(format);
        if (mediaFormat == null) {
            if (format instanceof AudioFormat) {
                mediaFormat = new AudioMediaFormatImpl((AudioFormat)format);
            } else if (format instanceof VideoFormat) {
                mediaFormat = new VideoMediaFormatImpl((VideoFormat)format);
            }
        }
        return mediaFormat;
    }

    public static MediaFormatImpl<? extends Format> createInstance(Format format, double clockRate, Map<String, String> formatParameters, Map<String, String> advancedAttributess) {
        if (format instanceof AudioFormat) {
            AudioFormat audioFormat = (AudioFormat)format;
            AudioFormat clockRateAudioFormat = new AudioFormat(audioFormat.getEncoding(), clockRate, audioFormat.getSampleSizeInBits(), audioFormat.getChannels());
            return new AudioMediaFormatImpl((AudioFormat)clockRateAudioFormat.intersects(audioFormat), formatParameters, advancedAttributess);
        }
        if (format instanceof VideoFormat) {
            return new VideoMediaFormatImpl((VideoFormat)format, clockRate, -1.0f, formatParameters, advancedAttributess);
        }
        return null;
    }

    public static boolean formatParametersAreEqual(String encoding, Map<String, String> fmtps1, Map<String, String> fmtps2) {
        if (fmtps1 == null) {
            return fmtps2 == null || fmtps2.isEmpty();
        }
        if (fmtps2 == null) {
            return fmtps1 == null || fmtps1.isEmpty();
        }
        if (fmtps1.size() == fmtps2.size()) {
            for (Map.Entry<String, String> fmtp1 : fmtps1.entrySet()) {
                String key1 = fmtp1.getKey();
                if (!fmtps2.containsKey(key1)) {
                    return false;
                }
                String value1 = fmtp1.getValue();
                String value2 = fmtps2.get(key1);
                if (!(value1 == null || value1.length() == 0 ? value2 != null && value2.length() != 0 : !value1.equals(value2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected MediaFormatImpl(T format) {
        this(format, null, null);
    }

    protected MediaFormatImpl(T format, Map<String, String> formatParameters, Map<String, String> advancedAttributes) {
        if (format == null) {
            throw new NullPointerException("format");
        }
        this.format = format;
        this.formatParameters = formatParameters == null || formatParameters.isEmpty() ? EMPTY_FORMAT_PARAMETERS : new HashMap<String, String>(formatParameters);
        this.advancedAttributes = advancedAttributes == null || advancedAttributes.isEmpty() ? EMPTY_FORMAT_PARAMETERS : new HashMap<String, String>(advancedAttributes);
    }

    public boolean advancedAttributesAreEqual(Map<String, String> adv, Map<String, String> adv2) {
        if (adv == null && adv2 != null || adv != null && adv2 == null) {
            return false;
        }
        if (adv == null && adv2 == null) {
            return true;
        }
        if (adv.size() != adv2.size()) {
            return false;
        }
        for (Map.Entry<String, String> a : adv.entrySet()) {
            String value = adv2.get(a.getKey());
            if (value == null) {
                return false;
            }
            if (value.equals(a.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object mediaFormat) {
        if (this == mediaFormat) {
            return true;
        }
        if (!this.getClass().isInstance(mediaFormat)) {
            return false;
        }
        MediaFormatImpl mediaFormatImpl = (MediaFormatImpl)mediaFormat;
        return ((Format)this.getFormat()).equals(mediaFormatImpl.getFormat()) && this.formatParametersAreEqual(this.getFormatParameters(), mediaFormatImpl.getFormatParameters());
    }

    protected boolean formatParametersAreEqual(Map<String, String> fmtps1, Map<String, String> fmtps2) {
        return MediaFormatImpl.formatParametersAreEqual(this.getEncoding(), fmtps1, fmtps2);
    }

    @Override
    public boolean formatParametersMatch(Map<String, String> fmtps) {
        return true;
    }

    @Override
    public Map<String, String> getAdditionalCodecSettings() {
        return this.codecSettings;
    }

    @Override
    public Map<String, String> getAdvancedAttributes() {
        return this.advancedAttributes == EMPTY_FORMAT_PARAMETERS ? EMPTY_FORMAT_PARAMETERS : new HashMap<String, String>(this.advancedAttributes);
    }

    @Override
    public String getClockRateString() {
        double clockRate = this.getClockRate();
        long clockRateL = (long)clockRate;
        if ((double)clockRateL == clockRate) {
            return Long.toString(clockRateL);
        }
        return Double.toString(clockRate);
    }

    @Override
    public String getEncoding() {
        int rtpPos;
        int encodingLength;
        String jmfEncoding = this.getJMFEncoding();
        String encoding = MediaUtils.jmfEncodingToEncoding(jmfEncoding);
        if (encoding == null && (encodingLength = (encoding = jmfEncoding).length()) > 3 && "/rtp".equalsIgnoreCase(encoding.substring(rtpPos = encodingLength - 4))) {
            encoding = encoding.substring(0, rtpPos);
        }
        return encoding;
    }

    public T getFormat() {
        return this.format;
    }

    @Override
    public Map<String, String> getFormatParameters() {
        return this.formatParameters == EMPTY_FORMAT_PARAMETERS ? EMPTY_FORMAT_PARAMETERS : new HashMap<String, String>(this.formatParameters);
    }

    public String getJMFEncoding() {
        return ((Format)this.format).getEncoding();
    }

    @Override
    public String getRealUsedClockRateString() {
        if (this.getEncoding().equalsIgnoreCase("G722")) {
            return "16000";
        }
        return this.getClockRateString();
    }

    @Override
    public byte getRTPPayloadType() {
        return MediaUtils.getRTPPayloadType(this.getJMFEncoding(), this.getClockRate());
    }

    public int hashCode() {
        return this.getJMFEncoding().hashCode() | this.getFormatParameters().hashCode();
    }

    @Override
    public boolean matches(MediaFormat format) {
        if (format == null) {
            return false;
        }
        MediaType mediaType = format.getMediaType();
        String encoding = format.getEncoding();
        double clockRate = format.getClockRate();
        int channels = MediaType.AUDIO.equals((Object)mediaType) ? ((AudioMediaFormat)format).getChannels() : -1;
        Map<String, String> formatParameters = format.getFormatParameters();
        return this.matches(mediaType, encoding, clockRate, channels, formatParameters);
    }

    @Override
    public boolean matches(MediaType mediaType, String encoding, double clockRate, int channels, Map<String, String> formatParameters) {
        double formatClockRate;
        if (!this.getMediaType().equals((Object)mediaType) || !this.getEncoding().equals(encoding)) {
            return false;
        }
        if (clockRate != -1.0 && (formatClockRate = this.getClockRate()) != -1.0 && formatClockRate != clockRate) {
            return false;
        }
        if (MediaType.AUDIO.equals((Object)mediaType)) {
            int formatChannels;
            if (channels == -1) {
                channels = 1;
            }
            if ((formatChannels = ((AudioMediaFormat)((Object)this)).getChannels()) == -1) {
                formatChannels = 1;
            }
            if (formatChannels != channels) {
                return false;
            }
        }
        return this.formatParametersMatch(formatParameters);
    }

    @Override
    public void setAdditionalCodecSettings(Map<String, String> settings) {
        this.codecSettings = settings == null || settings.isEmpty() ? EMPTY_FORMAT_PARAMETERS : settings;
    }

    @Override
    public String toString() {
        Map<String, String> formatParameters;
        int channels;
        StringBuffer str = new StringBuffer();
        str.append("rtpmap:");
        str.append(this.getRTPPayloadType());
        str.append(' ');
        str.append(this.getEncoding());
        str.append('/');
        str.append(this.getClockRateString());
        if (MediaType.AUDIO.equals((Object)this.getMediaType()) && (channels = ((AudioFormat)this.getFormat()).getChannels()) != 1) {
            str.append('/');
            str.append(channels);
        }
        if (!(formatParameters = this.getFormatParameters()).isEmpty()) {
            str.append(" fmtp:");
            boolean prependSeparator = false;
            for (Map.Entry<String, String> formatParameter : formatParameters.entrySet()) {
                if (prependSeparator) {
                    str.append(';');
                } else {
                    prependSeparator = true;
                }
                str.append(formatParameter.getKey());
                str.append('=');
                str.append(formatParameter.getValue());
            }
        }
        return str.toString();
    }
}

