/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.device.CoreAudioDevice;
import org.jitsi.impl.neomedia.device.MacCoreAudioDevice;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.MacCoreaudioRenderer;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.util.Logger;

public class MacCoreaudioSystem
extends AudioSystem {
    private static final String LOCATOR_PROTOCOL = "maccoreaudio";
    private static final Logger logger = Logger.getLogger(MacCoreaudioSystem.class);
    private static int openStream = 0;
    private static final Object openStreamSyncRoot = new Object();
    private static int updateAvailableDeviceList = 0;
    private static final List<WeakReference<UpdateAvailableDeviceListListener>> updateAvailableDeviceListListeners = new LinkedList<WeakReference<UpdateAvailableDeviceListListener>>();
    private static final Object updateAvailableDeviceListSyncRoot = new Object();
    private Runnable devicesChangedCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUpdateAvailableDeviceListListener(UpdateAvailableDeviceListListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<WeakReference<UpdateAvailableDeviceListListener>> list = updateAvailableDeviceListListeners;
        synchronized (list) {
            Iterator<WeakReference<UpdateAvailableDeviceListListener>> i = updateAvailableDeviceListListeners.iterator();
            boolean add = true;
            while (i.hasNext()) {
                UpdateAvailableDeviceListListener l = (UpdateAvailableDeviceListListener)i.next().get();
                if (l == null) {
                    i.remove();
                    continue;
                }
                if (!l.equals(listener)) continue;
                add = false;
            }
            if (add) {
                updateAvailableDeviceListListeners.add(new WeakReference<UpdateAvailableDeviceListListener>(listener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void didOpenStream() {
        Object object = openStreamSyncRoot;
        synchronized (object) {
            if (--openStream < 0) {
                openStream = 0;
            }
            openStreamSyncRoot.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void didUpdateAvailableDeviceList() {
        Object object = openStreamSyncRoot;
        synchronized (object) {
            if (--updateAvailableDeviceList < 0) {
                updateAvailableDeviceList = 0;
            }
            openStreamSyncRoot.notifyAll();
        }
        MacCoreaudioSystem.fireUpdateAvailableDeviceListEvent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireUpdateAvailableDeviceListEvent(boolean will) {
        block10: {
            try {
                ArrayList<WeakReference<UpdateAvailableDeviceListListener>> ls;
                List<WeakReference<UpdateAvailableDeviceListListener>> list = updateAvailableDeviceListListeners;
                synchronized (list) {
                    ls = new ArrayList<WeakReference<UpdateAvailableDeviceListListener>>(updateAvailableDeviceListListeners);
                }
                for (WeakReference weakReference : ls) {
                    UpdateAvailableDeviceListListener l = (UpdateAvailableDeviceListListener)weakReference.get();
                    if (l == null) continue;
                    try {
                        if (will) {
                            l.willUpdateAvailableDeviceList();
                            continue;
                        }
                        l.didUpdateAvailableDeviceList();
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.error("UpdateAvailableDeviceListListener." + (will ? "will" : "did") + "UpdateAvailableDeviceList failed.", t);
                    }
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) break block10;
                throw (ThreadDeath)t;
            }
        }
    }

    private static double getSupportedSampleRate(boolean input, String deviceUID, boolean isEchoCancel) {
        double supportedSampleRate = MacCoreAudioDevice.getNominalSampleRate(deviceUID, false, isEchoCancel);
        if (supportedSampleRate >= MediaUtils.MAX_AUDIO_SAMPLE_RATE) {
            supportedSampleRate = 44100.0;
        }
        return supportedSampleRate;
    }

    private static void waitForOpenStream() {
        boolean interrupted = false;
        while (openStream > 0) {
            try {
                openStreamSyncRoot.wait();
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private static void waitForUpdateAvailableDeviceList() {
        boolean interrupted = false;
        while (updateAvailableDeviceList > 0) {
            try {
                openStreamSyncRoot.wait();
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void willOpenStream() {
        Object object = openStreamSyncRoot;
        synchronized (object) {
            MacCoreaudioSystem.waitForUpdateAvailableDeviceList();
            ++openStream;
            openStreamSyncRoot.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void willUpdateAvailableDeviceList() {
        Object object = openStreamSyncRoot;
        synchronized (object) {
            MacCoreaudioSystem.waitForOpenStream();
            ++updateAvailableDeviceList;
            openStreamSyncRoot.notifyAll();
        }
        MacCoreaudioSystem.fireUpdateAvailableDeviceListEvent(true);
    }

    MacCoreaudioSystem() throws Exception {
        super(LOCATOR_PROTOCOL, 13);
    }

    private void bubbleUpUsbDevices(List<CaptureDeviceInfo2> devices) {
        if (!devices.isEmpty()) {
            ArrayList<CaptureDeviceInfo2> nonUsbDevices = new ArrayList<CaptureDeviceInfo2>(devices.size());
            Iterator<CaptureDeviceInfo2> i = devices.iterator();
            while (i.hasNext()) {
                CaptureDeviceInfo2 d = i.next();
                if (d.isSameTransportType("USB")) continue;
                nonUsbDevices.add(d);
                i.remove();
            }
            if (!nonUsbDevices.isEmpty()) {
                for (CaptureDeviceInfo2 d : nonUsbDevices) {
                    devices.add(d);
                }
            }
        }
    }

    @Override
    protected void doInitialize() throws Exception {
        int i;
        if (!CoreAudioDevice.isLoaded) {
            String message = "MacOSX CoreAudio library is not loaded";
            if (logger.isInfoEnabled()) {
                logger.info(message);
            }
            throw new Exception(message);
        }
        if (this.devicesChangedCallback == null) {
            CoreAudioDevice.initDevices();
        }
        int channels = 1;
        int sampleSizeInBits = 16;
        String defaultInputdeviceUID = MacCoreAudioDevice.getDefaultInputDeviceUID();
        String defaultOutputdeviceUID = MacCoreAudioDevice.getDefaultOutputDeviceUID();
        LinkedList<CaptureDeviceInfo2> captureAndPlaybackDevices = new LinkedList<CaptureDeviceInfo2>();
        LinkedList<CaptureDeviceInfo2> captureDevices = new LinkedList<CaptureDeviceInfo2>();
        LinkedList<CaptureDeviceInfo2> playbackDevices = new LinkedList<CaptureDeviceInfo2>();
        boolean loggerIsDebugEnabled = logger.isDebugEnabled();
        String[] deviceUIDList = MacCoreAudioDevice.getDeviceUIDList();
        for (i = 0; i < deviceUIDList.length; ++i) {
            String deviceUID = deviceUIDList[i];
            String name = CoreAudioDevice.getDeviceName(deviceUID);
            boolean isInputDevice = MacCoreAudioDevice.isInputDevice(deviceUID);
            boolean isOutputDevice = MacCoreAudioDevice.isOutputDevice(deviceUID);
            String transportType = MacCoreAudioDevice.getTransportType(deviceUID);
            String modelIdentifier = null;
            String locatorRemainder = name;
            if (deviceUID != null) {
                modelIdentifier = CoreAudioDevice.getDeviceModelIdentifier(deviceUID);
                locatorRemainder = deviceUID;
            }
            List<CaptureDeviceInfo2> existingCdis = this.getDevices(AudioSystem.DataFlow.CAPTURE);
            CaptureDeviceInfo2 cdi = null;
            if (existingCdis != null) {
                for (CaptureDeviceInfo2 existingCdi : existingCdis) {
                    double rate;
                    String id = existingCdi.getIdentifier();
                    if (!id.equals(deviceUID) && !id.equals(name) || (rate = ((AudioFormat)existingCdi.getFormats()[0]).getSampleRate()) != MacCoreaudioSystem.getSupportedSampleRate(true, deviceUID, MacCoreaudioSystem.isEchoCancelActivated())) continue;
                    cdi = existingCdi;
                    break;
                }
            }
            if (cdi == null) {
                cdi = new CaptureDeviceInfo2(name, new MediaLocator("maccoreaudio:#" + locatorRemainder), new Format[]{new AudioFormat("LINEAR", isInputDevice ? MacCoreaudioSystem.getSupportedSampleRate(true, deviceUID, MacCoreaudioSystem.isEchoCancelActivated()) : 44100.0, sampleSizeInBits, channels, 0, 1, -1, -1.0, Format.byteArray)}, deviceUID, transportType, modelIdentifier);
            }
            boolean isDefaultInputDevice = deviceUID.equals(defaultInputdeviceUID);
            boolean isDefaultOutputDevice = deviceUID.equals(defaultOutputdeviceUID);
            if (isInputDevice) {
                LinkedList<CaptureDeviceInfo2> devices = isOutputDevice ? captureAndPlaybackDevices : captureDevices;
                if (isDefaultInputDevice || isOutputDevice && isDefaultOutputDevice) {
                    devices.add(0, cdi);
                    if (loggerIsDebugEnabled) {
                        logger.debug("Added default capture device: " + name);
                    }
                } else {
                    devices.add(cdi);
                    if (loggerIsDebugEnabled) {
                        logger.debug("Added capture device: " + name);
                    }
                }
                if (!loggerIsDebugEnabled || !isInputDevice) continue;
                if (isDefaultOutputDevice) {
                    logger.debug("Added default playback device: " + name);
                    continue;
                }
                logger.debug("Added playback device: " + name);
                continue;
            }
            if (!isOutputDevice) continue;
            if (isDefaultOutputDevice) {
                playbackDevices.add(0, cdi);
                if (!loggerIsDebugEnabled) continue;
                logger.debug("Added default playback device: " + name);
                continue;
            }
            playbackDevices.add(cdi);
            if (!loggerIsDebugEnabled) continue;
            logger.debug("Added playback device: " + name);
        }
        this.bubbleUpUsbDevices(captureDevices);
        this.bubbleUpUsbDevices(playbackDevices);
        if (!captureDevices.isEmpty() && !playbackDevices.isEmpty()) {
            this.matchDevicesByName(captureDevices, playbackDevices);
        }
        if (!captureAndPlaybackDevices.isEmpty()) {
            this.bubbleUpUsbDevices(captureAndPlaybackDevices);
            for (i = captureAndPlaybackDevices.size() - 1; i >= 0; --i) {
                CaptureDeviceInfo2 cdi = (CaptureDeviceInfo2)captureAndPlaybackDevices.get(i);
                captureDevices.add(0, cdi);
                playbackDevices.add(0, cdi);
            }
        }
        this.setCaptureDevices(captureDevices);
        this.setPlaybackDevices(playbackDevices);
        if (this.devicesChangedCallback == null) {
            this.devicesChangedCallback = new Runnable(){

                @Override
                public void run() {
                    try {
                        MacCoreaudioSystem.this.reinitialize();
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.warn("Failed to reinitialize MacCoreaudio devices", t);
                    }
                }
            };
            CoreAudioDevice.setDevicesChangedCallback(this.devicesChangedCallback);
        }
    }

    @Override
    protected String getRendererClassName() {
        return MacCoreaudioRenderer.class.getName();
    }

    private void matchDevicesByName(List<CaptureDeviceInfo2> captureDevices, List<CaptureDeviceInfo2> playbackDevices) {
        Iterator<CaptureDeviceInfo2> captureIter = captureDevices.iterator();
        Pattern pattern = Pattern.compile("array|headphones|microphone|speakers|\\p{Space}|\\(|\\)", 2);
        LinkedList<CaptureDeviceInfo2> captureDevicesWithPlayback = new LinkedList<CaptureDeviceInfo2>();
        LinkedList<CaptureDeviceInfo2> playbackDevicesWithCapture = new LinkedList<CaptureDeviceInfo2>();
        int count = 0;
        while (captureIter.hasNext()) {
            CaptureDeviceInfo2 captureDevice = captureIter.next();
            String captureName = captureDevice.getName();
            if (captureName == null || (captureName = pattern.matcher(captureName).replaceAll("")).length() == 0) continue;
            Iterator<CaptureDeviceInfo2> playbackIter = playbackDevices.iterator();
            CaptureDeviceInfo2 matchingPlaybackDevice = null;
            while (playbackIter.hasNext()) {
                CaptureDeviceInfo2 playbackDevice = playbackIter.next();
                String playbackName = playbackDevice.getName();
                if (playbackName == null || !captureName.equals(playbackName = pattern.matcher(playbackName).replaceAll(""))) continue;
                playbackIter.remove();
                matchingPlaybackDevice = playbackDevice;
                break;
            }
            if (matchingPlaybackDevice == null) continue;
            captureIter.remove();
            captureDevicesWithPlayback.add(captureDevice);
            playbackDevicesWithCapture.add(matchingPlaybackDevice);
            ++count;
        }
        for (int i = count - 1; i >= 0; --i) {
            captureDevices.add(0, (CaptureDeviceInfo2)captureDevicesWithPlayback.get(i));
            playbackDevices.add(0, (CaptureDeviceInfo2)playbackDevicesWithCapture.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinitialize() throws Exception {
        Object object = updateAvailableDeviceListSyncRoot;
        synchronized (object) {
            MacCoreaudioSystem.willUpdateAvailableDeviceList();
            MacCoreaudioSystem.didUpdateAvailableDeviceList();
        }
        MacCoreaudioSystem.invokeDeviceSystemInitialize(this);
    }

    @Override
    public String toString() {
        return "Core Audio";
    }

    public static boolean isEchoCancelActivated() {
        boolean isEchoCancel = true;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            isEchoCancel = cfg.getBoolean("net.java.sip.communicator.impl.neomedia.audioSystem.maccoreaudio.echocancel", isEchoCancel);
        }
        return isEchoCancel;
    }

    @Override
    public boolean isEchoCancel() {
        return MacCoreaudioSystem.isEchoCancelActivated();
    }

    @Override
    public void setEchoCancel(boolean echoCancel) {
        super.setEchoCancel(echoCancel);
        try {
            this.reinitialize();
        }
        catch (Exception ex) {
            logger.warn("Failed to reinitialize MacCoreaudio devices", ex);
        }
    }

    public static interface UpdateAvailableDeviceListListener
    extends EventListener {
        public void didUpdateAvailableDeviceList() throws Exception;

        public void willUpdateAvailableDeviceList() throws Exception;
    }
}

