/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.javax.sip.header.HeaderFactoryImpl;
import gov.nist.javax.sip.message.Content;
import gov.nist.javax.sip.message.ContentImpl;
import gov.nist.javax.sip.message.MultipartMimeContent;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sip.header.ContentDispositionHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartMimeContentImpl
implements MultipartMimeContent {
    private List<Content> contentList = new LinkedList<Content>();
    private ContentTypeHeader multipartMimeContentTypeHeader;
    private String boundary;
    public static String BOUNDARY = "boundary";

    public MultipartMimeContentImpl(ContentTypeHeader contentTypeHeader) {
        this.multipartMimeContentTypeHeader = contentTypeHeader;
        this.boundary = contentTypeHeader.getParameter(BOUNDARY);
    }

    @Override
    public boolean add(Content content) {
        return this.contentList.add((ContentImpl)content);
    }

    @Override
    public ContentTypeHeader getContentTypeHeader() {
        return this.multipartMimeContentTypeHeader;
    }

    @Override
    public String toString() {
        StringBuilder StringBuilder2 = new StringBuilder();
        for (Content content : this.contentList) {
            StringBuilder2.append(((Object)content).toString());
        }
        return StringBuilder2.toString();
    }

    public void createContentList(String body) throws ParseException {
        try {
            String[] fragments;
            HeaderFactoryImpl headerFactory = new HeaderFactoryImpl();
            String delimiter = this.getContentTypeHeader().getParameter(BOUNDARY);
            if (delimiter == null) {
                this.contentList = new LinkedList<Content>();
                ContentImpl content = new ContentImpl(body, delimiter);
                content.setContentTypeHeader(this.getContentTypeHeader());
                this.contentList.add(content);
                return;
            }
            for (String nextPart : fragments = body.split("--" + delimiter + "\r\n")) {
                String[] headerArray;
                if (nextPart == null) {
                    return;
                }
                StringBuilder strbuf = new StringBuilder(nextPart);
                while (strbuf.length() > 0 && (strbuf.charAt(0) == '\r' || strbuf.charAt(0) == '\n')) {
                    strbuf.deleteCharAt(0);
                }
                if (strbuf.length() == 0) continue;
                nextPart = strbuf.toString();
                int position = nextPart.indexOf("\r\n\r\n");
                int off = 4;
                if (position == -1) {
                    position = nextPart.indexOf("\n");
                    off = 2;
                }
                if (position == -1) {
                    throw new ParseException("no content type header found in " + nextPart, 0);
                }
                String rest = nextPart.substring(position + off);
                if (rest == null) {
                    throw new ParseException("No content [" + nextPart + "]", 0);
                }
                String headers = nextPart.substring(0, position);
                ContentImpl content = new ContentImpl(rest, this.boundary);
                for (String hdr : headerArray = headers.split("\r\n")) {
                    Header header = headerFactory.createHeader(hdr);
                    if (header instanceof ContentTypeHeader) {
                        content.setContentTypeHeader((ContentTypeHeader)header);
                    } else if (header instanceof ContentDispositionHeader) {
                        content.setContentDispositionHeader((ContentDispositionHeader)header);
                    } else {
                        throw new ParseException("Unexpected header type " + header.getName(), 0);
                    }
                    this.contentList.add(content);
                }
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            throw new ParseException("Invalid Multipart mime format", 0);
        }
    }

    public Content getContentByType(String contentType, String contentSubtype) {
        Content retval = null;
        if (this.contentList == null) {
            return null;
        }
        for (Content content : this.contentList) {
            if (!content.getContentTypeHeader().getContentType().equalsIgnoreCase(contentType) || !content.getContentTypeHeader().getContentSubType().equalsIgnoreCase(contentSubtype)) continue;
            retval = content;
            break;
        }
        return retval;
    }

    @Override
    public void addContent(Content content) {
        this.add(content);
    }

    @Override
    public Iterator<Content> getContents() {
        return this.contentList.iterator();
    }

    @Override
    public int getContentCount() {
        return this.contentList.size();
    }
}

