/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.caps;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.extensions.caps.CapsPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.caps.CapsProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.caps.CapsVerListener;
import net.java.sip.communicator.impl.protocol.jabber.extensions.caps.UserCapsNodeListener;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.OSUtils;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.Base64;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class EntityCapsManager {
    private static final Logger logger = Logger.getLogger(EntityCapsManager.class);
    private static final String CAPS_PROPERTY_NAME_PREFIX = "net.java.sip.communicator.impl.protocol.jabber.extensions.caps.EntityCapsManager.CAPS.";
    private static final UserCapsNodeListener[] NO_USER_CAPS_NODE_LISTENERS = new UserCapsNodeListener[0];
    private static String entityNode = OSUtils.IS_ANDROID ? "http://android.jitsi.org" : "http://jitsi.org";
    private static final Map<Caps, DiscoverInfo> caps2discoverInfo = new ConcurrentHashMap<Caps, DiscoverInfo>();
    private final Map<String, Caps> userCaps = new ConcurrentHashMap<String, Caps>();
    private final Set<CapsVerListener> capsVerListeners = new CopyOnWriteArraySet<CapsVerListener>();
    private String currentCapsVersion = null;
    private final List<UserCapsNodeListener> userCapsNodeListeners = new LinkedList<UserCapsNodeListener>();

    static {
        ProviderManager.getInstance().addExtensionProvider("c", "http://jabber.org/protocol/caps", (Object)new CapsProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDiscoverInfoByCaps(Caps caps, DiscoverInfo info) {
        EntityCapsManager.cleanupDiscoverInfo(info);
        info.setNode(caps.getNodeVer());
        Map<Caps, DiscoverInfo> map = caps2discoverInfo;
        synchronized (map) {
            String xml;
            DiscoverInfo oldInfo = caps2discoverInfo.put(caps, info);
            if (!(oldInfo != null && oldInfo.equals((Object)info) || (xml = info.getChildElementXML()) == null || xml.length() == 0)) {
                JabberActivator.getConfigurationService().setProperty(EntityCapsManager.getCapsPropertyName(caps), (Object)xml);
            }
        }
    }

    private static String getCapsPropertyName(Caps caps) {
        return CAPS_PROPERTY_NAME_PREFIX + caps.node + '#' + caps.hash + '#' + caps.ver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserCapsNode(String user, String node, String hash, String ver, String ext, boolean online) {
        if (user != null && node != null && hash != null && ver != null) {
            UserCapsNodeListener[] listeners;
            Caps caps = this.userCaps.get(user);
            if (caps != null && caps.node.equals(node) && caps.hash.equals(hash) && caps.ver.equals(ver)) {
                return;
            }
            caps = new Caps(node, hash, ver, ext);
            this.userCaps.put(user, caps);
            List<UserCapsNodeListener> list = this.userCapsNodeListeners;
            synchronized (list) {
                listeners = this.userCapsNodeListeners.toArray(NO_USER_CAPS_NODE_LISTENERS);
            }
            if (listeners.length != 0) {
                String nodeVer = caps.getNodeVer();
                UserCapsNodeListener[] userCapsNodeListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    UserCapsNodeListener listener = userCapsNodeListenerArray[n2];
                    listener.userCapsNodeAdded(user, nodeVer, online);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserCapsNodeListener(UserCapsNodeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<UserCapsNodeListener> list = this.userCapsNodeListeners;
        synchronized (list) {
            if (!this.userCapsNodeListeners.contains(listener)) {
                this.userCapsNodeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContactCapsNode(Contact contact) {
        Caps caps = null;
        String lastRemovedJid = null;
        Iterator<String> iter = this.userCaps.keySet().iterator();
        while (iter.hasNext()) {
            String jid = iter.next();
            if (!StringUtils.parseBareAddress((String)jid).equals(contact.getAddress())) continue;
            caps = this.userCaps.get(jid);
            lastRemovedJid = jid;
            iter.remove();
        }
        if (caps != null) {
            UserCapsNodeListener[] listeners;
            List<UserCapsNodeListener> list = this.userCapsNodeListeners;
            synchronized (list) {
                listeners = this.userCapsNodeListeners.toArray(NO_USER_CAPS_NODE_LISTENERS);
            }
            if (listeners.length != 0) {
                String nodeVer = caps.getNodeVer();
                UserCapsNodeListener[] userCapsNodeListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    UserCapsNodeListener listener = userCapsNodeListenerArray[n2];
                    listener.userCapsNodeRemoved(lastRemovedJid, nodeVer, false);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserCapsNode(String user) {
        Caps caps = this.userCaps.remove(user);
        if (caps != null) {
            UserCapsNodeListener[] listeners;
            List<UserCapsNodeListener> list = this.userCapsNodeListeners;
            synchronized (list) {
                listeners = this.userCapsNodeListeners.toArray(NO_USER_CAPS_NODE_LISTENERS);
            }
            if (listeners.length != 0) {
                String nodeVer = caps.getNodeVer();
                UserCapsNodeListener[] userCapsNodeListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    UserCapsNodeListener listener = userCapsNodeListenerArray[n2];
                    listener.userCapsNodeRemoved(user, nodeVer, false);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserCapsNodeListener(UserCapsNodeListener listener) {
        if (listener != null) {
            List<UserCapsNodeListener> list = this.userCapsNodeListeners;
            synchronized (list) {
                this.userCapsNodeListeners.remove(listener);
            }
        }
    }

    public Caps getCapsByUser(String user) {
        return this.userCaps.get(user);
    }

    public DiscoverInfo getDiscoverInfoByUser(String user) {
        Caps caps = this.userCaps.get(user);
        return caps == null ? null : EntityCapsManager.getDiscoverInfoByCaps(caps);
    }

    public String getCapsVersion() {
        return this.currentCapsVersion;
    }

    public String getNode() {
        return entityNode;
    }

    public void setNode(String node) {
        entityNode = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiscoverInfo getDiscoverInfoByCaps(Caps caps) {
        Map<Caps, DiscoverInfo> map = caps2discoverInfo;
        synchronized (map) {
            IQProvider discoverInfoProvider;
            String capsPropertyName;
            ConfigurationService configurationService;
            String xml;
            DiscoverInfo discoverInfo = caps2discoverInfo.get(caps);
            if (discoverInfo == null && (xml = (configurationService = JabberActivator.getConfigurationService()).getString(capsPropertyName = EntityCapsManager.getCapsPropertyName(caps))) != null && xml.length() != 0 && (discoverInfoProvider = (IQProvider)ProviderManager.getInstance().getIQProvider("query", "http://jabber.org/protocol/disco#info")) != null) {
                MXParser parser = new MXParser();
                try {
                    parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                    parser.setInput((Reader)new StringReader(xml));
                    parser.next();
                }
                catch (XmlPullParserException xppex) {
                    parser = null;
                }
                catch (IOException ioex) {
                    parser = null;
                }
                if (parser != null) {
                    try {
                        discoverInfo = (DiscoverInfo)discoverInfoProvider.parseIQ((XmlPullParser)parser);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (discoverInfo != null) {
                        if (caps.isValid(discoverInfo)) {
                            caps2discoverInfo.put(caps, discoverInfo);
                        } else {
                            logger.error((Object)("Invalid DiscoverInfo for " + caps.getNodeVer() + ": " + discoverInfo));
                            configurationService.removeProperty(capsPropertyName);
                        }
                    }
                }
            }
            return discoverInfo;
        }
    }

    private static void cleanupDiscoverInfo(DiscoverInfo info) {
        info.setFrom(null);
        info.setTo(null);
        info.setPacketID(null);
    }

    private static Iterator<DiscoverInfo.Feature> getDiscoverInfoFeatures(DiscoverInfo discoverInfo) {
        Method getFeaturesMethod;
        try {
            getFeaturesMethod = DiscoverInfo.class.getDeclaredMethod("getFeatures", new Class[0]);
        }
        catch (NoSuchMethodException nsmex) {
            throw new UndeclaredThrowableException(nsmex);
        }
        getFeaturesMethod.setAccessible(true);
        try {
            return (Iterator)getFeaturesMethod.invoke((Object)discoverInfo, new Object[0]);
        }
        catch (IllegalAccessException iaex) {
            throw new UndeclaredThrowableException(iaex);
        }
        catch (InvocationTargetException itex) {
            throw new UndeclaredThrowableException(itex);
        }
    }

    public void addPacketListener(XMPPConnection connection) {
        AndFilter filter = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Presence.class), new PacketExtensionFilter("c", "http://jabber.org/protocol/caps")});
        connection.addPacketListener((PacketListener)new CapsPacketListener(), (PacketFilter)filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCapsVerListener(CapsVerListener listener) {
        Set<CapsVerListener> set = this.capsVerListeners;
        synchronized (set) {
            if (this.capsVerListeners.contains(listener)) {
                return;
            }
            this.capsVerListeners.add(listener);
            if (this.currentCapsVersion != null) {
                listener.capsVerUpdated(this.currentCapsVersion);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCapsVerListener(CapsVerListener listener) {
        Set<CapsVerListener> set = this.capsVerListeners;
        synchronized (set) {
            this.capsVerListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCapsVerChanged() {
        ArrayList<CapsVerListener> listenersCopy = null;
        Set<CapsVerListener> set = this.capsVerListeners;
        synchronized (set) {
            listenersCopy = new ArrayList<CapsVerListener>(this.capsVerListeners);
        }
        for (CapsVerListener listener : listenersCopy) {
            listener.capsVerUpdated(this.currentCapsVersion);
        }
    }

    private static String capsToHash(String hashAlgorithm, String capsString) {
        try {
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm);
            byte[] digest = md.digest(capsString.getBytes());
            return Base64.encodeBytes((byte[])digest);
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error((Object)("Unsupported XEP-0115: Entity Capabilities hash algorithm: " + hashAlgorithm));
            return null;
        }
    }

    private static void formFieldValuesToCaps(Iterator<String> ffValuesIter, StringBuilder capsBldr) {
        TreeSet<String> fvs = new TreeSet<String>();
        while (ffValuesIter.hasNext()) {
            fvs.add(ffValuesIter.next());
        }
        for (String fv : fvs) {
            capsBldr.append(fv).append('<');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String calculateEntityCapsString(DiscoverInfo discoverInfo) {
        StringBuilder bldr = new StringBuilder();
        Iterator identities = discoverInfo.getIdentities();
        TreeSet<DiscoverInfo.Identity> is = new TreeSet<DiscoverInfo.Identity>(new Comparator<DiscoverInfo.Identity>(){

            @Override
            public int compare(DiscoverInfo.Identity i1, DiscoverInfo.Identity i2) {
                int category = i1.getCategory().compareTo(i2.getCategory());
                if (category != 0) {
                    return category;
                }
                int type = i1.getType().compareTo(i2.getType());
                if (type != 0) {
                    return type;
                }
                return type;
            }
        });
        if (identities != null) {
            while (identities.hasNext()) {
                is.add((DiscoverInfo.Identity)identities.next());
            }
        }
        for (DiscoverInfo.Identity i : is) {
            bldr.append(i.getCategory()).append('/').append(i.getType()).append("//").append(i.getName()).append('<');
        }
        Iterator<DiscoverInfo.Feature> features = EntityCapsManager.getDiscoverInfoFeatures(discoverInfo);
        TreeSet<String> fs = new TreeSet<String>();
        if (features != null) {
            while (features.hasNext()) {
                fs.add(features.next().getVar());
            }
        }
        for (String f : fs) {
            bldr.append(f).append('<');
        }
        DataForm extendedInfo = (DataForm)discoverInfo.getExtension("x", "jabber:x:data");
        if (extendedInfo != null) {
            DataForm dataForm = extendedInfo;
            synchronized (dataForm) {
                TreeSet<FormField> fs2 = new TreeSet<FormField>(new Comparator<FormField>(){

                    @Override
                    public int compare(FormField f1, FormField f2) {
                        return f1.getVariable().compareTo(f2.getVariable());
                    }
                });
                FormField formType = null;
                Iterator fieldsIter = extendedInfo.getFields();
                while (fieldsIter.hasNext()) {
                    FormField f = (FormField)fieldsIter.next();
                    if (!f.getVariable().equals("FORM_TYPE")) {
                        fs2.add(f);
                        continue;
                    }
                    formType = f;
                }
                if (formType != null) {
                    EntityCapsManager.formFieldValuesToCaps(formType.getValues(), bldr);
                }
                for (FormField f : fs2) {
                    bldr.append(f.getVariable()).append('<');
                    EntityCapsManager.formFieldValuesToCaps(f.getValues(), bldr);
                }
            }
        }
        return bldr.toString();
    }

    public void calculateEntityCapsVersion(DiscoverInfo discoverInfo) {
        this.setCurrentCapsVersion(discoverInfo, EntityCapsManager.capsToHash("sha-1", EntityCapsManager.calculateEntityCapsString(discoverInfo)));
    }

    public void setCurrentCapsVersion(DiscoverInfo discoverInfo, String capsVersion) {
        Caps caps = new Caps(this.getNode(), "sha-1", capsVersion, null);
        discoverInfo.setNode(caps.getNodeVer());
        if (!caps.isValid(discoverInfo)) {
            throw new IllegalArgumentException("The specified discoverInfo must be valid with respect to the specified capsVersion");
        }
        this.currentCapsVersion = capsVersion;
        EntityCapsManager.addDiscoverInfoByCaps(caps, discoverInfo);
        this.fireCapsVerChanged();
    }

    public static class Caps {
        public final String hash;
        public final String node;
        public String ext;
        private final String nodeVer;
        public final String ver;

        public Caps(String node, String hash, String ver, String ext) {
            if (node == null) {
                throw new NullPointerException("node");
            }
            if (hash == null) {
                throw new NullPointerException("hash");
            }
            if (ver == null) {
                throw new NullPointerException("ver");
            }
            this.node = node;
            this.hash = hash;
            this.ver = ver;
            this.ext = ext;
            this.nodeVer = String.valueOf(this.node) + '#' + this.ver;
        }

        public final String getNodeVer() {
            return this.nodeVer;
        }

        public boolean isValid(DiscoverInfo discoverInfo) {
            if (discoverInfo != null) {
                if (discoverInfo.getNode() == null) {
                    discoverInfo.setNode(this.getNodeVer());
                }
                if (this.getNodeVer().equals(discoverInfo.getNode()) && !this.hash.equals("") && this.ver.equals(EntityCapsManager.capsToHash(this.hash, EntityCapsManager.calculateEntityCapsString(discoverInfo)))) {
                    return true;
                }
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Caps caps = (Caps)o;
            if (!this.hash.equals(caps.hash)) {
                return false;
            }
            if (!this.node.equals(caps.node)) {
                return false;
            }
            return this.ver.equals(caps.ver);
        }

        public int hashCode() {
            int result = this.hash.hashCode();
            result = 31 * result + this.node.hashCode();
            result = 31 * result + this.ver.hashCode();
            return result;
        }
    }

    private class CapsPacketListener
    implements PacketListener {
        private CapsPacketListener() {
        }

        public void processPacket(Packet packet) {
            CapsPacketExtension ext = (CapsPacketExtension)packet.getExtension("c", "http://jabber.org/protocol/caps");
            String hash = ext.getHash();
            if (hash == null) {
                hash = "";
            }
            if (hash != null) {
                boolean online;
                boolean bl = online = packet instanceof Presence && ((Presence)packet).isAvailable();
                if (online) {
                    EntityCapsManager.this.addUserCapsNode(packet.getFrom(), ext.getNode(), hash, ext.getVersion(), ext.getExtensions(), online);
                } else {
                    EntityCapsManager.this.removeUserCapsNode(packet.getFrom());
                }
            }
        }
    }
}

