/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.message;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StunException;
import org.ice4j.attribute.Attribute;
import org.ice4j.attribute.AttributeDecoder;
import org.ice4j.attribute.AttributeFactory;
import org.ice4j.attribute.ContentDependentAttribute;
import org.ice4j.attribute.FingerprintAttribute;
import org.ice4j.message.Indication;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.stack.StunStack;
import org.ice4j.stack.TransactionID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Message {
    private static final Logger logger = Logger.getLogger(Message.class.getName());
    public static final char STUN_REQUEST = '\u0000';
    public static final char STUN_INDICATION = '\u0010';
    public static final char STUN_SUCCESS_RESP = '\u0100';
    public static final char STUN_ERROR_RESP = '\u0110';
    public static final char STUN_METHOD_BINDING = '\u0001';
    public static final char BINDING_REQUEST = '\u0001';
    public static final char BINDING_SUCCESS_RESPONSE = '\u0101';
    public static final char BINDING_ERROR_RESPONSE = '\u0111';
    public static final char BINDING_INDICATION = '\u0011';
    public static final char SHARED_SECRET_REQUEST = '\u0002';
    public static final char SHARED_SECRET_RESPONSE = '\u0102';
    public static final char SHARED_SECRET_ERROR_RESPONSE = '\u0112';
    public static final char TURN_METHOD_ALLOCATE = '\u0003';
    public static final char TURN_METHOD_REFRESH = '\u0004';
    public static final char TURN_METHOD_SEND = '\u0006';
    public static final char TURN_METHOD_DATA = '\u0007';
    public static final char TURN_METHOD_CREATEPERMISSION = '\b';
    public static final char TURN_METHOD_CHANNELBIND = '\t';
    public static final char ALLOCATE_REQUEST = '\u0003';
    public static final char ALLOCATE_RESPONSE = '\u0103';
    public static final char ALLOCATE_ERROR_RESPONSE = '\u0113';
    public static final char REFRESH_REQUEST = '\u0004';
    public static final char REFRESH_RESPONSE = '\u0104';
    public static final char REFRESH_ERROR_RESPONSE = '\u0114';
    public static final char CHANNELBIND_REQUEST = '\t';
    public static final char CHANNELBIND_RESPONSE = '\u0109';
    public static final char CHANNELBIND_ERROR_RESPONSE = '\u0119';
    public static final char CREATEPERMISSION_REQUEST = '\b';
    public static final char CREATEPERMISSION_RESPONSE = '\u0108';
    public static final char CREATEPERMISSION_ERROR_RESPONSE = '\u0118';
    public static final char SEND_INDICATION = '\u0016';
    public static final char DATA_INDICATION = '\u0017';
    public static final char SEND_REQUEST = '\u0004';
    public static final char OLD_DATA_INDICATION = '\u0115';
    public static final byte HEADER_LENGTH = 20;
    protected char messageType = '\u0000';
    protected byte[] transactionID = null;
    public static final byte[] MAGIC_COOKIE = new byte[]{33, 18, -92, 66};
    public static final byte TRANSACTION_ID_LENGTH = 12;
    public static final byte RFC3489_TRANSACTION_ID_LENGTH = 16;
    protected LinkedHashMap<Character, Attribute> attributes = new LinkedHashMap();
    private static boolean rfc3489CompatibilityMode = false;
    public static final byte N_A = 0;
    public static final byte C = 1;
    public static final byte O = 2;
    public static final byte M = 3;
    protected static final byte BINDING_REQUEST_PRESENTITY_INDEX = 0;
    protected static final byte BINDING_RESPONSE_PRESENTITY_INDEX = 1;
    protected static final byte BINDING_ERROR_RESPONSE_PRESENTITY_INDEX = 2;
    protected static final byte SHARED_SECRET_REQUEST_PRESENTITY_INDEX = 3;
    protected static final byte SHARED_SECRET_RESPONSE_PRESENTITY_INDEX = 4;
    protected static final byte SHARED_SECRET_ERROR_RESPONSE_PRESENTITY_INDEX = 5;
    protected static final byte ALLOCATE_REQUEST_PRESENTITY_INDEX = 6;
    protected static final byte ALLOCATE_RESPONSE_PRESENTITY_INDEX = 7;
    protected static final byte REFRESH_REQUEST_PRESENTITY_INDEX = 8;
    protected static final byte REFRESH_RESPONSE_PRESENTITY_INDEX = 9;
    protected static final byte CHANNELBIND_REQUEST_PRESENTITY_INDEX = 10;
    protected static final byte CHANNELBIND_RESPONSE_PRESENTITY_INDEX = 11;
    protected static final byte SEND_INDICATION_PRESENTITY_INDEX = 12;
    protected static final byte DATA_INDICATION_PRESENTITY_INDEX = 13;
    protected static final byte MAPPED_ADDRESS_PRESENTITY_INDEX = 0;
    protected static final byte RESPONSE_ADDRESS_PRESENTITY_INDEX = 1;
    protected static final byte CHANGE_REQUEST_PRESENTITY_INDEX = 2;
    protected static final byte SOURCE_ADDRESS_PRESENTITY_INDEX = 3;
    protected static final byte CHANGED_ADDRESS_PRESENTITY_INDEX = 4;
    protected static final byte USERNAME_PRESENTITY_INDEX = 5;
    protected static final byte PASSWORD_PRESENTITY_INDEX = 6;
    protected static final byte MESSAGE_INTEGRITY_PRESENTITY_INDEX = 7;
    protected static final byte ERROR_CODE_PRESENTITY_INDEX = 8;
    protected static final byte UNKNOWN_ATTRIBUTES_PRESENTITY_INDEX = 9;
    protected static final byte REFLECTED_FROM_PRESENTITY_INDEX = 10;
    protected static final byte XOR_MAPPED_ADDRESS_PRESENTITY_INDEX = 11;
    protected static final byte XOR_ONLY_PRESENTITY_INDEX = 12;
    protected static final byte SOFTWARE_PRESENTITY_INDEX = 13;
    protected static final byte UNKNOWN_OPTIONAL_ATTRIBUTES_PRESENTITY_INDEX = 14;
    protected static final byte ALTERNATE_SERVER_PRESENTITY_INDEX = 15;
    protected static final byte REALM_PRESENTITY_INDEX = 16;
    protected static final byte NONCE_PRESENTITY_INDEX = 17;
    protected static final byte FINGERPRINT_PRESENTITY_INDEX = 18;
    protected static final byte CHANNEL_NUMBER_PRESENTITY_INDEX = 19;
    protected static final byte LIFETIME_PRESENTITY_INDEX = 20;
    protected static final byte XOR_PEER_ADDRESS_PRESENTITY_INDEX = 21;
    protected static final byte DATA_PRESENTITY_INDEX = 22;
    protected static final byte XOR_RELAYED_ADDRESS_PRESENTITY_INDEX = 23;
    protected static final byte EVEN_PORT_PRESENTITY_INDEX = 24;
    protected static final byte REQUESTED_TRANSPORT_PRESENTITY_INDEX = 25;
    protected static final byte DONT_FRAGMENT_PRESENTITY_INDEX = 26;
    protected static final byte RESERVATION_TOKEN_PRESENTITY_INDEX = 27;
    protected static final byte PRIORITY_PRESENTITY_INDEX = 28;
    protected static final byte ICE_CONTROLLING_PRESENTITY_INDEX = 29;
    protected static final byte ICE_CONTROLLED_PRESENTITY_INDEX = 30;
    protected static final byte USE_CANDIDATE_PRESENTITY_INDEX = 31;
    protected static final byte DESTINATION_ADDRESS_PRESENTITY_INDEX = 29;
    protected static final byte[][] attributePresentities = new byte[][]{{0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3}, {0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 3, 0, 2, 0, 2, 0, 2, 0, 0, 0}, {0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 2, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 0, 0}, {0, 0, 3, 0, 0, 3, 0, 3, 0, 3, 0, 3, 0, 0}, {0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0}, {2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 3, 0, 2, 2, 2, 2, 2, 2, 0, 0}, {2, 0, 0, 0, 3, 0, 2, 2, 2, 2, 2, 2, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 3}, {0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, 3}, {0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 0}, {0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 3, 0}};

    protected Message() {
    }

    public char getDataLength() {
        char length = '\u0000';
        List<Attribute> attrs = this.getAttributes();
        for (Attribute att : attrs) {
            int attLen = att.getDataLength() + 4;
            attLen += (4 - attLen % 4) % 4;
            length = (char)(length + attLen);
        }
        return length;
    }

    public char getDataLengthWithoutPadding() {
        char length = '\u0000';
        List<Attribute> attrs = this.getAttributes();
        for (Attribute att : attrs) {
            int attLen = att.getDataLength() + 4;
            length = (char)(length + attLen);
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttribute(Attribute attribute) throws IllegalArgumentException {
        if (this.getAttributePresentity(attribute.getAttributeType()) == 0) {
            throw new IllegalArgumentException("The attribute " + attribute.getName() + " is not allowed in a " + this.getName());
        }
        LinkedHashMap<Character, Attribute> linkedHashMap = this.attributes;
        synchronized (linkedHashMap) {
            this.attributes.put(Character.valueOf(attribute.getAttributeType()), attribute);
        }
    }

    public boolean containsAttribute(char attributeType) {
        return this.attributes.containsKey(Character.valueOf(attributeType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute getAttribute(char attributeType) {
        LinkedHashMap<Character, Attribute> linkedHashMap = this.attributes;
        synchronized (linkedHashMap) {
            return this.attributes.get(Character.valueOf(attributeType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attribute> getAttributes() {
        LinkedHashMap<Character, Attribute> linkedHashMap = this.attributes;
        synchronized (linkedHashMap) {
            return new LinkedList<Attribute>(this.attributes.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute removeAttribute(char attributeType) {
        LinkedHashMap<Character, Attribute> linkedHashMap = this.attributes;
        synchronized (linkedHashMap) {
            return (Attribute)this.attributes.remove(Character.valueOf(attributeType));
        }
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    protected void setMessageType(char messageType) {
        this.messageType = messageType;
    }

    public char getMessageType() {
        return this.messageType;
    }

    public void setTransactionID(byte[] tranID) throws StunException {
        if (tranID == null || tranID.length != 12 && tranID.length != 16) {
            throw new StunException(2, "Invalid transaction id length");
        }
        int tranIDLength = tranID.length;
        this.transactionID = new byte[tranIDLength];
        System.arraycopy(tranID, 0, this.transactionID, 0, tranIDLength);
    }

    public byte[] getTransactionID() {
        return this.transactionID;
    }

    protected byte getAttributePresentity(char attributeType) {
        if (!rfc3489CompatibilityMode) {
            return 2;
        }
        int msgIndex = -1;
        int attributeIndex = -1;
        switch (this.messageType) {
            case '\u0001': {
                msgIndex = 0;
                break;
            }
            case '\u0101': {
                msgIndex = 1;
                break;
            }
            case '\u0111': {
                msgIndex = 2;
                break;
            }
            case '\u0002': {
                msgIndex = 3;
                break;
            }
            case '\u0102': {
                msgIndex = 4;
                break;
            }
            case '\u0112': {
                msgIndex = 5;
                break;
            }
            case '\u0003': {
                msgIndex = 6;
                break;
            }
            case '\u0004': {
                msgIndex = 8;
                break;
            }
            case '\t': {
                msgIndex = 10;
                break;
            }
            case '\u0016': {
                msgIndex = 12;
                break;
            }
            case '\u0017': {
                msgIndex = 13;
                break;
            }
            default: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Attribute presentity not defined for STUN message type: " + this.messageType + ". Will assume optional.");
                }
                return 2;
            }
        }
        switch (attributeType) {
            case '\u0001': {
                attributeIndex = 0;
                break;
            }
            case '\u0002': {
                attributeIndex = 1;
                break;
            }
            case '\u0003': {
                attributeIndex = 2;
                break;
            }
            case '\u0004': {
                attributeIndex = 3;
                break;
            }
            case '\u0005': {
                attributeIndex = 4;
                break;
            }
            case '\u0006': {
                attributeIndex = 5;
                break;
            }
            case '\u0007': {
                attributeIndex = 6;
                break;
            }
            case '\b': {
                attributeIndex = 7;
                break;
            }
            case '\t': {
                attributeIndex = 8;
                break;
            }
            case '\n': {
                attributeIndex = 9;
                break;
            }
            case '\u000b': {
                attributeIndex = 10;
                break;
            }
            case ' ': {
                attributeIndex = 11;
                break;
            }
            case '!': {
                attributeIndex = 12;
                break;
            }
            case '\u8022': {
                attributeIndex = 13;
                break;
            }
            case '\u8023': {
                attributeIndex = 15;
                break;
            }
            case '\u0014': {
                attributeIndex = 16;
                break;
            }
            case '\u0015': {
                attributeIndex = 17;
                break;
            }
            case '\u8028': {
                attributeIndex = 18;
                break;
            }
            case '\f': {
                attributeIndex = 19;
                break;
            }
            case '\r': {
                attributeIndex = 20;
                break;
            }
            case '\u0012': {
                attributeIndex = 21;
                break;
            }
            case '\u0013': {
                attributeIndex = 22;
                break;
            }
            case '\u0016': {
                attributeIndex = 23;
                break;
            }
            case '\u0018': {
                attributeIndex = 24;
                break;
            }
            case '\u0019': {
                attributeIndex = 25;
                break;
            }
            case '\u001a': {
                attributeIndex = 26;
                break;
            }
            case '\"': {
                attributeIndex = 27;
                break;
            }
            default: {
                attributeIndex = 14;
            }
        }
        return attributePresentities[attributeIndex][msgIndex];
    }

    public String getName() {
        switch (this.messageType) {
            case '\u0003': {
                return "ALLOCATE-REQUEST";
            }
            case '\u0103': {
                return "ALLOCATE-RESPONSE";
            }
            case '\u0113': {
                return "ALLOCATE-ERROR-RESPONSE";
            }
            case '\u0001': {
                return "BINDING-REQUEST";
            }
            case '\u0101': {
                return "BINDING-RESPONSE";
            }
            case '\u0111': {
                return "BINDING-ERROR-RESPONSE";
            }
            case '\b': {
                return "CREATE-PERMISSION-REQUEST";
            }
            case '\u0108': {
                return "CREATE-PERMISSION-RESPONSE";
            }
            case '\u0118': {
                return "CREATE-PERMISSION-ERROR-RESPONSE";
            }
            case '\u0017': {
                return "DATA-INDICATION";
            }
            case '\u0004': {
                return "REFRESH-REQUEST";
            }
            case '\u0104': {
                return "REFRESH-RESPONSE";
            }
            case '\u0114': {
                return "REFRESH-ERROR-RESPONSE";
            }
            case '\u0016': {
                return "SEND-INDICATION";
            }
            case '\u0002': {
                return "SHARED-SECRET-REQUEST";
            }
            case '\u0102': {
                return "SHARED-SECRET-RESPONSE";
            }
            case '\u0112': {
                return "SHARED-SECRET-ERROR-RESPONSE";
            }
        }
        return "UNKNOWN-MESSAGE";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Message) || obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Message msg = (Message)obj;
        if (msg.getMessageType() != this.getMessageType()) {
            return false;
        }
        if (msg.getDataLength() != this.getDataLength()) {
            return false;
        }
        for (Attribute localAtt : this.attributes.values()) {
            if (localAtt.equals(msg.getAttribute(localAtt.getAttributeType()))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encode(StunStack stunStack) throws IllegalStateException {
        this.prepareForEncoding();
        this.validateAttributePresentity();
        char dataLength = this.getDataLength();
        byte[] binMsg = new byte[20 + dataLength];
        int offset = 0;
        binMsg[offset++] = (byte)(this.getMessageType() >> 8);
        binMsg[offset++] = (byte)(this.getMessageType() & 0xFF);
        int messageLengthOffset = offset;
        offset += 2;
        byte[] tranID = this.getTransactionID();
        if (tranID.length == 12) {
            System.arraycopy(MAGIC_COOKIE, 0, binMsg, offset, 4);
            System.arraycopy(tranID, 0, binMsg, offset += 4, 12);
            offset += 12;
        } else {
            System.arraycopy(tranID, 0, binMsg, offset, 16);
            offset += 16;
        }
        Vector<Map.Entry<Character, Attribute>> v = new Vector<Map.Entry<Character, Attribute>>();
        Iterator iter = null;
        int dataLengthForContentDependentAttribute = 0;
        LinkedHashMap<Character, Attribute> linkedHashMap = this.attributes;
        synchronized (linkedHashMap) {
            v.addAll(this.attributes.entrySet());
        }
        iter = v.iterator();
        while (iter.hasNext()) {
            byte[] binAtt;
            Attribute attribute = (Attribute)((Map.Entry)iter.next()).getValue();
            int attributeLength = attribute.getDataLength() + 4;
            attributeLength += (4 - attributeLength % 4) % 4;
            dataLengthForContentDependentAttribute = (char)(dataLengthForContentDependentAttribute + attributeLength);
            if (attribute instanceof ContentDependentAttribute) {
                binMsg[messageLengthOffset] = (byte)(dataLengthForContentDependentAttribute >> 8);
                binMsg[messageLengthOffset + 1] = (byte)(dataLengthForContentDependentAttribute & 0xFF);
                binAtt = ((ContentDependentAttribute)((Object)attribute)).encode(stunStack, binMsg, 0, offset);
            } else {
                binAtt = attribute.encode();
            }
            System.arraycopy(binAtt, 0, binMsg, offset, binAtt.length);
            offset += attributeLength;
        }
        binMsg[messageLengthOffset] = (byte)(dataLength >> 8);
        binMsg[messageLengthOffset + 1] = (byte)(dataLength & 0xFF);
        return binMsg;
    }

    private void prepareForEncoding() {
        Attribute msgIntAttr = this.removeAttribute('\b');
        Attribute fingerprint = this.removeAttribute('\u8028');
        String software = System.getProperty("org.ice4j.SOFTWARE");
        if (this.getAttribute('\u8022') == null && software != null && software.length() > 0) {
            this.addAttribute(AttributeFactory.createSoftwareAttribute(software.getBytes()));
        }
        if (msgIntAttr != null) {
            this.addAttribute(msgIntAttr);
        }
        if (fingerprint == null && Boolean.getBoolean("org.ice4j.ALWAYS_SIGN")) {
            fingerprint = AttributeFactory.createFingerprintAttribute();
        }
        if (fingerprint != null) {
            this.addAttribute(fingerprint);
        }
    }

    public static Message decode(byte[] binMessage, char offset, char arrayLen) throws StunException {
        char originalOffset = offset;
        arrayLen = (char)Math.min(binMessage.length, arrayLen);
        if (binMessage == null || arrayLen - offset < 20) {
            throw new StunException(2, "The given binary array is not a valid StunMessage");
        }
        char c = offset;
        char c2 = offset = (char)(offset + '\u0001');
        offset = (char)(offset + '\u0001');
        char messageType = (char)(binMessage[c] << 8 | binMessage[c2] & 0xFF);
        Message message = Message.isResponseType(messageType) && messageType != '\u0115' ? new Response() : (Message.isRequestType(messageType) ? new Request() : new Indication());
        message.setMessageType(messageType);
        char c3 = offset;
        char c4 = offset = (char)(offset + '\u0001');
        offset = (char)(offset + '\u0001');
        char length = (char)(binMessage[c3] << 8 | binMessage[c4] & 0xFF);
        byte[] cookie = new byte[4];
        System.arraycopy(binMessage, offset, cookie, 0, 4);
        offset = (char)(offset + 4);
        boolean rfc3489Compat = false;
        if (!Arrays.equals(MAGIC_COOKIE, cookie)) {
            rfc3489Compat = true;
        }
        if (arrayLen - offset - 12 < length) {
            throw new StunException(2, "The given binary array does not seem to contain a whole StunMessage: given " + arrayLen + " bytes of " + message.getName() + " but expecting " + (offset + 12 + length));
        }
        byte[] tranID = new byte[12];
        System.arraycopy(binMessage, offset, tranID, 0, 12);
        try {
            if (rfc3489Compat) {
                byte[] rfc3489TranID = new byte[16];
                System.arraycopy(cookie, 0, rfc3489TranID, 0, 4);
                System.arraycopy(tranID, 0, rfc3489TranID, 4, 12);
                message.setTransactionID(rfc3489TranID);
            } else {
                message.setTransactionID(tranID);
            }
        }
        catch (StunException exc) {
            throw new StunException(2, "The given binary array does not seem to contain a whole StunMessage", exc);
        }
        offset = (char)(offset + 12);
        while (offset - 20 < length) {
            Attribute att = AttributeDecoder.decode(binMessage, offset, (char)(length - offset));
            Message.performAttributeSpecificActions(att, binMessage, originalOffset, offset);
            message.addAttribute(att);
            offset = (char)(offset + (att.getDataLength() + 4));
            if (att.getDataLength() % 4 <= 0) continue;
            offset = (char)(offset + (4 - att.getDataLength() % 4));
        }
        return message;
    }

    private static void performAttributeSpecificActions(Attribute attribute, byte[] binMessage, int offset, int msgLen) throws StunException {
        if (attribute instanceof FingerprintAttribute && !Message.validateFingerprint((FingerprintAttribute)attribute, binMessage, offset, msgLen)) {
            throw new StunException("Wrong value in FINGERPRINT");
        }
    }

    private static boolean validateFingerprint(FingerprintAttribute fingerprint, byte[] message, int offset, int length) {
        byte[] realCrcBytes;
        byte[] incomingCrcBytes = fingerprint.getChecksum();
        if (!Arrays.equals(incomingCrcBytes, realCrcBytes = FingerprintAttribute.calculateXorCRC32(message, offset, length))) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("An incoming message arrived with a wrong FINGERPRINT attribute value. CRC Was:" + Arrays.toString(incomingCrcBytes) + ". Should have been:" + Arrays.toString(realCrcBytes) + ". Will ignore.");
            }
            return false;
        }
        return true;
    }

    protected void validateAttributePresentity() throws IllegalStateException {
        if (!rfc3489CompatibilityMode) {
            return;
        }
        for (char i = '\u0001'; i < '\u000b'; i = (char)(i + '\u0001')) {
            if (this.getAttributePresentity(i) != 3 || this.getAttribute(i) != null) continue;
            throw new IllegalStateException("A mandatory attribute (type=" + i + ") is missing!");
        }
    }

    public static boolean isErrorResponseType(char type) {
        return (type & 0x110) == 272;
    }

    public static boolean isSuccessResponseType(char type) {
        return (type & 0x110) == 256;
    }

    public static boolean isResponseType(char type) {
        return Message.isSuccessResponseType(type) || Message.isErrorResponseType(type);
    }

    public static boolean isIndicationType(char type) {
        return (type & 0x110) == 16;
    }

    public static boolean isRequestType(char type) {
        return (type & 0x110) == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName());
        stringBuilder.append("(0x");
        stringBuilder.append(Integer.toHexString(this.getMessageType()));
        stringBuilder.append(")[attrib.count=");
        stringBuilder.append(this.getAttributeCount());
        stringBuilder.append(" len=");
        stringBuilder.append((int)this.getDataLength());
        byte[] transactionID = this.getTransactionID();
        if (transactionID != null) {
            stringBuilder.append(" tranID=");
            stringBuilder.append(TransactionID.toString(transactionID));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

