/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.ArrayList;
import java.util.List;
import net.java.sip.communicator.service.protocol.AccountManager;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.SingleCallInProgressPolicy;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ProtocolProviderActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(ProtocolProviderActivator.class);
    private ServiceRegistration accountManagerServiceRegistration;
    private static AccountManager accountManager;
    private static BundleContext bundleContext;
    private static ConfigurationService configurationService;
    private static ResourceManagementService resourceService;
    private SingleCallInProgressPolicy singleCallInProgressPolicy;

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            configurationService = (ConfigurationService)bundleContext.getService(bundleContext.getServiceReference(ConfigurationService.class.getName()));
        }
        return configurationService;
    }

    public static ResourceManagementService getResourceService() {
        if (resourceService == null) {
            resourceService = (ResourceManagementService)bundleContext.getService(bundleContext.getServiceReference(ResourceManagementService.class.getName()));
        }
        return resourceService;
    }

    public static ProtocolProviderFactory getProtocolProviderFactory(String protocolName) {
        ProtocolProviderFactory protocolProviderFactory;
        block3: {
            String osgiFilter = "(PROTOCOL_NAME=" + protocolName + ")";
            protocolProviderFactory = null;
            try {
                ServiceReference[] serRefs = bundleContext.getServiceReferences(ProtocolProviderFactory.class.getName(), osgiFilter);
                if (serRefs != null && serRefs.length != 0) {
                    protocolProviderFactory = (ProtocolProviderFactory)bundleContext.getService(serRefs[0]);
                }
            }
            catch (InvalidSyntaxException ex) {
                if (!logger.isInfoEnabled()) break block3;
                logger.info((Object)("ProtocolProviderActivator : " + (Object)((Object)ex)));
            }
        }
        return protocolProviderFactory;
    }

    public void start(BundleContext bundleContext) {
        ProtocolProviderActivator.bundleContext = bundleContext;
        accountManager = new AccountManager(bundleContext);
        this.accountManagerServiceRegistration = bundleContext.registerService(AccountManager.class.getName(), (Object)accountManager, null);
        this.singleCallInProgressPolicy = new SingleCallInProgressPolicy(bundleContext);
    }

    public void stop(BundleContext bundleContext) {
        if (this.accountManagerServiceRegistration != null) {
            this.accountManagerServiceRegistration.unregister();
            this.accountManagerServiceRegistration = null;
            accountManager = null;
        }
        if (this.singleCallInProgressPolicy != null) {
            this.singleCallInProgressPolicy.dispose();
            this.singleCallInProgressPolicy = null;
        }
        if (bundleContext.equals(ProtocolProviderActivator.bundleContext)) {
            ProtocolProviderActivator.bundleContext = null;
        }
        configurationService = null;
        resourceService = null;
    }

    public static List<ProtocolProviderService> getProtocolProviders() {
        ServiceReference[] serRefs = null;
        try {
            serRefs = bundleContext.getServiceReferences(ProtocolProviderService.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            logger.error((Object)("ProtocolProviderActivator : " + (Object)((Object)e)));
        }
        ArrayList<ProtocolProviderService> providersList = new ArrayList<ProtocolProviderService>();
        if (serRefs != null) {
            ServiceReference[] serviceReferenceArray = serRefs;
            int n = serRefs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference serRef = serviceReferenceArray[n2];
                ProtocolProviderService pp = (ProtocolProviderService)bundleContext.getService(serRef);
                providersList.add(pp);
                ++n2;
            }
        }
        return providersList;
    }

    public static AccountManager getAccountManager() {
        return accountManager;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }
}

