/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ContactCapabilitiesEvent;
import net.java.sip.communicator.service.protocol.event.ContactCapabilitiesListener;
import net.java.sip.communicator.util.Logger;

public abstract class AbstractOperationSetContactCapabilities<T extends ProtocolProviderService>
implements OperationSetContactCapabilities {
    private static final Logger logger = Logger.getLogger(AbstractOperationSetContactCapabilities.class);
    private final List<ContactCapabilitiesListener> contactCapabilitiesListeners = new LinkedList<ContactCapabilitiesListener>();
    protected final T parentProvider;

    protected AbstractOperationSetContactCapabilities(T parentProvider) {
        if (parentProvider == null) {
            throw new NullPointerException("parentProvider");
        }
        this.parentProvider = parentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContactCapabilitiesListener(ContactCapabilitiesListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<ContactCapabilitiesListener> list = this.contactCapabilitiesListeners;
        synchronized (list) {
            if (!this.contactCapabilitiesListeners.contains(listener)) {
                this.contactCapabilitiesListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContactCapabilitiesEvent(Contact sourceContact, int eventID, Map<String, ? extends OperationSet> opSets) {
        ContactCapabilitiesListener[] listeners;
        List<ContactCapabilitiesListener> list = this.contactCapabilitiesListeners;
        synchronized (list) {
            listeners = this.contactCapabilitiesListeners.toArray(new ContactCapabilitiesListener[this.contactCapabilitiesListeners.size()]);
        }
        if (listeners.length != 0) {
            ContactCapabilitiesEvent event = new ContactCapabilitiesEvent(sourceContact, eventID, opSets);
            ContactCapabilitiesListener[] contactCapabilitiesListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ContactCapabilitiesListener listener = contactCapabilitiesListenerArray[n2];
                switch (eventID) {
                    case 1: {
                        listener.supportedOperationSetsChanged(event);
                        break;
                    }
                    default: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Cannot fire ContactCapabilitiesEvent with unsupported eventID: " + eventID));
                        }
                        throw new IllegalArgumentException("eventID");
                    }
                }
                ++n2;
            }
        }
    }

    public <U extends OperationSet> U getOperationSet(Contact contact, Class<U> opsetClass) {
        return this.getOperationSet(contact, opsetClass, this.isOnline(contact));
    }

    protected <U extends OperationSet> U getOperationSet(Contact contact, Class<U> opsetClass, boolean online) {
        OperationSet opset;
        Map<String, OperationSet> supportedOperationSets = this.getSupportedOperationSets(contact, online);
        if (supportedOperationSets != null && opsetClass.isInstance(opset = supportedOperationSets.get(opsetClass.getName()))) {
            return (U)opset;
        }
        return null;
    }

    @Override
    public Map<String, OperationSet> getSupportedOperationSets(Contact contact) {
        return this.getSupportedOperationSets(contact, this.isOnline(contact));
    }

    protected Map<String, OperationSet> getSupportedOperationSets(Contact contact, boolean online) {
        return this.parentProvider.getSupportedOperationSets();
    }

    protected boolean isOnline(Contact contact) {
        OperationSetPresence opsetPresence = this.parentProvider.getOperationSet(OperationSetPresence.class);
        if (opsetPresence == null) {
            return true;
        }
        PresenceStatus presenceStatus = null;
        Exception exception = null;
        try {
            presenceStatus = opsetPresence.queryContactStatus(contact.getAddress());
        }
        catch (IllegalArgumentException iaex) {
            exception = iaex;
        }
        catch (IllegalStateException isex) {
            exception = isex;
        }
        catch (OperationFailedException ofex) {
            exception = ofex;
        }
        if (presenceStatus == null) {
            presenceStatus = contact.getPresenceStatus();
        }
        if (presenceStatus == null) {
            if (exception != null && logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to query PresenceStatus of Contact " + contact), (Throwable)exception);
            }
            return false;
        }
        return presenceStatus.isOnline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContactCapabilitiesListener(ContactCapabilitiesListener listener) {
        if (listener != null) {
            List<ContactCapabilitiesListener> list = this.contactCapabilitiesListeners;
            synchronized (list) {
                this.contactCapabilitiesListeners.remove(listener);
            }
        }
    }
}

