/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;

public final class AddressUtil {
    private AddressUtil() {
    }

    public static boolean matchAnyInterface(String address, Collection<String> interfaces) {
        if (interfaces == null || interfaces.size() == 0) {
            return false;
        }
        for (String interfaceMask : interfaces) {
            if (!AddressUtil.matchInterface(address, interfaceMask)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchInterface(String address, String interfaceMask) {
        AddressMatcher mask;
        try {
            mask = AddressUtil.getAddressMatcher(interfaceMask);
        }
        catch (Exception e) {
            return false;
        }
        return mask.match(address);
    }

    public static AddressHolder getAddressHolder(String address) {
        return AddressUtil.getAddressHolder(address, -1);
    }

    public static AddressHolder getAddressHolder(String address, int defaultPort) {
        String host;
        int indexBracketStart = address.indexOf(91);
        int indexBracketEnd = address.indexOf(93, indexBracketStart);
        int indexColon = address.indexOf(58);
        int lastIndexColon = address.lastIndexOf(58);
        int port = defaultPort;
        String scopeId = null;
        if (indexColon > -1 && lastIndexColon > indexColon) {
            int indexPercent;
            if (indexBracketStart == 0 && indexBracketEnd > indexBracketStart) {
                host = address.substring(indexBracketStart + 1, indexBracketEnd);
                if (lastIndexColon == indexBracketEnd + 1) {
                    port = Integer.parseInt(address.substring(lastIndexColon + 1));
                }
            } else {
                host = address;
            }
            if ((indexPercent = host.indexOf(37)) != -1) {
                scopeId = host.substring(indexPercent + 1);
                host = host.substring(0, indexPercent);
            }
        } else if (indexColon > 0 && indexColon == lastIndexColon) {
            host = address.substring(0, indexColon);
            port = Integer.parseInt(address.substring(indexColon + 1));
        } else {
            host = address;
        }
        return new AddressHolder(host, port, scopeId);
    }

    public static boolean isIpAddress(String address) {
        try {
            return AddressUtil.getAddressMatcher(address) != null;
        }
        catch (InvalidAddressException e) {
            return false;
        }
    }

    public static InetAddress fixScopeIdAndGetInetAddress(InetAddress inetAddress) throws SocketException {
        Inet6Address inet6Address;
        Inet6Address resultInetAddress = null;
        if (inetAddress instanceof Inet6Address && (inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress()) && (inet6Address = (Inet6Address)inetAddress).getScopeId() <= 0 && inet6Address.getScopedInterface() == null) {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!(address instanceof Inet6Address) || !Arrays.equals(address.getAddress(), inet6Address.getAddress())) continue;
                    if (resultInetAddress != null) {
                        throw new IllegalArgumentException("This address " + inet6Address + " is bound to more than one network interface!");
                    }
                    resultInetAddress = (Inet6Address)address;
                }
            }
        }
        return resultInetAddress == null ? inetAddress : resultInetAddress;
    }

    public static Inet6Address getInetAddressFor(Inet6Address inetAddress, String scope) throws UnknownHostException, SocketException {
        if (inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress()) {
            char[] chars = scope.toCharArray();
            boolean numeric = true;
            for (char c : chars) {
                if (Character.isDigit(c)) continue;
                numeric = false;
                break;
            }
            if (numeric) {
                return Inet6Address.getByAddress(null, inetAddress.getAddress(), Integer.parseInt(scope));
            }
            return Inet6Address.getByAddress(null, inetAddress.getAddress(), NetworkInterface.getByName(scope));
        }
        return inetAddress;
    }

    public static Collection<Inet6Address> getPossibleInetAddressesFor(Inet6Address inet6Address) {
        if ((inet6Address.isSiteLocalAddress() || inet6Address.isLinkLocalAddress()) && inet6Address.getScopeId() <= 0 && inet6Address.getScopedInterface() == null) {
            LinkedList<Inet6Address> possibleAddresses = new LinkedList<Inet6Address>();
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface ni = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = ni.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (address instanceof Inet4Address || (!inet6Address.isLinkLocalAddress() || !address.isLinkLocalAddress()) && (!inet6Address.isSiteLocalAddress() || !address.isSiteLocalAddress())) continue;
                        Inet6Address newAddress = Inet6Address.getByAddress(null, inet6Address.getAddress(), ((Inet6Address)address).getScopeId());
                        possibleAddresses.addFirst(newAddress);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (possibleAddresses.isEmpty()) {
                throw new IllegalArgumentException("Could not find a proper network interface to connect to " + inet6Address);
            }
            return possibleAddresses;
        }
        return Collections.singleton(inet6Address);
    }

    public static Collection<String> getMatchingIpv4Addresses(AddressMatcher addressMatcher) {
        if (addressMatcher.isIPv6()) {
            throw new IllegalArgumentException("Cannot wildcard matching for IPv6: " + addressMatcher);
        }
        HashSet<String> addresses = new HashSet<String>();
        String first3 = addressMatcher.address[0] + "." + addressMatcher.address[1] + "." + addressMatcher.address[2];
        String lastPart = addressMatcher.address[3];
        if ("*".equals(lastPart)) {
            for (int j = 0; j <= 255; ++j) {
                addresses.add(first3 + "." + j);
            }
        } else {
            int dashPos = lastPart.indexOf(45);
            if (dashPos > 0) {
                int start = Integer.parseInt(lastPart.substring(0, dashPos));
                int end = Integer.parseInt(lastPart.substring(dashPos + 1));
                for (int j = start; j <= end; ++j) {
                    addresses.add(first3 + "." + j);
                }
            } else {
                addresses.add(addressMatcher.getAddress());
            }
        }
        return addresses;
    }

    public static AddressMatcher getAddressMatcher(String address) {
        AddressMatcher matcher;
        int indexColon = address.indexOf(58);
        int lastIndexColon = address.lastIndexOf(58);
        int indexDot = address.indexOf(46);
        int lastIndexDot = address.lastIndexOf(46);
        if (indexColon > -1 && lastIndexColon > indexColon) {
            if (indexDot == -1) {
                matcher = new Ip6AddressMatcher();
                AddressUtil.parseIpv6(matcher, address);
            } else {
                if (indexDot >= lastIndexDot) {
                    throw new InvalidAddressException(address);
                }
                int lastIndexColon2 = address.lastIndexOf(58);
                String host2 = address.substring(lastIndexColon2 + 1);
                matcher = new Ip4AddressMatcher();
                AddressUtil.parseIpv4(matcher, host2);
            }
        } else if (indexDot > -1 && lastIndexDot > indexDot && indexColon == -1) {
            matcher = new Ip4AddressMatcher();
            AddressUtil.parseIpv4(matcher, address);
        } else {
            throw new InvalidAddressException(address);
        }
        return matcher;
    }

    private static void parseIpv4(AddressMatcher matcher, String address) {
        String[] parts = address.split("\\.");
        if (parts.length != 4) {
            throw new InvalidAddressException(address);
        }
        for (String part : parts) {
            if (AddressUtil.isValidIpAddressPart(part, false)) continue;
            throw new InvalidAddressException(address);
        }
        matcher.setAddress(parts);
    }

    private static boolean isValidIpAddressPart(String part, boolean ipv6) {
        if (part.length() == 1 && "*".equals(part)) {
            return true;
        }
        int rangeIndex = part.indexOf(45);
        if (rangeIndex > -1 && (rangeIndex != part.lastIndexOf(45) || rangeIndex == part.length() - 1)) {
            return false;
        }
        String[] subParts = rangeIndex > -1 ? part.split("\\-") : new String[]{part};
        for (String subPart : subParts) {
            try {
                int num;
                if (!(ipv6 ? (num = Integer.parseInt(subPart, 16)) > 65535 : (num = Integer.parseInt(subPart)) > 255)) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private static void parseIpv6(AddressMatcher matcher, String address) {
        String[] addressParts;
        String[] parts;
        if (address.indexOf(37) > -1) {
            parts = address.split("\\%");
            address = parts[0];
        }
        parts = address.split("((?<=:)|(?=:))");
        LinkedList<String> ipString = new LinkedList<String>();
        int count = 0;
        int mark = -1;
        for (int i = 0; i < parts.length; ++i) {
            String nextPart;
            String part = parts[i];
            String string = nextPart = i < parts.length - 1 ? parts[i + 1] : null;
            if ("".equals(part)) continue;
            if (":".equals(part) && ":".equals(nextPart)) {
                if (mark != -1) {
                    throw new InvalidAddressException(address);
                }
                mark = count;
                continue;
            }
            if (":".equals(part)) continue;
            ++count;
            ipString.add(part);
        }
        if (mark > -1) {
            int remaining = 8 - count;
            for (int i = 0; i < remaining; ++i) {
                ipString.add(i + mark, "0");
            }
        }
        if (ipString.size() != 8) {
            throw new InvalidAddressException(address);
        }
        for (String part : addressParts = ipString.toArray(new String[ipString.size()])) {
            if (AddressUtil.isValidIpAddressPart(part, true)) continue;
            throw new InvalidAddressException(address);
        }
        matcher.setAddress(addressParts);
    }

    public static class InvalidAddressException
    extends IllegalArgumentException {
        public InvalidAddressException(String s) {
            super("Illegal IP address format: " + s);
        }
    }

    static class Ip6AddressMatcher
    extends AddressMatcher {
        public Ip6AddressMatcher() {
            super(new String[8]);
        }

        @Override
        public boolean isIPv4() {
            return false;
        }

        @Override
        public boolean isIPv6() {
            return true;
        }

        @Override
        public void setAddress(String[] ip) {
            for (int i = 0; i < ip.length; ++i) {
                this.address[i] = ip[i];
            }
        }

        @Override
        public boolean match(AddressMatcher matcher) {
            if (matcher.isIPv4()) {
                return false;
            }
            Ip6AddressMatcher a = (Ip6AddressMatcher)matcher;
            String[] mask = this.address;
            String[] input = a.address;
            return this.match(mask, input, 16);
        }

        @Override
        public String getAddress() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.address.length; ++i) {
                sb.append(this.address[i]);
                if (i == this.address.length - 1) continue;
                sb.append(':');
            }
            return sb.toString();
        }
    }

    static class Ip4AddressMatcher
    extends AddressMatcher {
        public Ip4AddressMatcher() {
            super(new String[4]);
        }

        @Override
        public boolean isIPv4() {
            return true;
        }

        @Override
        public boolean isIPv6() {
            return false;
        }

        @Override
        public void setAddress(String[] ip) {
            for (int i = 0; i < ip.length; ++i) {
                this.address[i] = ip[i];
            }
        }

        @Override
        public boolean match(AddressMatcher matcher) {
            if (matcher.isIPv6()) {
                return false;
            }
            String[] mask = this.address;
            String[] input = ((Ip4AddressMatcher)matcher).address;
            return this.match(mask, input, 10);
        }

        @Override
        public String getAddress() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.address.length; ++i) {
                sb.append(this.address[i]);
                if (i == this.address.length - 1) continue;
                sb.append('.');
            }
            return sb.toString();
        }
    }

    public static abstract class AddressMatcher {
        protected final String[] address;

        protected AddressMatcher(String[] address) {
            this.address = address;
        }

        public abstract boolean isIPv4();

        public abstract boolean isIPv6();

        public abstract void setAddress(String[] var1);

        protected final boolean match(String[] mask, String[] input, int radix) {
            if (input != null && mask != null) {
                for (int i = 0; i < mask.length; ++i) {
                    if (this.doMatch(mask[i], input[i], radix)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        protected final boolean doMatch(String mask, String input, int radix) {
            int dashIndex = mask.indexOf(45);
            int ipa = Integer.parseInt(input, radix);
            if ("*".equals(mask)) {
                return true;
            }
            if (dashIndex != -1) {
                int start = Integer.parseInt(mask.substring(0, dashIndex).trim(), radix);
                int end = Integer.parseInt(mask.substring(dashIndex + 1).trim(), radix);
                if (ipa >= start && ipa <= end) {
                    return true;
                }
            } else {
                int x = Integer.parseInt(mask, radix);
                if (x == ipa) {
                    return true;
                }
            }
            return false;
        }

        public abstract String getAddress();

        public abstract boolean match(AddressMatcher var1);

        public boolean match(String address) {
            try {
                return this.match(AddressUtil.getAddressMatcher(address));
            }
            catch (Exception e) {
                return false;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            sb.append('{');
            sb.append(this.getAddress());
            sb.append('}');
            return sb.toString();
        }
    }

    public static class AddressHolder {
        public final String address;
        public final String scopeId;
        public final int port;

        public AddressHolder(String address, int port, String scopeId) {
            this.address = address;
            this.scopeId = scopeId;
            this.port = port;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("AddressHolder ");
            sb.append('[').append(this.address).append("]:").append(this.port);
            return sb.toString();
        }
    }
}

