/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.executor.ManagedExecutorService;
import com.hazelcast.util.executor.PoolExecutorThreadFactory;
import com.hazelcast.util.executor.ScheduledTaskRunner;
import com.hazelcast.util.executor.SingleExecutorThreadFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ExecutionServiceImpl
implements ExecutionService {
    private final NodeEngineImpl nodeEngine;
    private final ExecutorService cachedExecutorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ExecutorService scheduledManagedExecutor;
    private final ILogger logger;
    private final ConcurrentMap<String, ManagedExecutorService> executors = new ConcurrentHashMap<String, ManagedExecutorService>();
    private final ConstructorFunction<String, ManagedExecutorService> constructor = new ConstructorFunction<String, ManagedExecutorService>(){

        @Override
        public ManagedExecutorService createNew(String name) {
            ExecutorConfig cfg = ExecutionServiceImpl.this.nodeEngine.getConfig().findExecutorConfig(name);
            int queueCapacity = cfg.getQueueCapacity() <= 0 ? Integer.MAX_VALUE : cfg.getQueueCapacity();
            return new ManagedExecutorService(name, ExecutionServiceImpl.this.cachedExecutorService, cfg.getPoolSize(), queueCapacity);
        }
    };

    public ExecutionServiceImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        Node node = nodeEngine.getNode();
        this.logger = node.getLogger(ExecutionService.class.getName());
        ClassLoader classLoader = node.getConfigClassLoader();
        PoolExecutorThreadFactory threadFactory = new PoolExecutorThreadFactory(node.threadGroup, node.getThreadPoolNamePrefix("cached"), classLoader);
        this.cachedExecutorService = new ThreadPoolExecutor(3, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                ExecutionServiceImpl.this.logger.finest("Node is shutting down; discarding the task: " + r);
            }
        });
        String scheduledThreadName = node.getThreadNamePrefix("scheduled");
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new SingleExecutorThreadFactory(node.threadGroup, classLoader, scheduledThreadName));
        this.enableRemoveOnCancelIfAvailable();
        int coreSize = Runtime.getRuntime().availableProcessors();
        this.register("hz:system", coreSize, Integer.MAX_VALUE);
        this.register("hz:operation", coreSize * 2, Integer.MAX_VALUE);
        this.register("hz:async", coreSize * 10, coreSize * 10000);
        this.register("hz:client", coreSize * 10, coreSize * 10000);
        this.scheduledManagedExecutor = this.register("hz:scheduled", coreSize * 5, coreSize * 10000);
    }

    public Set<String> getExecutorNames() {
        return new HashSet<String>(this.executors.keySet());
    }

    private void enableRemoveOnCancelIfAvailable() {
        try {
            Method m = this.scheduledExecutorService.getClass().getMethod("setRemoveOnCancelPolicy", Boolean.TYPE);
            m.invoke((Object)this.scheduledExecutorService, true);
        }
        catch (NoSuchMethodException ignored) {
        }
        catch (InvocationTargetException ignored) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private ExecutorService register(String name, int poolSize, int queueCapacity) {
        ManagedExecutorService executor;
        ExecutorConfig cfg = this.nodeEngine.getConfig().getExecutorConfigs().get(name);
        if (cfg != null) {
            poolSize = cfg.getPoolSize();
            int n = queueCapacity = cfg.getQueueCapacity() <= 0 ? Integer.MAX_VALUE : cfg.getQueueCapacity();
        }
        if (this.executors.putIfAbsent(name, executor = new ManagedExecutorService(name, this.cachedExecutorService, poolSize, queueCapacity)) != null) {
            throw new IllegalArgumentException();
        }
        return executor;
    }

    @Override
    public ManagedExecutorService getExecutor(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.executors, name, this.constructor);
    }

    @Override
    public void execute(String name, Runnable command) {
        this.getExecutor(name).execute(command);
    }

    @Override
    public Future<?> submit(String name, Runnable task) {
        return this.getExecutor(name).submit(task);
    }

    @Override
    public <T> Future<T> submit(String name, Callable<T> task) {
        return this.getExecutor(name).submit(task);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.scheduledExecutorService.schedule(ExecutionServiceImpl.createScheduledRunner(command, this.scheduledManagedExecutor), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutorService.scheduleAtFixedRate(ExecutionServiceImpl.createScheduledRunner(command, this.scheduledManagedExecutor), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutorService.scheduleWithFixedDelay(ExecutionServiceImpl.createScheduledRunner(command, this.scheduledManagedExecutor), initialDelay, period, unit);
    }

    private static ScheduledTaskRunner createScheduledRunner(Runnable command, Executor executor) {
        if (command instanceof ScheduledTaskRunner) {
            return (ScheduledTaskRunner)command;
        }
        return new ScheduledTaskRunner(executor, command);
    }

    @PrivateApi
    public Executor getCachedExecutor() {
        return new ExecutorDelegate(this.cachedExecutorService);
    }

    @Override
    public ScheduledExecutorService getScheduledExecutor() {
        return new ScheduledExecutorServiceDelegate(this.scheduledExecutorService, this.scheduledManagedExecutor);
    }

    @PrivateApi
    void shutdown() {
        this.logger.finest("Stopping executors...");
        this.cachedExecutorService.shutdown();
        this.scheduledExecutorService.shutdownNow();
        try {
            this.cachedExecutorService.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.finest(e);
        }
        for (ManagedExecutorService executorService : this.executors.values()) {
            executorService.shutdown();
        }
        this.executors.clear();
    }

    @Override
    public void shutdownExecutor(String name) {
        ExecutorService ex = (ExecutorService)this.executors.remove(name);
        if (ex != null) {
            ex.shutdown();
        }
    }

    private static class ScheduledExecutorServiceDelegate
    implements ScheduledExecutorService {
        private final ScheduledExecutorService scheduledExecutorService;
        private final ExecutorService executor;

        private ScheduledExecutorServiceDelegate(ScheduledExecutorService scheduledExecutorService, ExecutorService executor) {
            this.scheduledExecutorService = scheduledExecutorService;
            this.executor = executor;
        }

        @Override
        public void execute(Runnable command) {
            this.executor.execute(command);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.executor.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.executor.submit(task, result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.executor.submit(task);
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.scheduledExecutorService.schedule(ExecutionServiceImpl.createScheduledRunner(command, this.executor), delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.scheduledExecutorService.scheduleAtFixedRate(ExecutionServiceImpl.createScheduledRunner(command, this.executor), initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.scheduledExecutorService.scheduleWithFixedDelay(ExecutionServiceImpl.createScheduledRunner(command, this.executor), initialDelay, delay, unit);
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ExecutorDelegate
    implements Executor {
        private final Executor executor;

        private ExecutorDelegate(Executor executor) {
            this.executor = executor;
        }

        @Override
        public void execute(Runnable command) {
            this.executor.execute(command);
        }
    }
}

