/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.CachedRow;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowOutputBinary
extends RowOutputBase {
    private static final int INT_STORE_SIZE = 4;
    int storageSize;

    public RowOutputBinary() {
    }

    public RowOutputBinary(int n) {
        super(n);
    }

    public RowOutputBinary(byte[] byArray) {
        super(byArray);
    }

    public void writeIntData(int n) throws IOException {
        this.writeInt(n);
    }

    public void writeIntData(int n, int n2) throws IOException {
        int n3 = this.count;
        this.count = n2;
        this.writeInt(n);
        if (this.count < n3) {
            this.count = n3;
        }
    }

    public void writeLongData(long l) throws IOException {
        this.writeLong(l);
    }

    public void writeEnd() throws IOException {
        while (this.count < this.storageSize) {
            this.write(0);
        }
    }

    public void writeSize(int n) throws IOException {
        this.storageSize = n;
        this.writeInt(n);
    }

    public void writeType(int n) throws IOException {
        this.writeShort(n);
    }

    public void writeString(String string) throws IOException {
        int n = this.count;
        this.writeInt(0);
        int n2 = StringConverter.writeUTF(string, this);
        this.writeIntData(this.count - n - 4, n);
    }

    public int getSize(CachedRow cachedRow) {
        Object[] objectArray = cachedRow.getData();
        int[] nArray = cachedRow.getTable().getColumnTypes();
        int n = cachedRow.getTable().getColumnCount();
        return 4 + RowOutputBinary.getSize(objectArray, n, nArray);
    }

    public static int getRowSize(CachedRow cachedRow) {
        Object[] objectArray = cachedRow.getData();
        int[] nArray = cachedRow.getTable().getColumnTypes();
        int n = cachedRow.getTable().getColumnCount();
        return RowOutputBinary.getSize(objectArray, n, nArray);
    }

    protected void writeFieldType(int n) throws IOException {
        this.write(1);
    }

    protected void writeNull(int n) throws IOException {
        this.write(0);
    }

    protected void writeChar(String string, int n) throws IOException {
        this.writeString(string);
    }

    protected void writeSmallint(Number number) throws IOException, HsqlException {
        this.writeShort(number.intValue());
    }

    protected void writeInteger(Number number) throws IOException, HsqlException {
        this.writeInt(number.intValue());
    }

    protected void writeBigint(Number number) throws IOException, HsqlException {
        this.writeLong(number.longValue());
    }

    protected void writeReal(Double d, int n) throws IOException, HsqlException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    protected void writeDecimal(BigDecimal bigDecimal) throws IOException, HsqlException {
        int n = bigDecimal.scale();
        BigInteger bigInteger = JavaSystem.getUnscaledValue(bigDecimal);
        byte[] byArray = bigInteger.toByteArray();
        this.writeByteArray(byArray);
        this.writeInt(n);
    }

    protected void writeBit(Boolean bl) throws IOException, HsqlException {
        this.write(bl != false ? 1 : 0);
    }

    protected void writeDate(Date date) throws IOException, HsqlException {
        this.writeLong(date.getTime());
    }

    protected void writeTime(Time time) throws IOException, HsqlException {
        this.writeLong(time.getTime());
    }

    protected void writeTimestamp(Timestamp timestamp) throws IOException, HsqlException {
        this.writeLong(timestamp.getTime());
        this.writeInt(timestamp.getNanos());
    }

    protected void writeOther(JavaObject javaObject) throws IOException, HsqlException {
        this.writeByteArray(javaObject.getBytes());
    }

    protected void writeBinary(Binary binary, int n) throws IOException, HsqlException {
        this.writeByteArray(binary.getBytes());
    }

    protected void writeByteArray(byte[] byArray) throws IOException {
        this.writeInt(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    private static int getSize(Object[] objectArray, int n, int[] nArray) {
        int n2 = 0;
        block12: for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            ++n2;
            if (object == null) continue;
            switch (nArray[i]) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 100: {
                    n2 += 4;
                    n2 += StringConverter.getUTFSize((String)object);
                    continue block12;
                }
                case -6: 
                case 5: {
                    n2 += 2;
                    continue block12;
                }
                case 4: {
                    n2 += 4;
                    continue block12;
                }
                case -5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 += 8;
                    continue block12;
                }
                case 2: 
                case 3: {
                    n2 += 8;
                    BigDecimal bigDecimal = (BigDecimal)object;
                    BigInteger bigInteger = JavaSystem.getUnscaledValue(bigDecimal);
                    n2 += bigInteger.toByteArray().length;
                    continue block12;
                }
                case 16: {
                    ++n2;
                    continue block12;
                }
                case 91: 
                case 92: {
                    n2 += 8;
                    continue block12;
                }
                case 93: {
                    n2 += 12;
                    continue block12;
                }
                case -4: 
                case -3: 
                case -2: {
                    n2 += 4;
                    n2 += ((Binary)object).getBytesLength();
                    continue block12;
                }
                case 1111: {
                    JavaObject javaObject = (JavaObject)object;
                    n2 += 4;
                    n2 += javaObject.getBytesLength();
                    continue block12;
                }
                default: {
                    Trace.printSystemOut("20 " + Types.getTypeString(nArray[i]));
                }
            }
        }
        return n2;
    }

    public void ensureRoom(int n) {
        super.ensureRoom(n);
    }

    public void reset() {
        super.reset();
        this.storageSize = 0;
    }

    public void reset(int n) {
        super.reset(n);
        this.storageSize = 0;
    }

    public void setBuffer(byte[] byArray) {
        this.buf = byArray;
        this.reset();
    }
}

