/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.regexp.Regexp;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

public class RegexpFactory
extends RegexpMatcherFactory {
    public Regexp newRegexp() throws BuildException {
        return this.newRegexp(null);
    }

    public Regexp newRegexp(Project project) throws BuildException {
        String string = null;
        string = project == null ? System.getProperty("ant.regexp.regexpimpl") : project.getProperty("ant.regexp.regexpimpl");
        if (string != null) {
            return this.createRegexpInstance(string);
        }
        try {
            this.testAvailability("java.util.regex.Matcher");
            return this.createRegexpInstance("org.apache.tools.ant.util.regexp.Jdk14RegexpRegexp");
        }
        catch (BuildException buildException) {
            try {
                this.testAvailability("org.apache.oro.text.regex.Pattern");
                return this.createRegexpInstance("org.apache.tools.ant.util.regexp.JakartaOroRegexp");
            }
            catch (BuildException buildException2) {
                try {
                    this.testAvailability("org.apache.regexp.RE");
                    return this.createRegexpInstance("org.apache.tools.ant.util.regexp.JakartaRegexpRegexp");
                }
                catch (BuildException buildException3) {
                    throw new BuildException("No supported regular expression matcher found");
                }
            }
        }
    }

    protected Regexp createRegexpInstance(String string) throws BuildException {
        RegexpMatcher regexpMatcher = this.createInstance(string);
        if (regexpMatcher instanceof Regexp) {
            return (Regexp)regexpMatcher;
        }
        throw new BuildException(string + " doesn't implement the Regexp interface");
    }
}

